/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CEqual
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term1;
    private final ITerm term2;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    private volatile int hashCode;

    public CEqual(ITerm term1, ITerm term2) {
        this(term1, term2, null, null);
    }

    public CEqual(ITerm term1, ITerm term2, @Nullable IMessage message) {
        this(term1, term2, null, message);
    }

    public CEqual(ITerm term1, ITerm term2, @Nullable IConstraint cause) {
        this(term1, term2, cause, null);
    }

    private CEqual(ITerm term1, ITerm term2, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.term1 = term1;
        this.term2 = term2;
        this.cause = cause;
        this.message = message;
    }

    public ITerm term1() {
        return this.term1;
    }

    public ITerm term2() {
        return this.term2;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CEqual withCause(@Nullable IConstraint cause) {
        return new CEqual(this.term1, this.term2, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CEqual withMessage(@Nullable IMessage message) {
        return new CEqual(this.term1, this.term2, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseEqual(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseEqual(this);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.term1.getVars().forEach(onFreeVar::apply);
        this.term2.getVars().forEach(onFreeVar::apply);
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CEqual apply(ISubstitution.Immutable subst) {
        return new CEqual(subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CEqual unsafeApply(ISubstitution.Immutable subst) {
        return new CEqual(subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CEqual apply(IRenaming subst) {
        return new CEqual(subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(termToString.format(this.term1));
        sb.append(" == ");
        sb.append(termToString.format(this.term2));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CEqual cEqual = (CEqual)o;
        return Objects.equals(this.term1, cEqual.term1) && Objects.equals(this.term2, cEqual.term2) && Objects.equals(this.cause, cEqual.cause) && Objects.equals(this.message, cEqual.message);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.term1, this.term2, this.cause, this.message);
        }
        return result;
    }
}

