/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CAstId
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term;
    private final ITerm idTerm;
    @Nullable
    private final IConstraint cause;
    private volatile int hashCode;

    public CAstId(ITerm term, ITerm idTerm) {
        this(term, idTerm, null);
    }

    public CAstId(ITerm term, ITerm idTerm, @Nullable IConstraint cause) {
        this.term = term;
        this.idTerm = idTerm;
        this.cause = cause;
    }

    public ITerm astTerm() {
        return this.term;
    }

    public ITerm idTerm() {
        return this.idTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CAstId withCause(@Nullable IConstraint cause) {
        return new CAstId(this.term, this.idTerm, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTermId(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTermId(this);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.term.getVars().forEach(onFreeVar::apply);
        this.idTerm.getVars().forEach(onFreeVar::apply);
    }

    @Override
    public CAstId apply(ISubstitution.Immutable subst) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause);
    }

    @Override
    public CAstId unsafeApply(ISubstitution.Immutable subst) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause);
    }

    @Override
    public CAstId apply(IRenaming subst) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("termId(");
        sb.append(termToString.format(this.term));
        sb.append(", ");
        sb.append(termToString.format(this.idTerm));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAstId cAstId = (CAstId)o;
        return Objects.equals(this.term, cAstId.term) && Objects.equals(this.idTerm, cAstId.idTerm) && Objects.equals(this.cause, cAstId.cause);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.term, this.idTerm, this.cause);
        }
        return result;
    }
}

