/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent.util;

import com.google.common.collect.Streams;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;

public class VarIndexedCollection<V> {
    private final SetMultimap.Transient<ITermVar, Entry> index = SetMultimap.Transient.of();

    public Set.Immutable<Entry> get(ITermVar indexVar) {
        return this.index.get((Object)indexVar);
    }

    public boolean put(V value, Iterable<ITermVar> indexVars, IUnifier unifier) {
        Set vars = (Set)Streams.stream(indexVars).flatMap(v -> unifier.getVars((ITerm)v).stream()).collect(CapsuleCollectors.toSet());
        Entry entry = new Entry(value);
        for (ITermVar var : vars) {
            this.index.__insert((Object)var, (Object)entry.inc());
        }
        return !vars.isEmpty();
    }

    public Set.Immutable<V> update(Iterable<ITermVar> indexVars, IUnifier unifier) {
        Set.Transient done = CapsuleUtil.transientSet();
        for (ITermVar indexVar : indexVars) {
            this.update(indexVar, unifier, done);
        }
        return done.freeze();
    }

    public Set.Immutable<V> update(ITermVar indexVar, IUnifier unifier) {
        Set.Transient done = CapsuleUtil.transientSet();
        this.update(indexVar, unifier, done);
        return done.freeze();
    }

    private void update(ITermVar indexVar, IUnifier unifier, Set.Transient<V> done) {
        Set.Immutable<ITermVar> vars = unifier.getVars(indexVar);
        Set.Immutable entries = this.index.get((Object)indexVar);
        this.index.__remove((Object)indexVar);
        for (Entry entry : entries) {
            entry.dec();
            for (ITermVar var : vars) {
                this.index.__insert((Object)var, (Object)entry.inc());
            }
            if (entry.refcount() != 0) continue;
            done.__insert(entry.value);
        }
    }

    public class Entry {
        private final V value;
        private int refcount;

        public Entry(V value) {
            this.value = value;
            this.refcount = 0;
        }

        public V value() {
            return this.value;
        }

        public int refcount() {
            return this.refcount;
        }

        public Entry dec() {
            --this.refcount;
            return this;
        }

        public Entry inc() {
            ++this.refcount;
            return this;
        }
    }
}

