/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.statix.concurrent.AUnitResult;
import mb.statix.concurrent.IStatixResult;
import mb.statix.solver.persistent.SolverResult;

public final class UnitResult
extends AUnitResult {
    private final String resource;
    @Nullable
    private final SolverResult solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;

    private UnitResult(String resource, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private UnitResult(UnitResult original, String resource, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    @Nullable
    public SolverResult solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final UnitResult withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new UnitResult(this, newValue, this.solveResult, this.exception);
    }

    public final UnitResult withSolveResult(@Nullable SolverResult value) {
        if (this.solveResult == value) {
            return this;
        }
        return new UnitResult(this, this.resource, value, this.exception);
    }

    public final UnitResult withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new UnitResult(this, this.resource, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnitResult && this.equalTo((UnitResult)another);
    }

    private boolean equalTo(UnitResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnitResult").omitNullValues().add("resource", (Object)this.resource).add("solveResult", (Object)this.solveResult).add("exception", (Object)this.exception).toString();
    }

    public static UnitResult of(String resource, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        return new UnitResult(resource, solveResult, exception);
    }

    public static UnitResult copyOf(AUnitResult instance) {
        if (instance instanceof UnitResult) {
            return (UnitResult)instance;
        }
        return UnitResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ UnitResult(UnitResult unitResult, String string, SolverResult solverResult, Throwable throwable, UnitResult unitResult2) {
        this(unitResult, string, solverResult, throwable);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private String resource;
        private SolverResult solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder from(IStatixResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AUnitResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SolverResult solveResultValue;
            Throwable exceptionValue;
            IStatixResult instance;
            long bits = 0L;
            if (object instanceof IStatixResult) {
                instance = (IStatixResult)object;
                if ((bits & 1L) == 0L) {
                    exceptionValue = instance.exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = instance.solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AUnitResult) {
                instance = (AUnitResult)object;
                if ((bits & 1L) == 0L) {
                    exceptionValue = ((AUnitResult)instance).exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                this.resource(((AUnitResult)instance).resource());
                if ((bits & 2L) == 0L) {
                    solveResultValue = ((AUnitResult)instance).solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder solveResult(@Nullable SolverResult solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public UnitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitResult(null, this.resource, this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build UnitResult, some of required attributes are not set " + attributes;
        }
    }
}

