/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.statix.concurrent.AStatixUnit;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.spec.Rule;

public final class StatixUnit
extends AStatixUnit {
    private final String resource;
    private final Rule rule;
    private transient int hashCode;

    private StatixUnit(String resource, Optional<? extends Rule> rule) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.rule = rule.orElse(null);
    }

    private StatixUnit(StatixUnit original, String resource, Rule rule) {
        this.resource = resource;
        this.rule = rule;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    public final StatixUnit withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixUnit(this, newValue, this.rule);
    }

    public final StatixUnit withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixUnit(this, this.resource, newValue);
    }

    public final StatixUnit withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixUnit(this, this.resource, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixUnit && this.equalTo((StatixUnit)another);
    }

    private boolean equalTo(StatixUnit another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.rule, another.rule);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        return h;
    }

    public static StatixUnit of(String resource, Optional<? extends Rule> rule) {
        return new StatixUnit(resource, rule);
    }

    public static StatixUnit copyOf(AStatixUnit instance) {
        if (instance instanceof StatixUnit) {
            return (StatixUnit)instance;
        }
        return StatixUnit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixUnit(StatixUnit statixUnit, String string, Rule rule, StatixUnit statixUnit2) {
        this(statixUnit, string, rule);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private String resource;
        private Rule rule;

        private Builder() {
        }

        public final Builder from(IStatixUnit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AStatixUnit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Rule> ruleOptional;
            IStatixUnit instance;
            long bits = 0L;
            if (object instanceof IStatixUnit) {
                instance = (IStatixUnit)object;
                if ((bits & 1L) == 0L) {
                    this.resource(instance.resource());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ruleOptional = instance.rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AStatixUnit) {
                instance = (AStatixUnit)object;
                if ((bits & 1L) == 0L) {
                    this.resource(((AStatixUnit)instance).resource());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ruleOptional = ((AStatixUnit)instance).rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public StatixUnit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixUnit(null, this.resource, this.rule, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build StatixUnit, some of required attributes are not set " + attributes;
        }
    }
}

