/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mb.statix.concurrent.AStatixGroup;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.spec.Rule;

public final class StatixGroup
extends AStatixGroup {
    private final Rule rule;
    private final ImmutableMap<String, IStatixGroup> groups;
    private final ImmutableMap<String, IStatixUnit> units;
    private transient int hashCode;

    private StatixGroup(Optional<? extends Rule> rule, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units) {
        this.rule = rule.orElse(null);
        this.groups = ImmutableMap.copyOf(groups);
        this.units = ImmutableMap.copyOf(units);
    }

    private StatixGroup(StatixGroup original, Rule rule, ImmutableMap<String, IStatixGroup> groups, ImmutableMap<String, IStatixUnit> units) {
        this.rule = rule;
        this.groups = groups;
        this.units = units;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    public ImmutableMap<String, IStatixGroup> groups() {
        return this.groups;
    }

    public ImmutableMap<String, IStatixUnit> units() {
        return this.units;
    }

    public final StatixGroup withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixGroup(this, newValue, this.groups, this.units);
    }

    public final StatixGroup withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixGroup(this, value, this.groups, this.units);
    }

    public final StatixGroup withGroups(Map<String, ? extends IStatixGroup> entries) {
        if (this.groups == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixGroup(this, this.rule, (ImmutableMap<String, IStatixGroup>)newValue, this.units);
    }

    public final StatixGroup withUnits(Map<String, ? extends IStatixUnit> entries) {
        if (this.units == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixGroup(this, this.rule, this.groups, (ImmutableMap<String, IStatixUnit>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixGroup && this.equalTo((StatixGroup)another);
    }

    private boolean equalTo(StatixGroup another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.rule, another.rule) && this.groups.equals(another.groups) && this.units.equals(another.units);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.units.hashCode();
        return h;
    }

    public static StatixGroup of(Optional<? extends Rule> rule, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units) {
        return new StatixGroup(rule, groups, units);
    }

    public static StatixGroup copyOf(AStatixGroup instance) {
        if (instance instanceof StatixGroup) {
            return (StatixGroup)instance;
        }
        return StatixGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixGroup(StatixGroup statixGroup, Rule rule, ImmutableMap immutableMap, ImmutableMap immutableMap2, StatixGroup statixGroup2) {
        this(statixGroup, rule, (ImmutableMap<String, IStatixGroup>)immutableMap, (ImmutableMap<String, IStatixUnit>)immutableMap2);
    }

    public static final class Builder {
        private Rule rule;
        private ImmutableMap.Builder<String, IStatixGroup> groups = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IStatixUnit> units = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(IStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Rule> ruleOptional;
            IStatixGroup instance;
            long bits = 0L;
            if (object instanceof IStatixGroup) {
                instance = (IStatixGroup)object;
                if ((bits & 1L) == 0L) {
                    ruleOptional = instance.rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllGroups(instance.groups());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllUnits(instance.units());
                    bits |= 4L;
                }
            }
            if (object instanceof AStatixGroup) {
                instance = (AStatixGroup)object;
                if ((bits & 1L) == 0L) {
                    ruleOptional = ((AStatixGroup)instance).rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllGroups(((AStatixGroup)instance).groups());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllUnits(((AStatixGroup)instance).units());
                    bits |= 4L;
                }
            }
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder putGroups(String key, IStatixGroup value) {
            this.groups.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putGroups(Map.Entry<String, ? extends IStatixGroup> entry) {
            this.groups.put(entry);
            return this;
        }

        public final Builder groups(Map<String, ? extends IStatixGroup> entries) {
            this.groups = ImmutableMap.builder();
            return this.putAllGroups(entries);
        }

        public final Builder putAllGroups(Map<String, ? extends IStatixGroup> entries) {
            this.groups.putAll(entries);
            return this;
        }

        public final Builder putUnits(String key, IStatixUnit value) {
            this.units.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putUnits(Map.Entry<String, ? extends IStatixUnit> entry) {
            this.units.put(entry);
            return this;
        }

        public final Builder units(Map<String, ? extends IStatixUnit> entries) {
            this.units = ImmutableMap.builder();
            return this.putAllUnits(entries);
        }

        public final Builder putAllUnits(Map<String, ? extends IStatixUnit> entries) {
            this.units.putAll(entries);
            return this;
        }

        public StatixGroup build() {
            return new StatixGroup(null, this.rule, this.groups.build(), this.units.build(), null);
        }
    }
}

