/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

public class ProjectTypeChecker
extends AbstractTypeChecker<ProjectResult> {
    private static final ILogger logger = LoggerUtils.logger(ProjectTypeChecker.class);
    private final IStatixProject project;

    public ProjectTypeChecker(IStatixProject project, Spec spec, IDebugContext debug) {
        super(spec, debug);
        this.project = project;
    }

    @Override
    public IFuture<ProjectResult> run(ITypeCheckerContext<Scope, ITerm, ITerm> context, List<Scope> rootScopes) {
        Scope projectScope = this.makeSharedScope(context, "s_prj");
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Unit>>> libraryResults = this.runLibraries(context, this.project.libraries(), projectScope);
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>> groupResults = this.runGroups(context, this.project.groups(), projectScope);
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>> unitResults = this.runUnits(context, this.project.units(), projectScope);
        context.closeScope(projectScope);
        IFuture<SolverResult> result = this.runSolver(context, this.project.rule(), Arrays.asList(projectScope));
        return AggregateFuture.apply(libraryResults, groupResults, unitResults, result).thenApply(e -> ProjectResult.of(this.project.resource(), (Map)e._1(), (Map)e._2(), (Map)e._3(), (SolverResult)e._4(), null)).whenComplete((r, ex) -> logger.debug("project {}: returned.", context.id()));
    }
}

