/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.AProjectResult;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.SolverResult;
import org.metaborg.util.unit.Unit;

public final class ProjectResult
extends AProjectResult {
    private final String resource;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults;
    @Nullable
    private final SolverResult solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;

    private ProjectResult(String resource, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.libraryResults = ImmutableMap.copyOf(libraryResults);
        this.groupResults = ImmutableMap.copyOf(groupResults);
        this.unitResults = ImmutableMap.copyOf(unitResults);
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private ProjectResult(ProjectResult original, String resource, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.libraryResults = libraryResults;
        this.groupResults = groupResults;
        this.unitResults = unitResults;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults() {
        return this.libraryResults;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults() {
        return this.groupResults;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults() {
        return this.unitResults;
    }

    @Override
    @Nullable
    public SolverResult solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final ProjectResult withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new ProjectResult(this, newValue, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult withLibraryResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> entries) {
        if (this.libraryResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ProjectResult(this, this.resource, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Unit>>)newValue, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult withGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
        if (this.groupResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ProjectResult(this, this.resource, this.libraryResults, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>)newValue, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult withUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
        if (this.unitResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ProjectResult(this, this.resource, this.libraryResults, this.groupResults, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>)newValue, this.solveResult, this.exception);
    }

    public final ProjectResult withSolveResult(@Nullable SolverResult value) {
        if (this.solveResult == value) {
            return this;
        }
        return new ProjectResult(this, this.resource, this.libraryResults, this.groupResults, this.unitResults, value, this.exception);
    }

    public final ProjectResult withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new ProjectResult(this, this.resource, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProjectResult && this.equalTo((ProjectResult)another);
    }

    private boolean equalTo(ProjectResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.libraryResults.equals(another.libraryResults) && this.groupResults.equals(another.groupResults) && this.unitResults.equals(another.unitResults) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.libraryResults.hashCode();
        h += (h << 5) + this.groupResults.hashCode();
        h += (h << 5) + this.unitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectResult").omitNullValues().add("resource", (Object)this.resource).add("libraryResults", this.libraryResults).add("groupResults", this.groupResults).add("unitResults", this.unitResults).add("solveResult", (Object)this.solveResult).add("exception", (Object)this.exception).toString();
    }

    public static ProjectResult of(String resource, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        return new ProjectResult(resource, libraryResults, groupResults, unitResults, solveResult, exception);
    }

    public static ProjectResult copyOf(AProjectResult instance) {
        if (instance instanceof ProjectResult) {
            return (ProjectResult)instance;
        }
        return ProjectResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ProjectResult(ProjectResult projectResult, String string, ImmutableMap immutableMap, ImmutableMap immutableMap2, ImmutableMap immutableMap3, SolverResult solverResult, Throwable throwable, ProjectResult projectResult2) {
        this(projectResult, string, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Unit>>)immutableMap, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>)immutableMap2, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>)immutableMap3, solverResult, throwable);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private String resource;
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults = ImmutableMap.builder();
        private SolverResult solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder from(IStatixResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AProjectResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SolverResult solveResultValue;
            Throwable exceptionValue;
            IStatixResult instance;
            long bits = 0L;
            if (object instanceof IStatixResult) {
                instance = (IStatixResult)object;
                if ((bits & 1L) == 0L) {
                    exceptionValue = instance.exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = instance.solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AProjectResult) {
                instance = (AProjectResult)object;
                this.putAllGroupResults(((AProjectResult)instance).groupResults());
                if ((bits & 1L) == 0L) {
                    exceptionValue = ((AProjectResult)instance).exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = ((AProjectResult)instance).solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
                this.putAllUnitResults(((AProjectResult)instance).unitResults());
                this.resource(((AProjectResult)instance).resource());
                this.putAllLibraryResults(((AProjectResult)instance).libraryResults());
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putLibraryResults(String key, IUnitResult<Scope, ITerm, ITerm, Unit> value) {
            this.libraryResults.put((Object)key, value);
            return this;
        }

        public final Builder putLibraryResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> entry) {
            this.libraryResults.put(entry);
            return this;
        }

        public final Builder libraryResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> entries) {
            this.libraryResults = ImmutableMap.builder();
            return this.putAllLibraryResults(entries);
        }

        public final Builder putAllLibraryResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Unit>> entries) {
            this.libraryResults.putAll(entries);
            return this;
        }

        public final Builder putGroupResults(String key, IUnitResult<Scope, ITerm, ITerm, GroupResult> value) {
            this.groupResults.put((Object)key, value);
            return this;
        }

        public final Builder putGroupResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entry) {
            this.groupResults.put(entry);
            return this;
        }

        public final Builder groupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
            this.groupResults = ImmutableMap.builder();
            return this.putAllGroupResults(entries);
        }

        public final Builder putAllGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
            this.groupResults.putAll(entries);
            return this;
        }

        public final Builder putUnitResults(String key, IUnitResult<Scope, ITerm, ITerm, UnitResult> value) {
            this.unitResults.put((Object)key, value);
            return this;
        }

        public final Builder putUnitResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entry) {
            this.unitResults.put(entry);
            return this;
        }

        public final Builder unitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
            this.unitResults = ImmutableMap.builder();
            return this.putAllUnitResults(entries);
        }

        public final Builder putAllUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
            this.unitResults.putAll(entries);
            return this;
        }

        public final Builder solveResult(@Nullable SolverResult solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ProjectResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ProjectResult(null, this.resource, this.libraryResults.build(), this.groupResults.build(), this.unitResults.build(), this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build ProjectResult, some of required attributes are not set " + attributes;
        }
    }
}

