/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class GroupTypeChecker
extends AbstractTypeChecker<GroupResult> {
    private static final ILogger logger = LoggerUtils.logger(GroupTypeChecker.class);
    private final IStatixGroup group;

    public GroupTypeChecker(IStatixGroup group, Spec spec, IDebugContext debug) {
        super(spec, debug);
        this.group = group;
    }

    @Override
    public IFuture<GroupResult> run(ITypeCheckerContext<Scope, ITerm, ITerm> context, List<Scope> rootScopes) {
        Scope parentScope = rootScopes.get(0);
        Scope thisGroupScope = this.makeSharedScope(context, "s_grp");
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>> groupResults = this.runGroups(context, this.group.groups(), thisGroupScope);
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>> unitResults = this.runUnits(context, this.group.units(), thisGroupScope);
        context.closeScope(thisGroupScope);
        IFuture<SolverResult> result = this.runSolver(context, this.group.rule(), Arrays.asList(parentScope, thisGroupScope));
        return AggregateFuture.apply(groupResults, unitResults, result).thenApply(e -> GroupResult.of((Map)e._1(), (Map)e._2(), (SolverResult)e._3(), null)).whenComplete((r, ex) -> logger.debug("group {}: returned.", context.id()));
    }
}

