/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.AGroupResult;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.SolverResult;

public final class GroupResult
extends AGroupResult {
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults;
    @Nullable
    private final SolverResult solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;

    private GroupResult(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.groupResults = ImmutableMap.copyOf(groupResults);
        this.unitResults = ImmutableMap.copyOf(unitResults);
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private GroupResult(GroupResult original, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.groupResults = groupResults;
        this.unitResults = unitResults;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults() {
        return this.groupResults;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults() {
        return this.unitResults;
    }

    @Override
    @Nullable
    public SolverResult solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final GroupResult withGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
        if (this.groupResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new GroupResult(this, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>)newValue, this.unitResults, this.solveResult, this.exception);
    }

    public final GroupResult withUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
        if (this.unitResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new GroupResult(this, this.groupResults, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>)newValue, this.solveResult, this.exception);
    }

    public final GroupResult withSolveResult(@Nullable SolverResult value) {
        if (this.solveResult == value) {
            return this;
        }
        return new GroupResult(this, this.groupResults, this.unitResults, value, this.exception);
    }

    public final GroupResult withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new GroupResult(this, this.groupResults, this.unitResults, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupResult && this.equalTo((GroupResult)another);
    }

    private boolean equalTo(GroupResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.groupResults.equals(another.groupResults) && this.unitResults.equals(another.unitResults) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.groupResults.hashCode();
        h += (h << 5) + this.unitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GroupResult").omitNullValues().add("groupResults", this.groupResults).add("unitResults", this.unitResults).add("solveResult", (Object)this.solveResult).add("exception", (Object)this.exception).toString();
    }

    public static GroupResult of(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        return new GroupResult(groupResults, unitResults, solveResult, exception);
    }

    public static GroupResult copyOf(AGroupResult instance) {
        if (instance instanceof GroupResult) {
            return (GroupResult)instance;
        }
        return GroupResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ GroupResult(GroupResult groupResult, ImmutableMap immutableMap, ImmutableMap immutableMap2, SolverResult solverResult, Throwable throwable, GroupResult groupResult2) {
        this(groupResult, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>)immutableMap, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>)immutableMap2, solverResult, throwable);
    }

    public static final class Builder {
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>> groupResults = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>> unitResults = ImmutableMap.builder();
        private SolverResult solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder from(IStatixResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AGroupResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SolverResult solveResultValue;
            Throwable exceptionValue;
            IStatixResult instance;
            long bits = 0L;
            if (object instanceof IStatixResult) {
                instance = (IStatixResult)object;
                if ((bits & 1L) == 0L) {
                    exceptionValue = instance.exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = instance.solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AGroupResult) {
                instance = (AGroupResult)object;
                this.putAllGroupResults(((AGroupResult)instance).groupResults());
                if ((bits & 1L) == 0L) {
                    exceptionValue = ((AGroupResult)instance).exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = ((AGroupResult)instance).solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
                this.putAllUnitResults(((AGroupResult)instance).unitResults());
            }
        }

        public final Builder putGroupResults(String key, IUnitResult<Scope, ITerm, ITerm, GroupResult> value) {
            this.groupResults.put((Object)key, value);
            return this;
        }

        public final Builder putGroupResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entry) {
            this.groupResults.put(entry);
            return this;
        }

        public final Builder groupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
            this.groupResults = ImmutableMap.builder();
            return this.putAllGroupResults(entries);
        }

        public final Builder putAllGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, GroupResult>> entries) {
            this.groupResults.putAll(entries);
            return this;
        }

        public final Builder putUnitResults(String key, IUnitResult<Scope, ITerm, ITerm, UnitResult> value) {
            this.unitResults.put((Object)key, value);
            return this;
        }

        public final Builder putUnitResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entry) {
            this.unitResults.put(entry);
            return this;
        }

        public final Builder unitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
            this.unitResults = ImmutableMap.builder();
            return this.putAllUnitResults(entries);
        }

        public final Builder putAllUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, UnitResult>> entries) {
            this.unitResults.putAll(entries);
            return this;
        }

        public final Builder solveResult(@Nullable SolverResult solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public GroupResult build() {
            return new GroupResult(null, this.groupResults.build(), this.unitResults.build(), this.solveResult, this.exception, null);
        }
    }
}

