/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.GroupTypeChecker;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixLibrary;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.concurrent.StatixSolver;
import mb.statix.concurrent.UnitResult;
import mb.statix.concurrent.UnitTypeChecker;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.Delay;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public abstract class AbstractTypeChecker<R>
implements ITypeChecker<Scope, ITerm, ITerm, R> {
    private static final ILogger logger = LoggerUtils.logger(AbstractTypeChecker.class);
    protected final Spec spec;
    protected final IDebugContext debug;
    private StatixSolver solver;
    private IFuture<SolverResult> solveResult;

    protected AbstractTypeChecker(Spec spec, IDebugContext debug) {
        this.spec = spec;
        this.debug = debug;
    }

    protected Scope makeSharedScope(ITypeCheckerContext<Scope, ITerm, ITerm> context, String name2) {
        Scope s = context.freshScope(name2, Collections.emptyList(), true, true);
        context.setDatum(s, s);
        context.shareLocal(s);
        return s;
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, GroupResult>>> runGroups(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixGroup> groups, Scope parentScope) {
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixGroup> entry : groups.entrySet()) {
            String key = entry.getKey();
            IFuture<IUnitResult<Scope, ITerm, ITerm, GroupResult>> result = context.add(key, new GroupTypeChecker(entry.getValue(), this.spec, this.debug), Arrays.asList(parentScope));
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: group {} returned.", context.id(), key)));
        }
        return new AggregateFuture(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all groups returned.", context.id()));
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, UnitResult>>> runUnits(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixUnit> units, Scope parentScope) {
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixUnit> entry : units.entrySet()) {
            String key = entry.getKey();
            IFuture<IUnitResult<Scope, ITerm, ITerm, UnitResult>> result = context.add(key, new UnitTypeChecker(entry.getValue(), this.spec, this.debug), Arrays.asList(parentScope));
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: unit {} returned.", context.id(), key)));
        }
        return new AggregateFuture(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all units returned.", context.id()));
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Unit>>> runLibraries(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixLibrary> libraries, Scope parentScope) {
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixLibrary> entry : libraries.entrySet()) {
            String key = entry.getKey();
            IStatixLibrary library = entry.getValue();
            IFuture<IUnitResult<Scope, ITerm, ITerm, Unit>> result = context.add(key, library, Arrays.asList(parentScope));
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: group {} returned.", context.id(), key)));
        }
        return new AggregateFuture(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all groups returned.", context.id()));
    }

    protected IFuture<SolverResult> runSolver(ITypeCheckerContext<Scope, ITerm, ITerm> context, Optional<Rule> rule, List<Scope> scopes) {
        ApplyResult applyResult;
        if (!rule.isPresent()) {
            for (Scope scope : scopes) {
                context.initScope(scope, Collections.emptyList(), false);
            }
            return CompletableFuture.completedFuture(SolverResult.of(this.spec));
        }
        State unitState = State.of().withResource(context.id());
        try {
            applyResult = RuleUtil.apply(unitState.unifier(), rule.get(), scopes, null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
            if (applyResult == null) {
                return CompletableFuture.completedExceptionally(new IllegalArgumentException("Cannot apply initial rule to root scope."));
            }
        }
        catch (Delay delay) {
            return CompletableFuture.completedExceptionally(new IllegalArgumentException("Cannot apply initial rule to root scope.", delay));
        }
        this.solver = new StatixSolver(applyResult.body(), this.spec, unitState, applyResult.criticalEdges(), this.debug, new NullProgress(), new NullCancel(), context, 0);
        this.solveResult = this.solver.solve(scopes);
        return this.solveResult.thenApply(r -> {
            logger.debug("checker {}: solver returned.", context.id());
            this.solver = null;
            return r;
        });
    }

    @Override
    public IFuture<ITerm> getExternalDatum(ITerm datum) {
        if (this.solver != null) {
            return this.solver.getExternalRepresentation(datum);
        }
        if (this.solveResult != null) {
            return this.solveResult.thenCompose(r -> {
                IUniDisunifier.Immutable unifier = r.state().unifier();
                if (unifier.isGround(datum)) {
                    return CompletableFuture.completedFuture(unifier.findRecursive(datum));
                }
                return new CompletableFuture();
            });
        }
        return CompletableFuture.completedFuture(datum);
    }
}

