/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mb.scopegraph.regexp.Deriver;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpMatcher;
import mb.scopegraph.regexp.impl.RegExpNormalizingBuilder;
import mb.scopegraph.regexp.impl.RegExps;

public class RegExpMatcher<S>
implements IRegExpMatcher<S>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final State<S> state;

    private RegExpMatcher(State<S> state) {
        this.state = state;
    }

    @Override
    public IRegExp<S> regexp() {
        return ((State)this.state).regexp;
    }

    @Override
    public RegExpMatcher<S> match(S symbol) {
        return new RegExpMatcher<S>(((State)this.state).symbolTransitions.getOrDefault(symbol, ((State)this.state).defaultTransition));
    }

    @Override
    public IRegExpMatcher<S> match(Iterable<S> symbols) {
        IRegExpMatcher<S> matcher = this;
        for (S symbol : symbols) {
            matcher = matcher.match((Object)symbol);
        }
        return matcher;
    }

    @Override
    public boolean isAccepting() {
        return ((State)this.state).isNullable;
    }

    @Override
    public boolean isFinal() {
        return !((State)this.state).nonFinal;
    }

    public String toString() {
        return ((State)this.state).regexp.toString();
    }

    public static <S> IRegExpMatcher<S> create(IRegExp<S> initial) {
        State _state;
        IAlphabet alphabet = RegExps.alphabet(initial);
        RegExpNormalizingBuilder builder = new RegExpNormalizingBuilder(alphabet);
        Object empty = builder.emptySet();
        ArrayList derivers = Lists.newArrayList();
        for (Object symbol : alphabet) {
            derivers.add(new Deriver(symbol, builder));
        }
        Deriver<Object> defaultDeriver = new Deriver<Object>(null, builder);
        HashMap stateTransitions = Maps.newHashMap();
        HashMap defaultTransitions = Maps.newHashMap();
        HashMap reverseTransitions = Maps.newHashMap();
        ArrayDeque worklist = Queues.newArrayDeque();
        worklist.push(initial);
        worklist.push(empty);
        while (!worklist.isEmpty()) {
            IRegExp state = (IRegExp)worklist.pop();
            HashMap transitions = Maps.newHashMapWithExpectedSize((int)derivers.size());
            if (stateTransitions.containsKey(state)) continue;
            for (Deriver deriver : derivers) {
                IRegExp nextState = (IRegExp)builder.apply((IRegExp)deriver.apply(state));
                Set reverseStates = (Set)reverseTransitions.get(nextState);
                if (reverseStates == null) {
                    reverseStates = Sets.newHashSet();
                    reverseTransitions.put(nextState, reverseStates);
                }
                reverseStates.add(state);
                transitions.put(deriver.getSymbol(), nextState);
                worklist.push(nextState);
            }
            IRegExp defaultState = (IRegExp)builder.apply((IRegExp)defaultDeriver.apply(state));
            Set reverseStates = (Set)reverseTransitions.get(defaultState);
            if (reverseStates == null) {
                reverseStates = Sets.newHashSet();
                reverseTransitions.put(defaultState, reverseStates);
            }
            reverseStates.add(state);
            defaultTransitions.put(state, defaultState);
            worklist.push(defaultState);
            stateTransitions.put(state, transitions);
        }
        for (IRegExp state : stateTransitions.keySet()) {
            if (!RegExps.isNullable(state)) continue;
            worklist.push(state);
        }
        HashSet visited = Sets.newHashSet();
        HashSet nonFinal = Sets.newHashSet();
        while (!worklist.isEmpty()) {
            IRegExp state = (IRegExp)worklist.pop();
            if (visited.contains(state)) continue;
            visited.add(state);
            if (!reverseTransitions.containsKey(state)) continue;
            for (IRegExp nextState : (Set)reverseTransitions.get(state)) {
                nonFinal.add(nextState);
                worklist.push(nextState);
            }
        }
        Set isNullable = (Set)stateTransitions.keySet().stream().filter(RegExps::isNullable).collect(ImmutableSet.toImmutableSet());
        HashMap states = Maps.newHashMapWithExpectedSize((int)stateTransitions.size());
        for (IRegExp state : stateTransitions.keySet()) {
            _state = new State(state);
            states.put(state, _state);
            _state.isNullable = isNullable.contains(state);
            _state.nonFinal = nonFinal.contains(state);
        }
        for (IRegExp state : stateTransitions.keySet()) {
            _state = (State)states.get(state);
            _state.defaultTransition = (State)states.get(defaultTransitions.get(state));
            _state.symbolTransitions = ((Map)stateTransitions.get(state)).entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> (State)states.get(e.getValue())));
        }
        return new RegExpMatcher<S>((State)states.get(initial));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExpMatcher that = (RegExpMatcher)o;
        return Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    private static class State<S>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IRegExp<S> regexp;
        private Map<S, State<S>> symbolTransitions;
        private State<S> defaultTransition;
        private boolean nonFinal;
        private boolean isNullable;

        private State(IRegExp<S> regexp) {
            this.regexp = regexp;
        }

        public int hashCode() {
            return Objects.hash(this.regexp);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            return Objects.equals(this.regexp, other.regexp);
        }

        public String toString() {
            return this.regexp.toString();
        }
    }
}

