/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.AScope;

public final class Scope
extends AScope
implements Serializable {
    private final IAttachments attachments;
    private final String resource;
    private final String name;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ARGS_LAZY_INIT_BIT = 1L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private Scope(String resource, String name2) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.name = Objects.requireNonNull(name2, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private Scope(IAttachments attachments, String resource, String name2) {
        this.attachments = attachments;
        this.resource = resource;
        this.name = name2;
        this.hashCode = super.hashCode();
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final Scope withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new Scope(newValue, this.resource, this.name);
    }

    public final Scope withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new Scope(this.attachments, newValue, this.name);
    }

    public final Scope withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Scope(this.attachments, this.resource, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Scope scope = this;
            synchronized (scope) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.args;
    }

    public static Scope of(String resource, String name2) {
        return new Scope(resource, name2);
    }

    public static Scope copyOf(AScope instance) {
        if (instance instanceof Scope) {
            return (Scope)instance;
        }
        return Scope.of(instance.getResource(), instance.getName()).withAttachments(instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new Scope(this.attachments, this.resource, this.name);
    }
}

