/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.terms.Scope;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AScope
extends AbstractApplTerm
implements IScope,
IApplTerm,
Comparable<IScope> {
    private static final String OP = "Scope";

    @Override
    @Value.Parameter
    public abstract String getResource();

    @Override
    @Value.Parameter
    public abstract String getName();

    @Override
    public String getOp() {
        return OP;
    }

    @Override
    @Value.Lazy
    public List<ITerm> getArgs() {
        return ImmutableList.of((Object)TermBuild.B.newString(this.getResource()), (Object)TermBuild.B.newString(this.getName()));
    }

    public static TermMatch.IMatcher<Scope> matcher() {
        return TermMatch.M.preserveAttachments(TermMatch.M.appl2(OP, TermMatch.M.stringValue(), TermMatch.M.stringValue(), (t, resource, name2) -> Scope.of(resource, name2)));
    }

    @Override
    protected AScope check() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Scope)) {
            return super.equals(other);
        }
        Scope that = (Scope)other;
        if (!this.getResource().equals(that.getResource())) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "#" + this.getResource() + "-" + this.getName();
    }

    @Override
    public int compareTo(IScope scope) {
        int diffResource = this.getResource().compareTo(scope.getResource());
        if (diffResource != 0) {
            return diffResource;
        }
        int diffName = this.getName().toString().compareTo(scope.getName());
        return diffName;
    }
}

