/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.bottomup;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.bottomup.BUChanges;
import mb.scopegraph.pepm16.bottomup.BULabelOrder;
import mb.scopegraph.pepm16.bottomup.BUPathKey;
import mb.scopegraph.pepm16.bottomup.BUPathSet;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.terms.SpacedName;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

class BUEnv<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> {
    private static final ILogger logger = LoggerUtils.logger(BUEnv.class);
    private final BULabelOrder<L> compare;
    private BUPathSet.Immutable<S, L, O, P> currentPaths;
    private final BUPathSet.Transient<S, L, O, P> deprecatedPaths;
    private BUPathSet.Transient<S, L, O, P> addedPaths;
    private BUPathSet.Transient<S, L, O, P> removedPaths;

    public BUEnv(BULabelOrder<L> compare) {
        this(compare, BUPathSet.Immutable.of());
        this.addedPaths = BUPathSet.Transient.of();
        this.removedPaths = BUPathSet.Transient.of();
    }

    BUEnv(BULabelOrder<L> compare, BUPathSet.Immutable<S, L, O, P> paths) {
        this.compare = compare;
        this.currentPaths = paths;
        this.deprecatedPaths = BUPathSet.Transient.of();
    }

    public BUPathSet.Immutable<S, L, O, P> pathSet() {
        return this.currentPaths;
    }

    public void apply(BUChanges<S, L, O, P> changes) throws InterruptedException {
        changes = changes.filter((key, p) -> !this.deprecatedPaths.paths((BUPathKey<L>)key).contains(p));
        BUPathSet.Transient<S, L, O, P> paths = this.currentPaths.melt();
        BUPathSet.Immutable addPaths = changes.addedPaths();
        for (SpacedName name2 : addPaths.names()) {
            for (BUPathKey key2 : addPaths.keys(name2)) {
                this.addPaths(name2, key2, addPaths.paths(key2), paths);
            }
        }
        BUPathSet.Immutable removePaths = changes.removedPaths();
        for (SpacedName name3 : removePaths.names()) {
            for (BUPathKey key3 : removePaths.keys(name3)) {
                this.removePaths(name3, key3, removePaths.paths(key3), paths);
            }
        }
        this.currentPaths = paths.freeze();
    }

    private void removePaths(SpacedName name2, BUPathKey<L> key, Collection<P> oldPaths, BUPathSet.Transient<S, L, O, P> paths) throws InterruptedException {
        oldPaths = paths.remove(key, oldPaths);
        this.addedPaths.remove(key, oldPaths);
        this.removedPaths.add(key, oldPaths);
        this.deprecatedPaths.add(key, oldPaths);
    }

    private void addPaths(SpacedName name2, BUPathKey<L> key, Collection<P> newPaths, BUPathSet.Transient<S, L, O, P> paths) throws InterruptedException {
        for (BUPathKey otherKey : paths.keys(name2)) {
            Integer result = this.compare.test(key.label(), otherKey.label());
            if (result == null) continue;
            if (result < 0) {
                Collection<P> otherPaths = paths.remove(otherKey);
                this.addedPaths.remove(otherKey, otherPaths);
                this.removedPaths.add(otherKey, otherPaths);
                this.deprecatedPaths.add(key, otherPaths);
            }
            if (result <= 0) continue;
            return;
        }
        newPaths = paths.add(key, newPaths);
        this.addedPaths.add(key, newPaths);
    }

    public BUChanges<S, L, O, P> commitChanges() {
        BUChanges<S, L, O, P> changes = new BUChanges<S, L, O, P>(this.addedPaths.freeze(), this.removedPaths.freeze());
        this.addedPaths = BUPathSet.Transient.of();
        this.removedPaths = BUPathSet.Transient.of();
        return changes;
    }

    public boolean hasChanges() {
        return !this.addedPaths.isEmpty() || !this.removedPaths.isEmpty();
    }

    public void write(String prefix, Writer out) throws IOException {
    }
}

