/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.terms.newPath;

import io.usethesource.capsule.Set;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.path.IStep;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.path.Paths;
import org.metaborg.util.collection.ConsList;

public class ScopePath<S, L>
implements IScopePath<S, L> {
    private final S source;
    private final Path<S, L> path;
    private final int size;
    private final Set.Immutable<S> scopeSet;

    public ScopePath(S source) {
        this(source, null, 0, Set.Immutable.of(source));
    }

    ScopePath(S source, Path<S, L> path, int size, Set.Immutable<S> scopeSet) {
        this.source = source;
        this.path = path;
        this.size = size;
        this.scopeSet = scopeSet;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public S getTarget() {
        return this.path == null ? this.source : this.path.target;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set.Immutable<S> scopeSet() {
        return this.scopeSet;
    }

    @Override
    public ConsList<S> scopes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConsList<L> labels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IStep<S, L>> iterator() {
        return new PathIterator(this.source, this.path);
    }

    public Optional<ScopePath<S, L>> step(L label, S target) {
        if (this.scopeSet.contains(target)) {
            return Optional.empty();
        }
        Path<S, L> newPath = new Path<S, L>(this.path, label, target);
        return Optional.of(new ScopePath<S, L>(this.source, newPath, this.size + 1, this.scopeSet.__insert(target)));
    }

    public <D> ResolutionPath<S, L, D> resolve(D datum) {
        return new ResolutionPath(this, datum);
    }

    @Override
    public String toString(boolean includeSource, boolean includeTarget) {
        StringBuilder sb = new StringBuilder();
        Path<S, L> path = ScopePath.reverse(this.path);
        if (includeSource) {
            sb.append(this.source);
        }
        while (path != null) {
            sb.append(" ").append(path.label);
            if (path.prefix != null || includeTarget) {
                sb.append(" ").append(path.target);
            }
            path = path.prefix;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopePath other = (ScopePath)obj;
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.source, other.source) && Objects.equals(this.path, other.path);
    }

    private static <S, L> Path<S, L> reverse(Path<S, L> path) {
        Path revPath = null;
        while (path != null) {
            revPath = new Path(revPath, path.label, path.target);
            path = path.prefix;
        }
        return revPath;
    }

    private static class Path<S, L> {
        public final Path<S, L> prefix;
        public final L label;
        public final S target;

        public Path(Path<S, L> path, L label, S target) {
            this.prefix = path;
            this.label = label;
            this.target = target;
        }

        public int hashCode() {
            return Objects.hash(this.label, this.target, this.prefix);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Path other = (Path)obj;
            return Objects.equals(this.label, other.label) && Objects.equals(this.target, other.target) && Objects.equals(this.prefix, other.prefix);
        }
    }

    private static class PathIterator<S, L>
    implements Iterator<IStep<S, L>> {
        private S source;
        private Path<S, L> path;

        private PathIterator(S source, Path<S, L> path) {
            this.source = source;
            this.path = ScopePath.reverse(path);
        }

        @Override
        public boolean hasNext() {
            return this.path != null;
        }

        @Override
        public IStep<S, L> next() {
            if (this.path == null) {
                throw new NoSuchElementException();
            }
            IStep step = Paths.edge(this.source, this.path.label, this.path.target);
            this.source = this.path.target;
            this.path = this.path.prefix;
            return step;
        }
    }
}

