/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import io.usethesource.capsule.Map;
import java.util.Map;
import java.util.Set;

public abstract class BiMap<E> {
    public abstract boolean containsKey(E var1);

    public abstract boolean containsValue(E var1);

    public abstract boolean containsEntry(E var1, E var2);

    public abstract Set<E> keySet();

    public abstract Set<E> valueSet();

    public abstract Set<Map.Entry<E, E>> entrySet();

    public static class Immutable<E>
    extends BiMap<E> {
        private final Map.Immutable<E, E> fwd;
        private final Map.Immutable<E, E> bwd;

        private Immutable(Map.Immutable<E, E> fwd, Map.Immutable<E, E> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        public boolean containsKey(E key) {
            return this.fwd.containsKey(key);
        }

        @Override
        public boolean containsValue(E value) {
            return this.bwd.containsKey(value);
        }

        @Override
        public boolean containsEntry(E key, E value) {
            return this.fwd.containsKey(key) && this.fwd.get(key).equals(value);
        }

        @Override
        public Set<E> keySet() {
            return this.fwd.keySet();
        }

        @Override
        public Set<E> valueSet() {
            return this.bwd.keySet();
        }

        @Override
        public Set<Map.Entry<E, E>> entrySet() {
            return this.fwd.entrySet();
        }

        public Transient<E> melt() {
            return new Transient(this.fwd.asTransient(), this.bwd.asTransient());
        }

        public String toString() {
            return this.fwd.toString();
        }

        public static <E> Immutable<E> of() {
            return new Immutable<E>(Map.Immutable.of(), Map.Immutable.of());
        }

        public static <E> Immutable<E> of(E key, E value) {
            return new Immutable<E>(Map.Immutable.of(key, value), Map.Immutable.of(value, key));
        }
    }

    public static class Transient<E>
    extends BiMap<E> {
        private final Map.Transient<E, E> fwd;
        private final Map.Transient<E, E> bwd;

        private Transient(Map.Transient<E, E> fwd, Map.Transient<E, E> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        public boolean containsKey(E key) {
            return this.fwd.containsKey(key);
        }

        @Override
        public boolean containsValue(E value) {
            return this.bwd.containsKey(value);
        }

        @Override
        public boolean containsEntry(E key, E value) {
            return this.fwd.containsKey(key) && this.fwd.get(key).equals(value);
        }

        @Override
        public Set<E> keySet() {
            return this.fwd.keySet();
        }

        @Override
        public Set<E> valueSet() {
            return this.bwd.keySet();
        }

        @Override
        public Set<Map.Entry<E, E>> entrySet() {
            return this.fwd.entrySet();
        }

        public boolean canPut(E key, E value) {
            if (this.fwd.containsKey(key) && !this.fwd.get(key).equals(value)) {
                return false;
            }
            return !this.bwd.containsKey(value) || this.bwd.get(value).equals(key);
        }

        public void put(E key, E value) {
            if (!this.canPut(key, value)) {
                throw new IllegalArgumentException("Key or value already set.");
            }
            this.fwd.__put(key, value);
            this.bwd.__put(value, key);
        }

        public void putAll(BiMap<E> other) {
            this.putAll(other.entrySet());
        }

        public void putAll(Iterable<Map.Entry<E, E>> entries) {
            entries.forEach(e -> this.put(e.getKey(), e.getValue()));
        }

        public Immutable<E> freeze() {
            return new Immutable(this.fwd.freeze(), this.bwd.freeze());
        }

        public String toString() {
            return this.fwd.toString();
        }

        public static <E> Transient<E> of() {
            return new Transient<E>(Map.Transient.of(), Map.Transient.of());
        }

        public static <E> Transient<E> of(E key, E value) {
            return new Transient<E>(Map.Transient.of(key, value), Map.Transient.of(value, key));
        }
    }
}

