/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.ecoop21;

import com.google.common.collect.Lists;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Optional;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.Futures;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.unit.Unit;

public abstract class NameResolution<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(NameResolution.class);
    private final EdgeOrData<L> dataLabel = EdgeOrData.data();
    private final Set.Immutable<L> edgeLabels;
    private final LabelOrder<L> labelOrder;

    public NameResolution(Set.Immutable<L> edgeLabels, LabelOrder<L> labelOrder) {
        this.edgeLabels = edgeLabels;
        this.labelOrder = labelOrder;
    }

    protected abstract Optional<IFuture<Env<S, L, D>>> externalEnv(ScopePath<S, L> var1, LabelWf<L> var2, LabelOrder<L> var3);

    protected abstract IFuture<Optional<D>> getDatum(S var1);

    protected abstract IFuture<Iterable<S>> getEdges(S var1, L var2);

    protected abstract IFuture<Boolean> dataWf(D var1, ICancel var2) throws InterruptedException;

    protected abstract IFuture<Boolean> dataLeq(D var1, D var2, ICancel var3) throws InterruptedException;

    protected abstract IFuture<Boolean> dataLeqAlwaysTrue(ICancel var1);

    public ICompletableFuture<Env<S, L, D>> env(ScopePath<S, L> path, LabelWf<L> re, ICancel cancel) {
        CompletableFuture<Env<S, L, D>> result = new CompletableFuture<Env<S, L, D>>();
        logger.trace("env {}", path);
        this.externalEnv(path, re, this.labelOrder).orElseGet(() -> {
            Set.Transient labels = CapsuleUtil.transientSet();
            if (re.accepting()) {
                labels.__insert(this.dataLabel);
            }
            for (Object l : this.edgeLabels) {
                if (!re.step(l).isPresent()) continue;
                labels.__insert(EdgeOrData.edge(l));
            }
            return this.env_L(path, re, labels.freeze(), cancel);
        }).whenComplete(result::complete);
        return result;
    }

    private IFuture<Env<S, L, D>> env_L(ScopePath<S, L> path, LabelWf<L> re, Set.Immutable<EdgeOrData<L>> L2, ICancel cancel) {
        logger.trace("env_L {} {} {}", path, re, L2);
        if (cancel.cancelled()) {
            return CompletableFuture.completedExceptionally(new InterruptedException());
        }
        Set.Immutable<EdgeOrData<L>> max_L = this.max(L2);
        ArrayList envs = Lists.newArrayList();
        for (EdgeOrData l : max_L) {
            envs.add(this.env_lL(path, re, l, this.smaller(L2, l), cancel));
        }
        AggregateFuture listEnv = new AggregateFuture(envs);
        logger.trace("env_L {} {} {}: listEnv: {}", path, re, L2, listEnv);
        listEnv.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: listResult {}", path, re, L2, listEnv));
        IFuture env = listEnv.thenApply(es -> {
            Env.Builder envBuilder = Env.builder();
            es.forEach(envBuilder::addAll);
            return envBuilder.build();
        });
        logger.trace("env_L {} {} {}: env: {}", path, re, L2, env);
        env.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: result {}", path, re, L2, env));
        return env;
    }

    private IFuture<Env<S, L, D>> env_lL(ScopePath<S, L> path, LabelWf<L> re, EdgeOrData<L> l, Set.Immutable<EdgeOrData<L>> L2, ICancel cancel) {
        IFuture env1 = this.env_L(path, re, L2, cancel);
        logger.trace("env_L {} {} {}: env1: {}", path, re, L2, env1);
        env1.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: result1: {}", path, re, L2, env1));
        return env1.thenCompose(e1 -> {
            IFuture<Boolean> envComplete = e1.isEmpty() ? CompletableFuture.completedFuture(false) : this.dataLeqAlwaysTrue(cancel);
            return envComplete.thenCompose(complete -> {
                if (complete.booleanValue()) {
                    logger.trace("env_L {} {} {}: env2 fully shadowed", path, re, L2);
                    return CompletableFuture.completedFuture(e1);
                }
                IFuture env2 = this.env_l(path, re, l, cancel);
                logger.trace("env_L {} {} {}: env2: {}", path, re, L2, env2);
                env2.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: result2 {}", path, re, L2, env2));
                return env2.thenCompose(e2 -> this.shadows((Env<S, L, D>)e1, (Env<S, L, D>)e2, cancel));
            });
        });
    }

    private Set.Immutable<EdgeOrData<L>> max(Set.Immutable<EdgeOrData<L>> L2) {
        Set.Transient max2 = CapsuleUtil.transientSet();
        block2: for (EdgeOrData l1 : L2) {
            for (EdgeOrData l2 : L2) {
                try {
                    if (!this.labelOrder.lt(l1, l2)) continue;
                }
                catch (Throwable t) {
                    logger.error("Unexpected exception in labelOrder", t);
                }
                continue block2;
            }
            max2.__insert((Object)l1);
        }
        return max2.freeze();
    }

    private Set.Immutable<EdgeOrData<L>> smaller(Set.Immutable<EdgeOrData<L>> L2, EdgeOrData<L> l1) {
        Set.Transient smaller = CapsuleUtil.transientSet();
        for (EdgeOrData l2 : L2) {
            if (!this.labelOrder.lt(l2, l1)) continue;
            smaller.__insert((Object)l2);
        }
        return smaller.freeze();
    }

    private IFuture<Env<S, L, D>> env_l(ScopePath<S, L> path, LabelWf<L> re, EdgeOrData<L> l, ICancel cancel) {
        try {
            return l.matchInResolution(() -> this.env_data(path, re, cancel), lbl -> this.env_edges(path, re, lbl, cancel));
        }
        catch (Exception e) {
            throw new IllegalStateException("Should not happen.");
        }
    }

    private IFuture<Env<S, L, D>> env_data(ScopePath<S, L> path, LabelWf<L> re, ICancel cancel) {
        logger.trace("env_data {} {}", path, re);
        IFuture<Optional<D>> datum = this.getDatum(path.getTarget());
        logger.trace("env_data {} {}: datum {}", path, re, datum);
        IFuture env = datum.thenCompose(_d -> {
            Object d = _d.orElse(null);
            if (d == null) {
                return CompletableFuture.completedFuture(Env.empty());
            }
            return this.dataWf(d, cancel).thenApply(wf -> {
                if (!wf.booleanValue()) {
                    return Env.empty();
                }
                logger.trace("env_data {} {}: datum {}", path, re, d);
                ResolutionPath resPath = path.resolve(d);
                return Env.of(resPath);
            });
        });
        logger.trace("env_data {} {}: env {}", path, re, env);
        env.whenComplete((r, ex) -> logger.trace("env_data {} {}: result {}", path, re, env));
        return env;
    }

    private IFuture<Env<S, L, D>> env_edges(ScopePath<S, L> path, LabelWf<L> re, L l, ICancel cancel) {
        logger.trace("env_edges {} {} {}", path, re, l);
        LabelWf<L> newRe = re.step(l).get();
        IFuture<Iterable<S>> scopes = this.getEdges(path.getTarget(), l);
        logger.trace("env_edges {} {} {}: edge scopes {}", path, re, l, scopes);
        return scopes.thenCompose(ss -> {
            ArrayList envs = Lists.newArrayList();
            for (Object nextScope : ss) {
                Optional p = path.step(l, nextScope);
                if (!p.isPresent()) continue;
                envs.add(this.env(p.get(), newRe, cancel));
            }
            AggregateFuture listEnv = new AggregateFuture(envs);
            logger.trace("env_edges {} {} {}: listEnv {}", path, re, l, listEnv);
            listEnv.whenComplete((r, ex) -> logger.trace("env_edges {} {} {}: listResult {}", path, re, l, listEnv));
            IFuture<Env> env = listEnv.thenApply(es -> {
                Env.Builder envBuilder = Env.builder();
                es.forEach(envBuilder::addAll);
                return envBuilder.build();
            });
            logger.trace("env_edges {} {} {}: env {}", path, re, l, env);
            env.whenComplete((r, ex) -> logger.trace("env_edges {} {} {}: result {}", path, re, l, env));
            return env;
        });
    }

    private IFuture<Env<S, L, D>> shadows(Env<S, L, D> env1, Env<S, L, D> env2, ICancel cancel) {
        Env.Builder env = Env.builder();
        env.addAll(env1);
        return Futures.reduce(Unit.unit, env2, (u, p2) -> Futures.noneMatch(env1, p1 -> this.dataLeq(p2.getDatum(), p1.getDatum(), cancel)).thenApply(noneMatch -> {
            if (noneMatch.booleanValue()) {
                env.add(p2);
            }
            return Unit.unit;
        })).thenApply(u -> env.build());
    }
}

