/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExtensionPathMatcher
implements PathMatcher {
    private final String extension;

    public ExtensionPathMatcher(String extension) {
        this.extension = extension;
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        @Nullable String extension = path.getLeafFileExtension();
        if (extension == null) {
            return false;
        }
        return this.extension.equals(extension);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionPathMatcher that = (ExtensionPathMatcher)o;
        return this.extension.equals(that.extension);
    }

    public int hashCode() {
        return this.extension.hashCode();
    }

    public String toString() {
        return "ExtensionPathMatcher(" + this.extension + ")";
    }
}

