/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import java.util.ArrayList;
import java.util.Collections;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.util.AntPattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AntPatternsPathMatcher
implements PathMatcher {
    private final ArrayList<AntPattern> patterns;

    public AntPatternsPathMatcher(ArrayList<AntPattern> patterns) {
        this.patterns = patterns;
    }

    public AntPatternsPathMatcher(Iterable<AntPattern> patterns) {
        this.patterns = new ArrayList();
        for (AntPattern pattern : patterns) {
            this.patterns.add(pattern);
        }
    }

    public AntPatternsPathMatcher(AntPattern ... patterns) {
        this.patterns = new ArrayList();
        Collections.addAll(this.patterns, patterns);
    }

    public AntPatternsPathMatcher(String ... patterns) {
        this.patterns = new ArrayList();
        for (String pattern : patterns) {
            this.patterns.add(new AntPattern(pattern));
        }
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = rootDir.relativize(path);
        for (AntPattern pattern : this.patterns) {
            if (!pattern.match(relative)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntPatternsPathMatcher that = (AntPatternsPathMatcher)o;
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return "PatternsPathMatcher(" + this.patterns + ")";
    }
}

