/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.fs;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mb.resource.ResourceRuntimeException;
import mb.resource.fs.PathIterator;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.ResourcePathDefaults;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FSPath
extends ResourcePathDefaults<FSPath>
implements ResourcePath,
Comparable<FSPath>,
Serializable {
    final URI uri;
    transient Path javaPath;

    public FSPath(Path javaPath) {
        this.uri = FSPath.toUri(javaPath);
        this.javaPath = javaPath;
    }

    public FSPath(URI uri) {
        this.uri = FSPath.stripUriTrailingSlash(uri);
        this.javaPath = FSPath.fromUri(this.uri);
    }

    public FSPath(File javaFile) {
        this(FSPath.createLocalPath(javaFile));
    }

    public FSPath(String localPathStr) {
        this(FSPath.createLocalPath(localPathStr));
    }

    public static FSPath workingDirectory() {
        return new FSPath(System.getProperty("user.dir"));
    }

    public static FSPath homeDirectory() {
        return new FSPath(System.getProperty("user.home"));
    }

    public static FSPath temporaryDirectory() {
        return new FSPath(System.getProperty("java.io.tmpdir"));
    }

    public Path getJavaPath() {
        return this.javaPath;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isLocalPath() {
        return this.javaPath.getFileSystem().equals(FileSystems.getDefault());
    }

    @Override
    public boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    public FSPath toAbsoluteFromWorkingDirectory() {
        if (this.javaPath.isAbsolute()) {
            return this;
        }
        return FSPath.workingDirectory().appendRelativePath(this);
    }

    public FSPath toAbsoluteFromHomeDirectory() {
        if (this.javaPath.isAbsolute()) {
            return this;
        }
        return FSPath.homeDirectory().appendRelativePath(this);
    }

    @Override
    public int getSegmentCount() {
        return this.javaPath.getNameCount();
    }

    @Override
    public Iterable<String> getSegments() {
        return () -> new PathIterator(this.javaPath.iterator());
    }

    @Override
    public boolean startsWith(ResourcePath prefix) {
        if (!(prefix instanceof FSPath)) {
            throw new ResourceRuntimeException("Cannot check if this path starts with '" + prefix + "', it is not an FSPath");
        }
        return this.startsWith((FSPath)prefix);
    }

    public boolean startsWith(FSPath prefix) {
        return this.javaPath.startsWith(prefix.javaPath);
    }

    @Override
    public @Nullable FSPath getParent() {
        @Nullable Path parentJavaPath = this.javaPath.getParent();
        if (parentJavaPath == null) {
            return null;
        }
        return new FSPath(parentJavaPath);
    }

    @Override
    public @Nullable FSPath getRoot() {
        @Nullable Path rootJavaPath = this.javaPath.getRoot();
        if (rootJavaPath == null) {
            return null;
        }
        return new FSPath(rootJavaPath);
    }

    @Override
    public @Nullable String getLeaf() {
        @Nullable Path fileName = this.javaPath.getFileName();
        if (fileName == null) {
            return null;
        }
        return fileName.toString();
    }

    @Override
    public FSPath getNormalized() {
        Path normalizedJavaPath = this.javaPath.normalize();
        return new FSPath(normalizedJavaPath);
    }

    @Override
    public String relativize(ResourcePath other) {
        if (!(other instanceof FSPath)) {
            throw new ResourceRuntimeException("Cannot relativize against '" + other + "', it is not an FSPath");
        }
        return this.relativize((FSPath)other);
    }

    public String relativize(FSPath other) {
        return this.javaPath.relativize(other.javaPath).toString();
    }

    @Override
    public FSPath appendSegment(String segment) {
        Path javaPath = this.javaPath.resolve(segment);
        return new FSPath(javaPath);
    }

    @Override
    public FSPath appendSegments(Iterable<String> segments) {
        ArrayList segmentsList = new ArrayList();
        segments.forEach(segmentsList::add);
        return (FSPath)this.appendSegments((List)segmentsList);
    }

    @Override
    public FSPath appendSegments(Collection<String> segments) {
        Path relJavaPath = FSPath.createLocalPath(segments);
        Path javaPath = this.javaPath.resolve(relJavaPath);
        return new FSPath(javaPath);
    }

    @Override
    public FSPath appendRelativePath(String relativePath) {
        Path other = this.javaPath.getFileSystem().getPath(relativePath, new String[0]);
        if (other.isAbsolute()) {
            throw new ResourceRuntimeException("Cannot append path '" + relativePath + "', it is an absolute path");
        }
        return this.appendOrReplaceWithPath(other);
    }

    @Override
    public FSPath appendOrReplaceWithPath(String other) {
        return this.appendOrReplaceWithPath(this.javaPath.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public FSPath appendRelativePath(ResourcePath relativePath) {
        if (!(relativePath instanceof FSPath)) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is not an FSPath");
        }
        return this.appendRelativePath((FSPath)relativePath);
    }

    public FSPath appendRelativePath(FSPath relativePath) {
        if (relativePath.isAbsolute()) {
            throw new ResourceRuntimeException("Cannot append path '" + relativePath + "', it is an absolute path");
        }
        Path javaPath = this.javaPath.resolve(relativePath.javaPath);
        return new FSPath(javaPath);
    }

    @Override
    public FSPath appendOrReplaceWithPath(ResourcePath other) {
        if (!(other instanceof FSPath)) {
            throw new ResourceRuntimeException("Cannot append or replace from '" + other + "', it is not an FSPath");
        }
        return this.appendOrReplaceWithPath((FSPath)other);
    }

    public FSPath appendOrReplaceWithPath(FSPath other) {
        Path javaPath = this.javaPath.resolve(other.javaPath);
        return new FSPath(javaPath);
    }

    public FSPath appendOrReplaceWithPath(Path other) {
        Path javaPath = this.javaPath.resolve(other);
        return new FSPath(javaPath);
    }

    @Override
    public FSPath replaceLeaf(String segment) {
        Path javaPath = this.javaPath.resolveSibling(segment);
        return new FSPath(javaPath);
    }

    private static URI toUri(Path javaPath) {
        URI uri = javaPath.toUri();
        return FSPath.stripUriTrailingSlash(uri);
    }

    private static Path fromUri(URI uri) {
        if ((uri = FSPath.stripUriTrailingSlash(uri)).getScheme() == null) {
            return FSPath.createLocalPath(uri.toString());
        }
        try {
            return Paths.get(uri);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            throw new ResourceRuntimeException("Creating Java path from URI '" + uri + "' failed unexpectedly", e);
        }
    }

    private static Path createLocalPath(Collection<String> segments) {
        int segmentsSize = segments.size();
        if (segmentsSize == 0) {
            return FileSystems.getDefault().getPath("/", new String[0]);
        }
        @Nullable String first = null;
        String[] more = new String[segmentsSize - 1];
        int i = 0;
        for (String segment : segments) {
            if (first == null) {
                first = segment;
                continue;
            }
            more[++i] = segment;
        }
        return FileSystems.getDefault().getPath(first, more);
    }

    private static Path createLocalPath(String ... segments) {
        int segmentsSize = segments.length;
        if (segmentsSize == 0) {
            return FileSystems.getDefault().getPath("/", new String[0]);
        }
        String first = segments[0];
        String[] more = new String[segmentsSize - 1];
        System.arraycopy(segments, 1, more, 0, segmentsSize - 1);
        return FileSystems.getDefault().getPath(first, more);
    }

    private static Path createLocalPath(File javaFile) {
        try {
            return FileSystems.getDefault().getPath(javaFile.getPath(), new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ResourceRuntimeException("Creating local path from file '" + javaFile + "' failed unexpectedly", e);
        }
    }

    private static Path createLocalPath(String localPathStr) {
        try {
            return FileSystems.getDefault().getPath(localPathStr, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ResourceRuntimeException("Creating local path from string '" + localPathStr + "' failed unexpectedly", e);
        }
    }

    private static URI stripUriTrailingSlash(URI uri) {
        @Nullable String path = uri.getPath();
        if (path != null && SeparatorUtil.endsWithSeparator(path) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Could not strip trailing slash from URI '" + uri + "'", e);
        }
    }

    @Override
    public String getQualifier() {
        return "java";
    }

    @Override
    public URI getId() {
        return this.uri;
    }

    @Override
    public String getIdAsString() {
        return this.uri.toString();
    }

    @Override
    public int compareTo(FSPath other) {
        return this.javaPath.compareTo(other.javaPath);
    }

    @Override
    protected FSPath self() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSPath javaPath = (FSPath)o;
        return this.uri.equals(javaPath.uri);
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public String toString() {
        return this.asString();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.javaPath = FSPath.fromUri(this.uri);
    }
}

