/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.io.File;
import java.util.Objects;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceRuntimeException;
import mb.resource.classloader.ClassLoaderResource;
import mb.resource.classloader.ClassLoaderUrlResolver;
import mb.resource.classloader.NoopClassLoaderUrlResolver;
import mb.resource.hierarchical.SegmentsPath;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassLoaderResourceRegistry
implements ResourceRegistry {
    private static final String defaultQualifier = "classloader-resource";
    private final String qualifier;
    private final ClassLoader classLoader;
    private final ClassLoaderUrlResolver urlResolver;

    public ClassLoaderResourceRegistry(String qualifier, ClassLoader classLoader, ClassLoaderUrlResolver urlResolver) {
        this.qualifier = qualifier;
        this.classLoader = classLoader;
        this.urlResolver = urlResolver;
    }

    public ClassLoaderResourceRegistry(String qualifier, ClassLoader classLoader) {
        this(qualifier, classLoader, new NoopClassLoaderUrlResolver());
    }

    public ClassLoaderResourceRegistry(ClassLoader classLoader, ClassLoaderUrlResolver urlResolver) {
        this(defaultQualifier, classLoader, urlResolver);
    }

    public ClassLoaderResourceRegistry(ClassLoader classLoader) {
        this(classLoader, new NoopClassLoaderUrlResolver());
    }

    public ClassLoaderResourceRegistry() {
        this(ClassLoaderResourceRegistry.class.getClassLoader());
    }

    @Override
    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public SegmentsPath getResourceKey(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(this.qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + this.qualifier + "' of this resource registry");
        }
        return this.getPath(keyStr.getId());
    }

    @Override
    public ClassLoaderResource getResource(ResourceKey key) {
        if (!(key instanceof SegmentsPath)) {
            throw new ResourceRuntimeException("Cannot get class loader resource for key '" + key + "'; it is not of type SegmentsPath");
        }
        return this.getResource((SegmentsPath)key);
    }

    @Override
    public ClassLoaderResource getResource(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(this.qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + this.qualifier + "' of this resource registry");
        }
        return this.getResource(keyStr.getId());
    }

    @Override
    public @Nullable File toLocalFile(ResourceKey key) {
        if (!(key instanceof SegmentsPath)) {
            throw new ResourceRuntimeException("Cannot get local file for key '" + key + "'; it is not of type SegmentsPath");
        }
        return this.toLocalFile(this.getResource((SegmentsPath)key));
    }

    @Override
    public @Nullable File toLocalFile(Resource resource) {
        if (!(resource instanceof ClassLoaderResource)) {
            throw new ResourceRuntimeException("Cannot get local file for resource '" + resource + "'; it is not of type ClassLoaderResource");
        }
        return ((ClassLoaderResource)resource).asLocalFile();
    }

    public String getPathIdentifierForClass(Class<?> clazz) {
        return clazz.getCanonicalName().replace(".", "/") + ".class";
    }

    public SegmentsPath getPath(String path) {
        return new SegmentsPath(this.qualifier, path);
    }

    public SegmentsPath getPath(Class<?> clazz) {
        return new SegmentsPath(this.qualifier, this.getPathIdentifierForClass(clazz));
    }

    public ClassLoaderResource getResource(String path) {
        return new ClassLoaderResource(this.classLoader, this.urlResolver, this.qualifier, path);
    }

    public ClassLoaderResource getResource(Class<?> clazz) {
        return new ClassLoaderResource(this.classLoader, this.urlResolver, this.qualifier, this.getPathIdentifierForClass(clazz));
    }

    public ClassLoaderResource getResource(SegmentsPath path) {
        return new ClassLoaderResource(this.classLoader, this.urlResolver, path);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderResourceRegistry that = (ClassLoaderResourceRegistry)o;
        return this.qualifier.equals(that.qualifier) && this.classLoader.equals(that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.qualifier, this.classLoader);
    }

    public String toString() {
        return "ClassLoaderResourceRegistry{qualifier='" + this.qualifier + '\'' + ", classLoader=" + this.classLoader + '}';
    }
}

