/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Enumeration;
import java.util.stream.Stream;
import mb.resource.ReadableResource;
import mb.resource.ResourceRuntimeException;
import mb.resource.classloader.ClassLoaderResourceLocations;
import mb.resource.classloader.ClassLoaderUrlResolver;
import mb.resource.classloader.JarFileWithPath;
import mb.resource.fs.FSResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.HierarchicalResourceType;
import mb.resource.hierarchical.SegmentsPath;
import mb.resource.hierarchical.SegmentsResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import mb.resource.util.UriEncode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassLoaderResource
extends SegmentsResource<ClassLoaderResource>
implements HierarchicalResource {
    private final ClassLoader classLoader;
    private final ClassLoaderUrlResolver urlResolver;

    ClassLoaderResource(ClassLoader classLoader, ClassLoaderUrlResolver urlResolver, SegmentsPath path) {
        super(path);
        this.classLoader = classLoader;
        this.urlResolver = urlResolver;
    }

    ClassLoaderResource(ClassLoader classLoader, ClassLoaderUrlResolver urlResolver, String qualifier, String id) {
        super(new SegmentsPath(qualifier, id));
        this.classLoader = classLoader;
        this.urlResolver = urlResolver;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HierarchicalResourceType getType() throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support resource types");
    }

    @Override
    public Stream<ClassLoaderResource> list(ResourceMatcher matcher) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support listing");
    }

    @Override
    public Stream<ClassLoaderResource> walk(ResourceWalker walker, ResourceMatcher matcher) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support walking");
    }

    @Override
    public void copyTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support copying");
    }

    @Override
    public void copyRecursivelyTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support copying");
    }

    @Override
    public void moveTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support moving");
    }

    @Override
    public ClassLoaderResource createFile(boolean createParents) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support creating files");
    }

    @Override
    public ClassLoaderResource createDirectory(boolean createParents) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support creating directories");
    }

    @Override
    public ClassLoaderResource createParents() throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support creating directories");
    }

    @Override
    public void delete(boolean deleteRecursively) throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support deletion");
    }

    @Override
    public boolean exists() throws IOException {
        return this.getUrlToResource() != null;
    }

    @Override
    public boolean isReadable() throws IOException {
        return true;
    }

    @Override
    public Instant getLastModifiedTime() throws IOException {
        URLConnection connection = this.openConnection();
        Instant lastModified = Instant.ofEpochMilli(connection.getLastModified());
        this.closeConnection(connection);
        return lastModified;
    }

    @Override
    public long getSize() throws IOException {
        URLConnection connection = this.openConnection();
        long size = connection.getContentLengthLong();
        this.closeConnection(connection);
        return size;
    }

    private void closeConnection(URLConnection connection) throws IOException {
        connection.getInputStream().close();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarUrlConnection = (JarURLConnection)connection;
            jarUrlConnection.getJarFile().close();
        }
    }

    @Override
    public InputStream openRead() throws IOException {
        return this.openConnection().getInputStream();
    }

    @Override
    public boolean isWritable() throws IOException {
        return true;
    }

    @Override
    public void setLastModifiedTime(Instant moment) throws IOException {
    }

    @Override
    public OutputStream openWriteAppend() throws IOException {
        URLConnection connection = this.openConnection();
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    @Override
    public OutputStream openWriteExisting() throws IOException {
        throw new UnsupportedOperationException("Class loader resources do not support opening an appending output stream");
    }

    public ReadableResource tryAsLocalResource() {
        @Nullable ReadableResource resource = this.asLocalResource();
        if (resource != null) {
            return resource;
        }
        return this;
    }

    public @Nullable ReadableResource asLocalResource() {
        @Nullable URI uri = this.asLocalUri();
        if (uri == null) {
            return null;
        }
        return new FSResource(uri);
    }

    public @Nullable File asLocalFile() {
        @Nullable URI uri = this.asLocalUri();
        if (uri == null) {
            return null;
        }
        return new File(uri);
    }

    public @Nullable URI asLocalUri() {
        @Nullable URL url = this.asLocalUrl();
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Could not get local filesystem URI (with 'file' protocol) for class loader resource '" + this.path + "'; conversion of URL '" + url + "' to an URI failed", e);
        }
    }

    public @Nullable URL asLocalUrl() {
        @Nullable URL url = this.getUrlToResource();
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            return url;
        }
        @Nullable URL resolvedUrl = this.urlResolver.resolve(url);
        if (resolvedUrl != null && "file".equals(resolvedUrl.getProtocol())) {
            return resolvedUrl;
        }
        return null;
    }

    public ClassLoaderResourceLocations getLocations() throws IOException {
        ClassLoaderResourceLocations locations = new ClassLoaderResourceLocations();
        Enumeration<URL> resources = this.classLoader.getResources(this.path.getId().toString());
        if (!resources.hasMoreElements()) {
            throw new ResourceRuntimeException("Could not get class loader resource locations for '" + this.path + "'; no locations were found");
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            this.processLocationUrl(url, locations);
        }
        return locations;
    }

    private void processLocationUrl(URL url, ClassLoaderResourceLocations locations) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            try {
                FSResource directory = new FSResource(url.toURI());
                locations.directories.add(directory);
            }
            catch (URISyntaxException e) {
                throw new ResourceRuntimeException("Could not get class loader resource locations for '" + this.path + "'; conversion of URL '" + url + "' to an URI failed", e);
            }
        } else if ("jar".equals(protocol)) {
            String pathInJarFile;
            String jarFilePath;
            String urlPath = url.getPath();
            int exclamationMarkIndex = urlPath.indexOf("!");
            if (exclamationMarkIndex < 0) {
                jarFilePath = urlPath;
                pathInJarFile = "";
            } else {
                jarFilePath = urlPath.substring(0, exclamationMarkIndex);
                pathInJarFile = urlPath.substring(exclamationMarkIndex + 1);
            }
            try {
                FSResource jarFile = new FSResource(UriEncode.encodeToUri(jarFilePath));
                locations.jarFiles.add(new JarFileWithPath(jarFile, pathInJarFile));
            }
            catch (URISyntaxException e) {
                throw new ResourceRuntimeException("Could not add class loader resource location for '" + url + "'; conversion of nested path '" + jarFilePath + "' to an URI failed", e);
            }
        } else {
            @Nullable URL resolvedUrl = this.urlResolver.resolve(url);
            if (resolvedUrl != null) {
                this.processLocationUrl(resolvedUrl, locations);
            } else {
                locations.unrecognizedUrls.add(url);
            }
        }
    }

    private @Nullable URL getUrlToResource() {
        return this.classLoader.getResource(this.path.getId().toString());
    }

    private URLConnection openConnection() throws IOException {
        String resourcePath = this.path.getId().toString();
        @Nullable URL url = this.getUrlToResource();
        if (url == null) {
            throw new IOException("Resource '" + resourcePath + "' could not be found in class loader '" + this.classLoader + "'");
        }
        return url.openConnection();
    }

    @Override
    protected ClassLoaderResource self() {
        return this;
    }

    @Override
    protected ClassLoaderResource create(SegmentsPath path) {
        return new ClassLoaderResource(this.classLoader, this.urlResolver, path);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderResource that = (ClassLoaderResource)o;
        return this.path.equals(that.path);
    }
}

