/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.serde;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import mb.pie.api.serde.ByteBufferBackedInputStream;
import mb.pie.api.serde.DeserializeRuntimeException;
import mb.pie.api.serde.EfficientByteArrayOutputStream;
import mb.pie.api.serde.SerializeRuntimeException;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Serde {
    public <T> void serialize(T var1, OutputStream var2);

    default public <T> byte[] serializeToBytes(T obj) {
        byte[] byArray;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serialize(obj, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    default public <T> ByteBuffer serializeToByteBuffer(T obj) {
        ByteBuffer byteBuffer;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serialize(obj, outputStream);
            byteBuffer = outputStream.toByteBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byteBuffer;
    }

    public <T> T deserialize(Class<T> var1, InputStream var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T deserializeFromBytes(Class<T> type, byte[] bytes) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            T t = this.deserialize(type, inputStream);
            return t;
        }
        catch (IOException e) {
            throw new DeserializeRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T deserializeFromByteBuffer(Class<T> type, ByteBuffer byteBuffer) {
        try (ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(byteBuffer);){
            T t = this.deserialize(type, inputStream);
            return t;
        }
        catch (IOException e) {
            throw new DeserializeRuntimeException(e);
        }
    }

    public <T> void serializeNullable(@Nullable T var1, Class<T> var2, OutputStream var3);

    default public <T> byte[] serializeNullableToBytes(@Nullable T obj, Class<T> type) {
        byte[] byArray;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serializeNullable(obj, type, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    default public <T> ByteBuffer serializeNullableToByteBuffer(@Nullable T obj, Class<T> type) {
        ByteBuffer byteBuffer;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serializeNullable(obj, type, outputStream);
            byteBuffer = outputStream.toByteBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byteBuffer;
    }

    public <T> @Nullable T deserializeNullable(Class<T> var1, InputStream var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> @Nullable T deserializeNullableFromBytes(Class<T> type, byte[] bytes) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            T t = this.deserializeNullable(type, inputStream);
            return t;
        }
        catch (IOException e) {
            throw new DeserializeRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> @Nullable T deserializeNullableFromByteBuffer(Class<T> type, ByteBuffer ByteBuffer2) {
        try (ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(ByteBuffer2);){
            T t = this.deserializeNullable(type, inputStream);
            return t;
        }
        catch (IOException e) {
            throw new DeserializeRuntimeException(e);
        }
    }

    public void serializeTypeAndObject(@Nullable Object var1, OutputStream var2);

    default public byte[] serializeTypeAndObjectToBytes(@Nullable Object obj) {
        byte[] byArray;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serializeTypeAndObject(obj, outputStream);
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    default public ByteBuffer serializeTypeAndObjectToByteBuffer(@Nullable Object obj) {
        ByteBuffer byteBuffer;
        EfficientByteArrayOutputStream outputStream = new EfficientByteArrayOutputStream();
        try {
            this.serializeTypeAndObject(obj, outputStream);
            byteBuffer = outputStream.toByteBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializeRuntimeException(e);
            }
        }
        outputStream.close();
        return byteBuffer;
    }

    public @Nullable Object deserializeTypeAndObject(@Nullable ClassLoader var1, InputStream var2);

    default public @Nullable Object deserializeTypeAndObjectFromBytes(@Nullable ClassLoader classLoader, byte[] bytes) {
        Object object;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            object = this.deserializeTypeAndObject(classLoader, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DeserializeRuntimeException(e);
            }
        }
        inputStream.close();
        return object;
    }

    default public @Nullable Object deserializeTypeAndObjectFromByteBuffer(@Nullable ClassLoader classLoader, ByteBuffer ByteBuffer2) {
        Object object;
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(ByteBuffer2);
        try {
            object = this.deserializeTypeAndObject(classLoader, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DeserializeRuntimeException(e);
            }
        }
        inputStream.close();
        return object;
    }
}

