/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.StoreReadTxn;
import mb.pie.api.StoreWriteTxn;
import mb.pie.api.TaskKey;
import mb.pie.api.TaskRequireDep;
import mb.pie.api.Tracer;

public enum Observability implements Serializable
{
    ExplicitObserved,
    ImplicitObserved,
    Unobserved;


    public boolean isObserved() {
        return this == ExplicitObserved || this == ImplicitObserved;
    }

    public boolean isUnobserved() {
        return this == Unobserved;
    }

    public static void explicitUnobserve(StoreWriteTxn txn, TaskKey key, Tracer tracer) {
        Observability previousObservability = txn.taskObservability(key);
        if (previousObservability == Unobserved) {
            return;
        }
        if (Observability.isObservedByCaller(txn, key)) {
            if (previousObservability == ExplicitObserved) {
                Observability newObservability = ImplicitObserved;
                tracer.setTaskObservability(key, previousObservability, newObservability);
                txn.setTaskObservability(key, newObservability);
            }
        } else {
            Observability newObservability = Unobserved;
            tracer.setTaskObservability(key, previousObservability, newObservability);
            txn.setTaskObservability(key, newObservability);
            for (TaskRequireDep taskRequire : txn.taskRequires(key)) {
                Observability.implicitUnobserve(txn, taskRequire.callee, tracer);
            }
        }
    }

    public static void implicitUnobserve(StoreWriteTxn txn, TaskKey key, Tracer tracer) {
        Observability previousObservability = txn.taskObservability(key);
        if (previousObservability != ImplicitObserved) {
            return;
        }
        if (Observability.isObservedByCaller(txn, key)) {
            return;
        }
        Observability newObservability = Unobserved;
        tracer.setTaskObservability(key, previousObservability, newObservability);
        txn.setTaskObservability(key, newObservability);
        for (TaskRequireDep taskRequire : txn.taskRequires(key)) {
            Observability.implicitUnobserve(txn, taskRequire.callee, tracer);
        }
    }

    private static boolean isObservedByCaller(StoreReadTxn txn, TaskKey key) {
        return txn.callersOf(key).stream().map(txn::taskObservability).anyMatch(Observability::isObserved);
    }
}

