/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.ATypeCheckerState;
import org.metaborg.util.future.ICompletableFuture;

public final class TypeCheckerState<S, L, D>
extends ATypeCheckerState<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final ImmutableList<D> datums;
    private final ICompletableFuture<?> future;

    private TypeCheckerState(IActorRef<? extends IUnit<S, L, D, ?>> origin, Iterable<? extends D> datums, ICompletableFuture<?> future) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.datums = ImmutableList.copyOf(datums);
        this.future = Objects.requireNonNull(future, "future");
    }

    private TypeCheckerState(TypeCheckerState<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, ImmutableList<D> datums, ICompletableFuture<?> future) {
        this.origin = origin;
        this.datums = datums;
        this.future = future;
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public ImmutableList<D> datums() {
        return this.datums;
    }

    @Override
    public ICompletableFuture<?> future() {
        return this.future;
    }

    public final TypeCheckerState<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new TypeCheckerState<S, L, D>(this, newValue, this.datums, this.future);
    }

    @SafeVarargs
    public final TypeCheckerState<S, L, D> withDatums(D ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new TypeCheckerState<S, L, D>(this, this.origin, newValue, this.future);
    }

    public final TypeCheckerState<S, L, D> withDatums(Iterable<? extends D> elements) {
        if (this.datums == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new TypeCheckerState<S, L, D>(this, this.origin, newValue, this.future);
    }

    public final TypeCheckerState<S, L, D> withFuture(ICompletableFuture<?> value) {
        if (this.future == value) {
            return this;
        }
        ICompletableFuture<?> newValue = Objects.requireNonNull(value, "future");
        return new TypeCheckerState<S, L, D>(this, this.origin, this.datums, newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TypeCheckerState").omitNullValues().add("origin", this.origin).add("datums", this.datums).add("future", this.future).toString();
    }

    public static <S, L, D> TypeCheckerState<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, List<D> datums, ICompletableFuture<?> future) {
        return TypeCheckerState.of(origin, datums, future);
    }

    public static <S, L, D> TypeCheckerState<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, Iterable<? extends D> datums, ICompletableFuture<?> future) {
        return new TypeCheckerState<S, L, D>(origin, datums, future);
    }

    public static <S, L, D> TypeCheckerState<S, L, D> copyOf(ATypeCheckerState<S, L, D> instance) {
        if (instance instanceof TypeCheckerState) {
            return (TypeCheckerState)instance;
        }
        return TypeCheckerState.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ TypeCheckerState(TypeCheckerState typeCheckerState, IActorRef iActorRef, ImmutableList immutableList, ICompletableFuture iCompletableFuture, TypeCheckerState typeCheckerState2) {
        this(typeCheckerState, iActorRef, immutableList, iCompletableFuture);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_FUTURE = 2L;
        private long initBits = 3L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private ImmutableList.Builder<D> datums = ImmutableList.builder();
        private ICompletableFuture<?> future;

        private Builder() {
        }

        public final Builder<S, L, D> from(ATypeCheckerState<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.addAllDatums(instance.datums());
            this.future(instance.future());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> addDatums(D element) {
            this.datums.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addDatums(D ... elements) {
            this.datums.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> datums(Iterable<? extends D> elements) {
            this.datums = ImmutableList.builder();
            return this.addAllDatums(elements);
        }

        public final Builder<S, L, D> addAllDatums(Iterable<? extends D> elements) {
            this.datums.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> future(ICompletableFuture<?> future) {
            this.future = Objects.requireNonNull(future, "future");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public TypeCheckerState<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TypeCheckerState(null, this.origin, this.datums.build(), this.future, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("future");
            }
            return "Cannot build TypeCheckerState, some of required attributes are not set " + attributes;
        }
    }
}

