/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.AQuery;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.reference.Env;
import org.metaborg.util.future.IFuture;

public final class Query<S, L, D>
extends AQuery<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final IScopePath<S, L> path;
    private final DataWf<S, L, D> dataWF;
    private final IFuture<Env<S, L, D>> future;

    private Query(IActorRef<? extends IUnit<S, L, D, ?>> origin, IScopePath<S, L> path, DataWf<S, L, D> dataWF, IFuture<Env<S, L, D>> future) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.path = Objects.requireNonNull(path, "path");
        this.dataWF = Objects.requireNonNull(dataWF, "dataWF");
        this.future = Objects.requireNonNull(future, "future");
    }

    private Query(Query<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, IScopePath<S, L> path, DataWf<S, L, D> dataWF, IFuture<Env<S, L, D>> future) {
        this.origin = origin;
        this.path = path;
        this.dataWF = dataWF;
        this.future = future;
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public IScopePath<S, L> path() {
        return this.path;
    }

    @Override
    public DataWf<S, L, D> dataWF() {
        return this.dataWF;
    }

    @Override
    public IFuture<Env<S, L, D>> future() {
        return this.future;
    }

    public final Query<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new Query<S, L, D>(this, newValue, this.path, this.dataWF, this.future);
    }

    public final Query<S, L, D> withPath(IScopePath<S, L> value) {
        if (this.path == value) {
            return this;
        }
        IScopePath<S, L> newValue = Objects.requireNonNull(value, "path");
        return new Query<S, L, D>(this, this.origin, newValue, this.dataWF, this.future);
    }

    public final Query<S, L, D> withDataWF(DataWf<S, L, D> value) {
        if (this.dataWF == value) {
            return this;
        }
        DataWf<S, L, D> newValue = Objects.requireNonNull(value, "dataWF");
        return new Query<S, L, D>(this, this.origin, this.path, newValue, this.future);
    }

    public final Query<S, L, D> withFuture(IFuture<Env<S, L, D>> value) {
        if (this.future == value) {
            return this;
        }
        IFuture<Env<S, L, D>> newValue = Objects.requireNonNull(value, "future");
        return new Query<S, L, D>(this, this.origin, this.path, this.dataWF, newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Query").omitNullValues().add("origin", this.origin).add("path", this.path).add("dataWF", this.dataWF).add("future", this.future).toString();
    }

    public static <S, L, D> Query<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, IScopePath<S, L> path, DataWf<S, L, D> dataWF, IFuture<Env<S, L, D>> future) {
        return new Query<S, L, D>(origin, path, dataWF, future);
    }

    public static <S, L, D> Query<S, L, D> copyOf(AQuery<S, L, D> instance) {
        if (instance instanceof Query) {
            return (Query)instance;
        }
        return Query.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ Query(Query query, IActorRef iActorRef, IScopePath iScopePath, DataWf dataWf, IFuture iFuture, Query query2) {
        this(query, iActorRef, iScopePath, dataWf, iFuture);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_DATA_W_F = 4L;
        private static final long INIT_BIT_FUTURE = 8L;
        private long initBits = 15L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private IScopePath<S, L> path;
        private DataWf<S, L, D> dataWF;
        private IFuture<Env<S, L, D>> future;

        private Builder() {
        }

        public final Builder<S, L, D> from(AQuery<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.path(instance.path());
            this.dataWF(instance.dataWF());
            this.future(instance.future());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> path(IScopePath<S, L> path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D> dataWF(DataWf<S, L, D> dataWF) {
            this.dataWF = Objects.requireNonNull(dataWF, "dataWF");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<S, L, D> future(IFuture<Env<S, L, D>> future) {
            this.future = Objects.requireNonNull(future, "future");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Query<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Query(null, this.origin, this.path, this.dataWF, this.future, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dataWF");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("future");
            }
            return "Cannot build Query, some of required attributes are not set " + attributes;
        }
    }
}

