/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.IUnitStats;
import mb.p_raffrayi.impl.AUnitResult;
import mb.scopegraph.oopsla20.IScopeGraph;

public final class UnitResult<S, L, D, R>
extends AUnitResult<S, L, D, R>
implements Serializable {
    private final String id;
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    @Nullable
    private final R analysis;
    private final ImmutableList<Throwable> failures;
    private final ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults;
    private final IUnitStats stats;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private UnitResult(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable R analysis, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, IUnitStats stats) {
        this.id = Objects.requireNonNull(id, "id");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.analysis = analysis;
        this.failures = ImmutableList.copyOf(failures);
        this.subUnitResults = ImmutableMap.copyOf(subUnitResults);
        this.stats = Objects.requireNonNull(stats, "stats");
    }

    private UnitResult(UnitResult<S, L, D, R> original, String id, IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable R analysis, ImmutableList<Throwable> failures, ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults, IUnitStats stats) {
        this.id = id;
        this.scopeGraph = scopeGraph;
        this.analysis = analysis;
        this.failures = failures;
        this.subUnitResults = subUnitResults;
        this.stats = stats;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public IScopeGraph.Immutable<S, L, D> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    @Nullable
    public R analysis() {
        return this.analysis;
    }

    public ImmutableList<Throwable> failures() {
        return this.failures;
    }

    @Override
    public ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults() {
        return this.subUnitResults;
    }

    @Override
    public IUnitStats stats() {
        return this.stats;
    }

    public final UnitResult<S, L, D, R> withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this, newValue, this.scopeGraph, this.analysis, this.failures, this.subUnitResults, this.stats);
    }

    public final UnitResult<S, L, D, R> withScopeGraph(IScopeGraph.Immutable<S, L, D> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IScopeGraph.Immutable<S, L, D> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new UnitResult<S, L, D, R>(this, this.id, newValue, this.analysis, this.failures, this.subUnitResults, this.stats);
    }

    public final UnitResult<S, L, D, R> withAnalysis(@Nullable R value) {
        if (this.analysis == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this, this.id, this.scopeGraph, value, this.failures, this.subUnitResults, this.stats);
    }

    public final UnitResult<S, L, D, R> withFailures(Throwable ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new UnitResult<S, L, D, R>(this, this.id, this.scopeGraph, this.analysis, (ImmutableList<Throwable>)newValue, this.subUnitResults, this.stats);
    }

    public final UnitResult<S, L, D, R> withFailures(Iterable<? extends Throwable> elements) {
        if (this.failures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new UnitResult<S, L, D, R>(this, this.id, this.scopeGraph, this.analysis, (ImmutableList<Throwable>)newValue, this.subUnitResults, this.stats);
    }

    public final UnitResult<S, L, D, R> withSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
        if (this.subUnitResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new UnitResult<S, L, D, R>(this, this.id, this.scopeGraph, this.analysis, this.failures, newValue, this.stats);
    }

    public final UnitResult<S, L, D, R> withStats(IUnitStats value) {
        if (this.stats == value) {
            return this;
        }
        IUnitStats newValue = Objects.requireNonNull(value, "stats");
        return new UnitResult<S, L, D, R>(this, this.id, this.scopeGraph, this.analysis, this.failures, this.subUnitResults, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnitResult && this.equalTo((UnitResult)another);
    }

    private boolean equalTo(UnitResult<?, ?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.id.equals(another.id) && this.scopeGraph.equals(another.scopeGraph) && Objects.equals(this.analysis, another.analysis) && this.failures.equals(another.failures) && this.subUnitResults.equals(another.subUnitResults) && this.stats.equals(another.stats);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + Objects.hashCode(this.analysis);
        h += (h << 5) + this.failures.hashCode();
        h += (h << 5) + this.subUnitResults.hashCode();
        h += (h << 5) + this.stats.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnitResult").omitNullValues().add("id", (Object)this.id).add("scopeGraph", this.scopeGraph).add("analysis", this.analysis).add("failures", this.failures).add("subUnitResults", this.subUnitResults).add("stats", (Object)this.stats).toString();
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable R analysis, List<Throwable> failures, Map<String, IUnitResult<S, L, D, ?>> subUnitResults, IUnitStats stats) {
        return UnitResult.of(id, scopeGraph, analysis, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable R analysis, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, IUnitStats stats) {
        return new UnitResult<S, L, D, R>(id, scopeGraph, analysis, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> copyOf(AUnitResult<S, L, D, R> instance) {
        if (instance instanceof UnitResult) {
            return (UnitResult)instance;
        }
        return UnitResult.builder().from(instance).build();
    }

    public static <S, L, D, R> Builder<S, L, D, R> builder() {
        return new Builder();
    }

    /* synthetic */ UnitResult(UnitResult unitResult, String string, IScopeGraph.Immutable immutable, Object object, ImmutableList immutableList, ImmutableMap immutableMap, IUnitStats iUnitStats, UnitResult unitResult2) {
        this(unitResult, string, immutable, object, (ImmutableList<Throwable>)immutableList, immutableMap, iUnitStats);
    }

    public static final class Builder<S, L, D, R> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SCOPE_GRAPH = 2L;
        private static final long INIT_BIT_STATS = 4L;
        private long initBits = 7L;
        private String id;
        private IScopeGraph.Immutable<S, L, D> scopeGraph;
        private R analysis;
        private ImmutableList.Builder<Throwable> failures = ImmutableList.builder();
        private ImmutableMap.Builder<String, IUnitResult<S, L, D, ?>> subUnitResults = ImmutableMap.builder();
        private IUnitStats stats;

        private Builder() {
        }

        public final Builder<S, L, D, R> from(AUnitResult<S, L, D, R> instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.scopeGraph(instance.scopeGraph());
            R analysisValue = instance.analysis();
            if (analysisValue != null) {
                this.analysis(analysisValue);
            }
            this.addAllFailures(instance.failures());
            this.putAllSubUnitResults(instance.subUnitResults());
            this.stats(instance.stats());
            return this;
        }

        public final Builder<S, L, D, R> id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D, R> scopeGraph(IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D, R> analysis(@Nullable R analysis) {
            this.analysis = analysis;
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable element) {
            this.failures.add((Object)element);
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable ... elements) {
            this.failures.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, R> failures(Iterable<? extends Throwable> elements) {
            this.failures = ImmutableList.builder();
            return this.addAllFailures(elements);
        }

        public final Builder<S, L, D, R> addAllFailures(Iterable<? extends Throwable> elements) {
            this.failures.addAll(elements);
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(String key, IUnitResult<S, L, D, ?> value) {
            this.subUnitResults.put((Object)key, value);
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(Map.Entry<String, ? extends IUnitResult<S, L, D, ?>> entry) {
            this.subUnitResults.put(entry);
            return this;
        }

        public final Builder<S, L, D, R> subUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            this.subUnitResults = ImmutableMap.builder();
            return this.putAllSubUnitResults(entries);
        }

        public final Builder<S, L, D, R> putAllSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            this.subUnitResults.putAll(entries);
            return this;
        }

        public final Builder<S, L, D, R> stats(IUnitStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public UnitResult<S, L, D, R> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitResult(null, this.id, this.scopeGraph, this.analysis, this.failures.build(), this.subUnitResults.build(), this.stats, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scopeGraph");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stats");
            }
            return "Cannot build UnitResult, some of required attributes are not set " + attributes;
        }
    }
}

