/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.collect.Streams;
import io.usethesource.capsule.Set;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.p_raffrayi.IScopeGraphLibrary;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.AbstractUnit;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.ScopeGraphLibraryUnit;
import mb.p_raffrayi.impl.UnitState;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

class TypeCheckerUnit<S, L, D, R>
extends AbstractUnit<S, L, D, R>
implements ITypeCheckerContext<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(TypeCheckerUnit.class);
    private final ITypeChecker<S, L, D, R> typeChecker;
    private volatile UnitState state;

    TypeCheckerUnit(IActor<? extends IUnit<S, L, D, R>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, ITypeChecker<S, L, D, R> unitChecker, Iterable<L> edgeLabels) {
        super(self, parent, context, edgeLabels);
        this.typeChecker = unitChecker;
        this.state = UnitState.INIT;
    }

    @Override
    protected IFuture<D> getExternalDatum(D datum) {
        return this.typeChecker.getExternalDatum(datum);
    }

    @Override
    public IFuture<IUnitResult<S, L, D, R>> _start(List<S> rootScopes) {
        this.assertInState(UnitState.INIT);
        this.resume();
        this.state = UnitState.ACTIVE;
        this.doStart(rootScopes);
        IFuture<Object> result = this.typeChecker.run(this, rootScopes).whenComplete((r, ex) -> {
            this.state = UnitState.DONE;
        });
        return this.doFinish(result);
    }

    @Override
    public String id() {
        return this.self.id();
    }

    @Override
    public <Q> IFuture<IUnitResult<S, L, D, Q>> add(String id, ITypeChecker<S, L, D, Q> unitChecker, List<S> rootScopes) {
        this.assertInState(UnitState.ACTIVE);
        IFuture result = this.doAddSubUnit(id, (subself, subcontext) -> new TypeCheckerUnit<S, L, D, R>(subself, this.self, subcontext, unitChecker, this.edgeLabels), rootScopes)._2();
        return this.ifActive(result);
    }

    @Override
    public IFuture<IUnitResult<S, L, D, Unit>> add(String id, IScopeGraphLibrary<S, L, D> library, List<S> rootScopes) {
        this.assertInState(UnitState.ACTIVE);
        IFuture result = this.doAddSubUnit(id, (subself, subcontext) -> new ScopeGraphLibraryUnit(subself, this.self, subcontext, this.edgeLabels, library), rootScopes)._2();
        return this.ifActive(result);
    }

    @Override
    public void initScope(S root, Iterable<L> labels, boolean sharing) {
        this.assertInState(UnitState.ACTIVE);
        List edges = Streams.stream(labels).map(EdgeOrData::edge).collect(Collectors.toList());
        this.doInitShare(this.self, root, edges, sharing);
    }

    @Override
    public S freshScope(String baseName, Iterable<L> edgeLabels, boolean data, boolean sharing) {
        this.assertInState(UnitState.ACTIVE);
        Object scope = this.doFreshScope(baseName, edgeLabels, data, sharing);
        return scope;
    }

    @Override
    public void shareLocal(S scope) {
        this.assertInState(UnitState.ACTIVE);
        this.doAddShare(this.self, scope);
    }

    @Override
    public void setDatum(S scope, D datum) {
        this.assertInState(UnitState.ACTIVE);
        this.doSetDatum(scope, datum);
    }

    @Override
    public void addEdge(S source, L label, S target) {
        this.assertInState(UnitState.ACTIVE);
        this.doAddEdge(this.self, source, label, target);
    }

    @Override
    public void closeEdge(S source, L label) {
        this.assertInState(UnitState.ACTIVE);
        this.doCloseLabel(this.self, source, EdgeOrData.edge(label));
    }

    @Override
    public void closeScope(S scope) {
        this.assertInState(UnitState.ACTIVE);
        this.doCloseScope(this.self, scope);
    }

    @Override
    public IFuture<Set<IResolutionPath<S, L, D>>> query(S scope, LabelWf<L> labelWF, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, @Nullable DataWf<S, L, D> dataWfInternal, @Nullable DataLeq<S, L, D> dataEquivInternal) {
        IFuture ret;
        this.assertInState(UnitState.ACTIVE);
        ScopePath path = new ScopePath(scope);
        IFuture result = this.doQuery(this.self, path, labelWF, labelOrder, dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        if (result.isDone()) {
            ret = result;
        } else {
            Query wf = Query.of(this.self, path, labelWF, dataWF, labelOrder, dataEquiv, result);
            this.waitFor(wf, this.self);
            ret = result.whenComplete((env, ex) -> this.granted(wf, this.self));
        }
        ++this.stats.localQueries;
        return this.ifActive(ret).thenApply(CapsuleUtil::toSet);
    }

    private void assertInState(UnitState s) {
        if (!this.state.equals((Object)s)) {
            logger.error("Expected state {}, was {}", new Object[]{s, this.state});
            throw new IllegalStateException("Expected state " + (Object)((Object)s) + ", was " + (Object)((Object)this.state));
        }
    }

    private <Q> IFuture<Q> ifActive(IFuture<Q> result) {
        return result.compose((r, ex) -> {
            if (this.state.equals((Object)UnitState.ACTIVE)) {
                return CompletableFuture.completed(r, ex);
            }
            return CompletableFuture.noFuture();
        });
    }

    public String toString() {
        return "TypeCheckerUnit{" + this.self.id() + "}";
    }
}

