/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.p_raffrayi.IScopeGraphLibrary;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.AbstractUnit;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.ScopeGraphLibraryWorker;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

class ScopeGraphLibraryUnit<S, L, D>
extends AbstractUnit<S, L, D, Unit> {
    private static final ILogger logger = LoggerUtils.logger(ScopeGraphLibraryUnit.class);
    private IScopeGraphLibrary<S, L, D> library;
    private final List<IActorRef<? extends IUnit<S, L, D, Unit>>> workers;

    ScopeGraphLibraryUnit(IActor<? extends IUnit<S, L, D, Unit>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, Iterable<L> edgeLabels, IScopeGraphLibrary<S, L, D> library) {
        super(self, parent, context, edgeLabels);
        this.library = library;
        this.workers = new ArrayList<IActorRef<? extends IUnit<S, L, D, Unit>>>();
    }

    protected void clearLibrary() {
        this.library = null;
    }

    @Override
    protected IFuture<D> getExternalDatum(D datum) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public IFuture<IUnitResult<S, L, D, Unit>> _start(List<S> rootScopes) {
        this.doStart(rootScopes);
        this.buildScopeGraph(rootScopes);
        this.clearLibrary();
        this.startWorkers();
        return this.doFinish(CompletableFuture.completedFuture(Unit.unit));
    }

    private void buildScopeGraph(List<S> rootScopes) {
        long t0 = System.currentTimeMillis();
        List edges = this.edgeLabels.stream().map(EdgeOrData::edge).collect(Collectors.toList());
        for (S rootScope : rootScopes) {
            this.doInitShare(this.self, rootScope, edges, false);
        }
        Tuple2<Set<Object>, IScopeGraph.Immutable<Object, L, D>> libraryResult = this.library.initialize(rootScopes, this::makeScope);
        this.scopes.__insertAll(libraryResult._1());
        this.scopeGraph.set(libraryResult._2());
        for (S rootScope : rootScopes) {
            for (Object label : this.edgeLabels) {
                EdgeOrData l = EdgeOrData.edge(label);
                for (S target : ((IScopeGraph.Immutable)this.scopeGraph.get()).getEdges(rootScope, label)) {
                    this.doAddEdge(this.self, rootScope, label, target);
                }
                this.doCloseLabel(this.self, rootScope, l);
            }
        }
        long dt = System.currentTimeMillis() - t0;
        logger.info("Initialized {} in {} s", this.self.id(), TimeUnit.SECONDS.convert(dt, TimeUnit.MILLISECONDS));
    }

    private void startWorkers() {
        int i = 0;
        while (i < this.context.parallelism()) {
            Tuple2 worker = this.doAddSubUnit("worker-" + i, (subself, subcontext) -> new ScopeGraphLibraryWorker(subself, this.self, subcontext, this.edgeLabels, this.scopes, (IScopeGraph.Immutable)this.scopeGraph.get()), Collections.emptyList());
            this.workers.add(worker._1());
            ++i;
        }
    }

    @Override
    public void _initShare(S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _addShare(S scope) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _doneSharing(S scope) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _addEdge(S source, L label, S target) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public void _closeEdge(S scope, EdgeOrData<L> edge) {
        throw new UnsupportedOperationException("Not supported by static scope graph units.");
    }

    @Override
    public IFuture<Env<S, L, D>> _query(ScopePath<S, L> path, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, LabelOrder<L> labelOrder, DataLeq<S, L, D> dataEquiv) {
        ++this.stats.incomingQueries;
        IActorRef<? extends IUnit<S, L, D, Unit>> worker = this.workers.get(this.stats.incomingQueries % this.workers.size());
        IFuture<Env<S, L, D>> result = this.self.async(worker)._query(path, labelWF, dataWF, labelOrder, dataEquiv);
        Query<S, L, D> token = Query.of(this.self, path, labelWF, dataWF, labelOrder, dataEquiv, result);
        this.waitFor(token, worker);
        return result.whenComplete((r, ex) -> this.granted(token, worker));
    }

    public String toString() {
        return "StaticScopeGraphUnit{" + this.self.id() + "}";
    }
}

