/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import mb.p_raffrayi.IScopeImpl;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.impl.ActorSystem;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.TypeCheckerUnit;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;

public class Broker<S, L, D, R> {
    private static final ILogger logger = LoggerUtils.logger(Broker.class);
    private static final int INACTIVE_TIMEOUT = 5;
    private final String id;
    private final ITypeChecker<S, L, D, R> typeChecker;
    private final IScopeImpl<S, D> scopeImpl;
    private final Set<L> edgeLabels;
    private final ICancel cancel;
    private final IActorScheduler scheduler;
    private final ActorSystem system;
    private final Map<String, IActorRef<? extends IUnit<S, L, D, ?>>> units;
    private final AtomicInteger unfinishedUnits;
    private final AtomicInteger totalUnits;

    private Broker(String id, ITypeChecker<S, L, D, R> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, IActorScheduler scheduler) {
        this.id = id;
        this.typeChecker = typeChecker;
        this.scopeImpl = scopeImpl;
        this.edgeLabels = ImmutableSet.copyOf(edgeLabels);
        this.cancel = cancel;
        this.scheduler = scheduler;
        this.system = new ActorSystem(scheduler);
        this.units = new ConcurrentHashMap();
        this.unfinishedUnits = new AtomicInteger();
        this.totalUnits = new AtomicInteger();
    }

    private IFuture<IUnitResult<S, L, D, R>> run() {
        IActorRef unit = this.system.add(this.id, (TypeTag)TypeTag.of(IUnit.class), self -> new TypeCheckerUnit<S, L, D, R>(self, null, new UnitContext(self), this.typeChecker, this.edgeLabels));
        this.addUnit(unit);
        IFuture unitResult = ((IUnit)this.system.async(unit))._start(Collections.emptyList());
        IFuture<IUnitResult<S, L, D, R>> runResult = unitResult.compose((arg_0, arg_1) -> this.lambda$1((IActor)unit, arg_0, arg_1));
        this.startWatcherThread();
        return runResult;
    }

    private void addUnit(IActorRef<? extends IUnit<S, L, D, ?>> unit) {
        this.unfinishedUnits.incrementAndGet();
        this.totalUnits.incrementAndGet();
        this.units.put(unit.id(), unit);
    }

    private void finalizeUnit(IActorRef<? extends IUnit<S, L, D, ?>> unit, Throwable ex) {
        String event = ex != null ? "failed" : "finished";
        logger.info("Unit {} {} ({} of {} remaining).", event, unit.id(), this.unfinishedUnits.decrementAndGet(), this.totalUnits.get());
    }

    private void startWatcherThread() {
        AtomicInteger inactive = new AtomicInteger();
        Thread watcher = new Thread(() -> {
            try {
                while (true) {
                    if (!this.system.running()) {
                        return;
                    }
                    if (this.cancel.cancelled()) {
                        this.system.cancel();
                        return;
                    }
                    if (!this.scheduler.isActive()) {
                        if (inactive.incrementAndGet() >= 5) {
                            logger.error("Deadlock detected.");
                            this.system.cancel();
                            return;
                        }
                        logger.error("Potential deadlock...");
                    } else if (inactive.getAndSet(0) != 0) {
                        logger.error("False deadlock.");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }, "PRaffrayiWatcher");
        watcher.start();
    }

    public static <S, L, D, R> IFuture<IUnitResult<S, L, D, R>> run(String id, ITypeChecker<S, L, D, R> unitChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel) {
        return Broker.run(id, unitChecker, scopeImpl, edgeLabels, cancel, Runtime.getRuntime().availableProcessors());
    }

    public static <S, L, D, R> IFuture<IUnitResult<S, L, D, R>> run(String id, ITypeChecker<S, L, D, R> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, int parallelism) {
        return super.run();
    }

    public static <S, L, D, R> IFuture<IUnitResult<S, L, D, R>> debug(String id, ITypeChecker<S, L, D, R> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, double preemptProbability, int scheduleDelayBoundMillis) {
        return Broker.debug(id, typeChecker, scopeImpl, edgeLabels, cancel, Runtime.getRuntime().availableProcessors(), preemptProbability, scheduleDelayBoundMillis);
    }

    public static <S, L, D, R> IFuture<IUnitResult<S, L, D, R>> debug(String id, ITypeChecker<S, L, D, R> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, int parallelism, double preemptProbability, int scheduleDelayBoundMillis) {
        return super.run();
    }

    private /* synthetic */ IFuture lambda$1(IActor iActor, IUnitResult r, Throwable ex) throws Throwable {
        this.finalizeUnit(iActor, ex);
        return this.system.stop().compose((r2, ex2) -> CompletableFuture.completed(r, ex));
    }

    private class UnitContext
    implements IUnitContext<S, L, D> {
        private final IActor<? extends IUnit<S, L, D, ?>> self;

        public UnitContext(IActor<? extends IUnit<S, L, D, ?>> self) {
            this.self = self;
        }

        @Override
        public ICancel cancel() {
            return Broker.this.cancel;
        }

        @Override
        public S makeScope(String name2) {
            return Broker.this.scopeImpl.make(this.self.id(), name2);
        }

        @Override
        public D substituteScopes(D datum, Map<S, S> substitution) {
            return Broker.this.scopeImpl.substituteScopes(datum, substitution);
        }

        @Override
        public IActorRef<? extends IUnit<S, L, D, ?>> owner(S scope) {
            return (IActorRef)Broker.this.units.get(Broker.this.scopeImpl.id(scope));
        }

        @Override
        public <Q> Tuple2<IFuture<IUnitResult<S, L, D, Q>>, IActorRef<? extends IUnit<S, L, D, Q>>> add(String id, Function2<IActor<IUnit<S, L, D, Q>>, IUnitContext<S, L, D>, IUnit<S, L, D, Q>> unitProvider, List<S> rootScopes) {
            IActorRef<IUnit> unit = this.self.add(id, TypeTag.of(IUnit.class), (IActor<U> subself) -> (IUnit)unitProvider.apply((IActor)subself, new UnitContext(subself)));
            Broker.this.addUnit(unit);
            IFuture unitResult = this.self.async(unit)._start(rootScopes);
            unitResult.whenComplete((r, ex) -> Broker.this.finalizeUnit(unit, ex));
            return Tuple2.of(unitResult, unit);
        }

        @Override
        public int parallelism() {
            return Broker.this.scheduler.parallelism();
        }
    }
}

