/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import mb.p_raffrayi.DeadlockException;
import mb.p_raffrayi.IScopeGraphLibrary;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.IUnitStats;
import mb.p_raffrayi.TypeCheckingFailedException;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorMonitor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.IActorStats;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.deadlock.ChandyMisraHaas;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.UnitResult;
import mb.p_raffrayi.impl.tokens.CloseLabel;
import mb.p_raffrayi.impl.tokens.CloseScope;
import mb.p_raffrayi.impl.tokens.IWaitFor;
import mb.p_raffrayi.impl.tokens.InitScope;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.impl.tokens.TypeCheckerResult;
import mb.p_raffrayi.impl.tokens.TypeCheckerState;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.ecoop21.NameResolution;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.HashTrieRelation3;
import org.metaborg.util.collection.IRelation3;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.collection.MultiSetMap;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public abstract class AbstractUnit<S, L, D, R>
implements IUnit<S, L, D, R>,
IActorMonitor,
ChandyMisraHaas.Host<IActorRef<? extends IUnit<S, L, D, ?>>> {
    private static final ILogger logger = LoggerUtils.logger(AbstractUnit.class);
    protected final TypeTag<IUnit<S, L, D, ?>> TYPE = TypeTag.of(IUnit.class);
    protected final IActor<? extends IUnit<S, L, D, R>> self;
    @Nullable
    protected final IActorRef<? extends IUnit<S, L, D, ?>> parent;
    protected final IUnitContext<S, L, D> context;
    private final ChandyMisraHaas<IActorRef<? extends IUnit<S, L, D, ?>>> cmh;
    private volatile boolean innerResult;
    private final Ref<R> analysis;
    private final List<Throwable> failures;
    private final Map<String, IUnitResult<S, L, D, ?>> subUnitResults;
    private final ICompletableFuture<IUnitResult<S, L, D, R>> unitResult;
    protected final Ref<IScopeGraph.Immutable<S, L, D>> scopeGraph;
    protected final Set.Immutable<L> edgeLabels;
    protected final Set.Transient<S> scopes;
    private final IRelation3.Transient<S, EdgeOrData<L>, Delay> delays;
    private final MultiSet.Transient<String> scopeNameCounters;
    protected final Stats stats;
    private final ITypeCheckerContext<S, L, D> queryContext = new ITypeCheckerContext<S, L, D>(){

        @Override
        public String id() {
            return String.valueOf(AbstractUnit.this.self.id()) + "#query";
        }

        @Override
        public <Q> IFuture<IUnitResult<S, L, D, Q>> add(String id, ITypeChecker<S, L, D, Q> unitChecker, List<S> rootScopes) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public IFuture<IUnitResult<S, L, D, Unit>> add(String id, IScopeGraphLibrary<S, L, D> library, List<S> rootScopes) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void initScope(S root, Iterable<L> labels, boolean sharing) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public S freshScope(String baseName, Iterable<L> edgeLabels, boolean data, boolean sharing) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void shareLocal(S scope) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void setDatum(S scope, D datum) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void addEdge(S source, L label, S target) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void closeEdge(S source, L label) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public void closeScope(S scope) {
            throw new UnsupportedOperationException("Unsupported in query context.");
        }

        @Override
        public IFuture<Set<IResolutionPath<S, L, D>>> query(S scope, LabelWf<L> labelWF, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, @Nullable DataWf<S, L, D> dataWfInternal, @Nullable DataLeq<S, L, D> dataEquivInternal) {
            ScopePath path = new ScopePath(scope);
            IFuture result = AbstractUnit.this.doQuery(AbstractUnit.this.self, path, labelWF, labelOrder, dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
            Query wf = Query.of(AbstractUnit.this.self, path, labelWF, dataWF, labelOrder, dataEquiv, result);
            AbstractUnit.this.waitFor(wf, AbstractUnit.this.self);
            ++AbstractUnit.this.stats.localQueries;
            return AbstractUnit.this.self.schedule(result).whenComplete((env, ex) -> AbstractUnit.this.granted(wf, AbstractUnit.this.self)).thenApply(CapsuleUtil::toSet);
        }
    };
    private MultiSet.Immutable<IWaitFor<S, L, D>> waitFors = MultiSet.Immutable.of();
    private MultiSetMap.Immutable<IActorRef<? extends IUnit<S, L, D, ?>>, IWaitFor<S, L, D>> waitForsByActor = MultiSetMap.Immutable.of();
    private long wakeTimeNanos;

    public AbstractUnit(IActor<? extends IUnit<S, L, D, R>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, Iterable<L> edgeLabels) {
        this.self = self;
        this.parent = parent;
        this.context = context;
        this.cmh = new ChandyMisraHaas(this, this::handleDeadlock);
        this.innerResult = false;
        this.analysis = new Ref();
        this.failures = new ArrayList<Throwable>();
        this.subUnitResults = new HashMap();
        this.unitResult = new CompletableFuture<IUnitResult<S, L, D, R>>();
        this.scopeGraph = new Ref(ScopeGraph.Immutable.of());
        this.edgeLabels = CapsuleUtil.toSet(edgeLabels);
        this.scopes = CapsuleUtil.transientSet();
        this.delays = HashTrieRelation3.Transient.of();
        this.scopeNameCounters = MultiSet.Transient.of();
        this.stats = new Stats(self.stats());
    }

    protected abstract IFuture<D> getExternalDatum(D var1);

    @Override
    public void _initShare(S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        this.resume();
        this.doInitShare(this.self.sender(this.TYPE), scope, edges, sharing);
    }

    @Override
    public void _addShare(S scope) {
        this.doAddShare(this.self.sender(this.TYPE), scope);
    }

    @Override
    public void _doneSharing(S scope) {
        this.resume();
        this.doCloseScope(this.self.sender(this.TYPE), scope);
    }

    @Override
    public void _addEdge(S source, L label, S target) {
        this.doAddEdge(this.self.sender(this.TYPE), source, label, target);
    }

    @Override
    public void _closeEdge(S scope, EdgeOrData<L> edge) {
        this.resume();
        this.doCloseLabel(this.self.sender(this.TYPE), scope, edge);
    }

    @Override
    public IFuture<Env<S, L, D>> _query(ScopePath<S, L> path, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, LabelOrder<L> labelOrder, DataLeq<S, L, D> dataEquiv) {
        ++this.stats.incomingQueries;
        return this.doQuery(this.self.sender(this.TYPE), path, labelWF, labelOrder, dataWF, dataEquiv, null, null);
    }

    protected final S makeScope(String baseName) {
        String name2 = baseName.replace('-', '_');
        int n = this.scopeNameCounters.add(name2);
        S scope = this.context.makeScope(String.valueOf(name2) + "-" + n);
        return scope;
    }

    protected final void doStart(List<S> rootScopes) {
        for (Object rootScope : CapsuleUtil.toSet(rootScopes)) {
            this.scopes.__insert(rootScope);
            this.doAddLocalShare(this.self, rootScope);
        }
    }

    protected final IFuture<IUnitResult<S, L, D, R>> doFinish(IFuture<R> result) {
        CompletableFuture<Object> internalResult = new CompletableFuture<Object>();
        TypeCheckerResult token = TypeCheckerResult.of(this.self, internalResult);
        this.waitFor(token, this.self);
        result.whenComplete(internalResult::complete);
        internalResult.whenComplete((r, ex) -> {
            logger.debug("{} type checker finished", this);
            this.resume();
            if (ex != null) {
                this.failures.add((Throwable)ex);
            } else {
                this.analysis.set(r);
            }
            this.granted(token, this.self);
            MultiSet.Immutable<IWaitFor<S, L, D>> selfTokens = this.getTokens(this.self);
            if (!selfTokens.isEmpty()) {
                logger.debug("{} returned while waiting on {}", this.self, selfTokens);
            }
            this.innerResult = true;
        });
        return this.unitResult;
    }

    protected <Q> Tuple2<IActorRef<? extends IUnit<S, L, D, Q>>, IFuture<IUnitResult<S, L, D, Q>>> doAddSubUnit(String id, Function2<IActor<IUnit<S, L, D, Q>>, IUnitContext<S, L, D>, IUnit<S, L, D, Q>> unitProvider, List<S> rootScopes) {
        for (S rootScope : rootScopes) {
            this.assertOwnOrSharedScope(rootScope);
        }
        Tuple2 result_subunit = this.context.add(id, unitProvider, rootScopes);
        IActorRef subunit = result_subunit._2();
        CompletableFuture<IUnitResult> internalResult = new CompletableFuture<IUnitResult>();
        TypeCheckerResult token = TypeCheckerResult.of(this.self, internalResult);
        this.waitFor(token, subunit);
        result_subunit._1().whenComplete(internalResult::complete);
        for (Object rootScope : CapsuleUtil.toSet(rootScopes)) {
            this.doAddShare(subunit, rootScope);
        }
        IFuture<IUnitResult> ret = internalResult.whenComplete((r, ex) -> {
            logger.debug("{} subunit {} finished", this, subunit);
            this.resume();
            this.granted(token, subunit);
            if (ex != null) {
                this.failures.add(new Exception("No result for sub unit " + id));
            } else {
                this.subUnitResults.put(id, (IUnitResult<S, L, D, ?>)r);
            }
        });
        return Tuple2.of(subunit, ret);
    }

    protected final S doFreshScope(String baseName, Iterable<L> edgeLabels, boolean data, boolean sharing) {
        S scope = this.makeScope(baseName);
        ArrayList labels = Lists.newArrayList();
        for (L l : edgeLabels) {
            labels.add(EdgeOrData.edge(l));
        }
        if (data) {
            labels.add(EdgeOrData.data());
        }
        this.scopes.__insert(scope);
        this.doAddLocalShare(this.self, scope);
        this.doInitShare(this.self, scope, labels, sharing);
        return scope;
    }

    protected final void doAddLocalShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.assertOwnOrSharedScope(scope);
        this.waitFor(InitScope.of(this.self, scope), sender);
    }

    protected final void doAddShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.doAddLocalShare(sender, scope);
        if (!this.isOwner(scope)) {
            this.self.async(this.parent)._addShare(scope);
        }
    }

    protected final void doInitShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        this.assertOwnOrSharedScope(scope);
        this.granted(InitScope.of(this.self, scope), sender);
        for (EdgeOrData<L> edge : edges) {
            this.waitFor(CloseLabel.of(this.self, scope, edge), sender);
        }
        if (sharing) {
            this.waitFor(CloseScope.of(this.self, scope), sender);
        }
        if (this.isOwner(scope)) {
            if (this.isScopeInitialized(scope)) {
                this.releaseDelays(scope);
            }
        } else {
            this.self.async(this.parent)._initShare(scope, edges, sharing);
        }
    }

    protected final void doSetDatum(S scope, D datum) {
        EdgeOrData edge = EdgeOrData.data();
        this.assertLabelOpen(scope, edge);
        this.scopeGraph.set(this.scopeGraph.get().setDatum(scope, datum));
        this.doCloseLabel(this.self, scope, edge);
    }

    protected final void doCloseScope(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.assertOwnOrSharedScope(scope);
        this.granted(CloseScope.of(this.self, scope), sender);
        if (this.isOwner(scope)) {
            if (this.isScopeInitialized(scope)) {
                this.releaseDelays(scope);
            }
        } else {
            this.self.async(this.parent)._doneSharing(scope);
        }
    }

    protected final void doCloseLabel(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope, EdgeOrData<L> edge) {
        this.assertOwnOrSharedScope(scope);
        this.granted(CloseLabel.of(this.self, scope, edge), sender);
        if (this.isOwner(scope)) {
            if (this.isEdgeClosed(scope, edge)) {
                this.releaseDelays(scope, edge);
            }
        } else {
            this.self.async(this.parent)._closeEdge(scope, edge);
        }
    }

    protected final void doAddEdge(IActorRef<? extends IUnit<S, L, D, ?>> sender, S source, L label, S target) {
        this.assertOwnOrSharedScope(source);
        this.assertLabelOpen(source, EdgeOrData.edge(label));
        this.scopeGraph.set(this.scopeGraph.get().addEdge(source, label, target));
        if (!this.isOwner(source)) {
            this.self.async(this.parent)._addEdge(source, label, target);
        }
    }

    protected final IFuture<Env<S, L, D>> doQuery(final IActorRef<? extends IUnit<S, L, D, ?>> sender, ScopePath<S, L> path, LabelWf<L> labelWF, LabelOrder<L> labelOrder, final DataWf<S, L, D> dataWF, final DataLeq<S, L, D> dataEquiv, final DataWf<S, L, D> dataWfInternal, final DataLeq<S, L, D> dataEquivInternal) {
        logger.debug("got _query from {}", sender);
        final boolean external = !sender.equals(this.self);
        NameResolution nr = new NameResolution<S, L, D>(this.edgeLabels, labelOrder){

            @Override
            public Optional<IFuture<Env<S, L, D>>> externalEnv(ScopePath<S, L> path, LabelWf<L> re, LabelOrder<L> labelOrder) {
                Object scope = path.getTarget();
                if (AbstractUnit.this.canAnswer(scope)) {
                    logger.debug("local env {}", scope);
                    return Optional.empty();
                }
                IActorRef owner = AbstractUnit.this.context.owner(scope);
                logger.debug("remote env {} at {}", scope, owner);
                IFuture result = AbstractUnit.this.self.async(owner)._query(path, re, dataWF, labelOrder, dataEquiv);
                Query wf = Query.of(sender, path, re, dataWF, labelOrder, dataEquiv, result);
                AbstractUnit.this.waitFor(wf, owner);
                if (external) {
                    ++AbstractUnit.this.stats.forwardedQueries;
                } else {
                    ++AbstractUnit.this.stats.outgoingQueries;
                }
                return Optional.of(result.whenComplete((r, ex) -> {
                    logger.debug("got answer from {}", sender);
                    AbstractUnit.this.resume();
                    AbstractUnit.this.granted(wf, owner);
                }));
            }

            @Override
            protected IFuture<Optional<D>> getDatum(S scope) {
                return AbstractUnit.this.isComplete(scope, EdgeOrData.data(), sender).thenCompose(__ -> {
                    Optional datum = AbstractUnit.this.scopeGraph.get().getData(scope);
                    if (!datum.isPresent()) {
                        return CompletableFuture.completedFuture(Optional.empty());
                    }
                    if (external || dataWfInternal == null) {
                        IFuture<Object> ret;
                        logger.debug("require external rep for {}", datum.get());
                        IFuture result = AbstractUnit.this.getExternalDatum(datum.get());
                        if (result.isDone()) {
                            ret = result;
                        } else {
                            CompletableFuture<Object> internalResult = new CompletableFuture<Object>();
                            TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(datum.get()), internalResult);
                            AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                            result.whenComplete(internalResult::complete);
                            ret = internalResult.whenComplete((rep, ex) -> {
                                AbstractUnit.this.self.assertOnActorThread();
                                AbstractUnit.this.granted(token, AbstractUnit.this.self);
                            });
                        }
                        return ret.thenApply(rep -> {
                            logger.debug("got external rep {} for {}", rep, datum.get());
                            return Optional.of(rep);
                        });
                    }
                    return CompletableFuture.completedFuture(datum);
                });
            }

            @Override
            protected IFuture<Iterable<S>> getEdges(S scope, L label) {
                return AbstractUnit.this.isComplete(scope, EdgeOrData.edge(label), sender).thenApply(__ -> AbstractUnit.this.scopeGraph.get().getEdges(scope, label));
            }

            @Override
            protected IFuture<Boolean> dataWf(D d, ICancel cancel) throws InterruptedException {
                ++AbstractUnit.this.stats.dataWfChecks;
                IFuture<Boolean> result = external || dataWfInternal == null ? dataWF.wf(d, AbstractUnit.this.queryContext, cancel) : dataWfInternal.wf(d, AbstractUnit.this.queryContext, cancel);
                if (result.isDone()) {
                    return result;
                }
                CompletableFuture<Boolean> internalResult = new CompletableFuture<Boolean>();
                TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(d), internalResult);
                AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                result.whenComplete(internalResult::complete);
                return internalResult.whenComplete((r, ex) -> {
                    AbstractUnit.this.self.assertOnActorThread();
                    AbstractUnit.this.granted(token, AbstractUnit.this.self);
                });
            }

            @Override
            protected IFuture<Boolean> dataLeq(D d1, D d2, ICancel cancel) throws InterruptedException {
                ++AbstractUnit.this.stats.dataLeqChecks;
                IFuture<Boolean> result = external || dataEquivInternal == null ? dataEquiv.leq(d1, d2, AbstractUnit.this.queryContext, cancel) : dataEquivInternal.leq(d1, d2, AbstractUnit.this.queryContext, cancel);
                if (result.isDone()) {
                    return result;
                }
                CompletableFuture<Boolean> internalResult = new CompletableFuture<Boolean>();
                TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(d1, d2), internalResult);
                AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                result.whenComplete(internalResult::complete);
                return internalResult.whenComplete((r, ex) -> {
                    AbstractUnit.this.self.assertOnActorThread();
                    AbstractUnit.this.granted(token, AbstractUnit.this.self);
                });
            }

            @Override
            public IFuture<Boolean> dataLeqAlwaysTrue(ICancel cancel) {
                return dataEquiv.alwaysTrue(AbstractUnit.this.queryContext, cancel);
            }
        };
        ICompletableFuture result = nr.env(path, labelWF, this.context.cancel());
        result.whenComplete((env, ex) -> logger.debug("have answer for {}", sender));
        return result;
    }

    protected final boolean isOwner(S scope) {
        IActorRef<IUnit<S, L, D, ?>> owner = this.context.owner(scope);
        return owner.equals(this.self);
    }

    protected boolean canAnswer(S scope) {
        return this.isOwner(scope);
    }

    protected boolean isWaiting() {
        return !this.waitFors.isEmpty();
    }

    protected boolean isWaitingFor(IWaitFor<S, L, D> token) {
        return this.waitFors.contains(token);
    }

    private MultiSet.Immutable<IWaitFor<S, L, D>> getTokens(IActorRef<? extends IUnit<S, L, D, ?>> unit) {
        return this.waitForsByActor.get(unit);
    }

    protected void waitFor(IWaitFor<S, L, D> token, IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        logger.debug("{} wait for {}/{}", this.self, actor, token);
        this.waitFors = this.waitFors.add(token);
        this.waitForsByActor = this.waitForsByActor.put(actor, token);
    }

    protected void granted(IWaitFor<S, L, D> token, IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        if (!this.waitForsByActor.contains(actor, token)) {
            logger.error("{} not waiting for granted {}/{}", this.self, actor, token);
            throw new IllegalStateException(this.self + " not waiting for granted " + actor + "/" + token);
        }
        this.waitFors = this.waitFors.remove(token);
        this.waitForsByActor = this.waitForsByActor.remove(actor, token);
    }

    protected void tryFinish() {
        logger.debug("{} tryFinish", this);
        if (this.innerResult && !this.unitResult.isDone() && !this.isWaiting()) {
            logger.debug("{} finish", this);
            this.unitResult.complete(UnitResult.of(this.self.id(), this.scopeGraph.get(), this.analysis.get(), this.failures, this.subUnitResults, (IUnitStats)this.stats));
        }
    }

    private void releaseDelays(S scope) {
        for (Map.Entry entry : this.delays.get(scope)) {
            EdgeOrData edge = (EdgeOrData)entry.getKey();
            if (this.isWaitingFor(CloseLabel.of(this.self, scope, edge))) continue;
            Delay delay = (Delay)entry.getValue();
            logger.debug("released {} on {}(/{})", delay, scope, edge);
            this.delays.remove(scope, edge, delay);
            this.self.complete(delay.future, Unit.unit, null);
        }
    }

    private void releaseDelays(S scope, EdgeOrData<L> edge) {
        for (Delay delay : this.delays.get(scope, edge)) {
            logger.debug("released {} on {}/{}", delay, scope, edge);
            this.delays.remove(scope, edge, delay);
            this.self.complete(delay.future, Unit.unit, null);
        }
    }

    private boolean isScopeInitialized(S scope) {
        return !this.isWaitingFor(InitScope.of(this.self, scope)) && !this.isWaitingFor(CloseScope.of(this.self, scope));
    }

    private boolean isEdgeClosed(S scope, EdgeOrData<L> edge) {
        return this.isScopeInitialized(scope) && !this.isWaitingFor(CloseLabel.of(this.self, scope, edge));
    }

    private IFuture<Unit> isComplete(S scope, EdgeOrData<L> edge, IActorRef<? extends IUnit<S, L, D, ?>> sender) {
        if (this.isEdgeClosed(scope, edge)) {
            return CompletableFuture.completedFuture(Unit.unit);
        }
        CompletableFuture<Unit> result = new CompletableFuture<Unit>();
        this.delays.put(scope, edge, new Delay(result, sender));
        return result;
    }

    protected void suspend() {
        this.cmh.idle();
    }

    protected void resume() {
        this.cmh.exec();
    }

    @Override
    public void _deadlockQuery(IActorRef<? extends IUnit<S, L, D, ?>> i, int m) {
        IActorRef<IUnit<S, L, D, ?>> j = this.self.sender(this.TYPE);
        this.cmh.query(i, m, j);
    }

    @Override
    public void _deadlockReply(IActorRef<? extends IUnit<S, L, D, ?>> i, int m, java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> R2) {
        this.cmh.reply(i, m, R2);
    }

    @Override
    public void _deadlocked(java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> nodes) {
        if (this.failDelays(nodes)) {
            this.resume();
        }
    }

    private void handleDeadlock(java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> nodes) {
        logger.debug("{} deadlocked with {}", this, nodes);
        if (!nodes.contains(this.self)) {
            throw new IllegalStateException("Deadlock unrelated to this unit.");
        }
        if (nodes.size() == 1) {
            logger.debug("{} self-deadlocked with {}", this, this.getTokens(this.self));
            if (this.failDelays(nodes)) {
                this.resume();
            } else {
                this.failAll();
            }
        } else {
            for (IActorRef<IUnit<S, L, D, ?>> iActorRef : nodes) {
                this.self.async(iActorRef)._deadlocked(nodes);
            }
        }
    }

    private boolean failDelays(java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> nodes) {
        Set.Transient deadlocked = CapsuleUtil.transientSet();
        for (Delay delay : this.delays.inverse().keySet()) {
            if (!nodes.contains(delay.sender)) continue;
            logger.debug("{} fail {}", this.self, delay);
            this.delays.inverse().remove(delay);
            deadlocked.__insert(delay.future);
        }
        for (IActorRef iActorRef : nodes) {
            for (IWaitFor iWaitFor : this.getTokens(iActorRef)) {
                iWaitFor.visit(IWaitFor.cases(initScope -> {}, closeScope -> {}, closeLabel -> {}, query -> {}, result -> {}, typeCheckerState -> {
                    if (nodes.contains(typeCheckerState.origin())) {
                        logger.debug("{} fail {}", this.self, typeCheckerState);
                        deadlocked.__insert(typeCheckerState.future());
                    }
                }));
            }
        }
        for (ICompletable iCompletable : deadlocked) {
            this.self.complete(iCompletable, null, new DeadlockException("Type checker deadlocked."));
        }
        return !deadlocked.isEmpty();
    }

    private void failAll() {
        for (IWaitFor iWaitFor : this.waitFors) {
            iWaitFor.visit(IWaitFor.cases(initScope -> {
                this.failures.add(new DeadlockException(initScope.toString()));
                this.granted((IWaitFor<S, L, D>)initScope, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(initScope.scope())) {
                    this.self.async(this.parent)._initShare(initScope.scope(), (Iterable<EdgeOrData<L>>)CapsuleUtil.immutableSet(), false);
                }
                this.releaseDelays(initScope.scope());
            }, closeScope -> {
                this.failures.add(new DeadlockException(closeScope.toString()));
                this.granted((IWaitFor<S, L, D>)closeScope, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(closeScope.scope())) {
                    this.self.async(this.parent)._doneSharing(closeScope.scope());
                }
                this.releaseDelays(closeScope.scope());
            }, closeLabel -> {
                this.failures.add(new DeadlockException(closeLabel.toString()));
                this.granted((IWaitFor<S, L, D>)closeLabel, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(closeLabel.scope())) {
                    this.self.async(this.parent)._closeEdge(closeLabel.scope(), closeLabel.label());
                }
                this.releaseDelays(closeLabel.scope(), closeLabel.label());
            }, query -> {
                logger.error("Unexpected remaining query: " + query);
                throw new IllegalStateException("Unexpected remaining query: " + query);
            }, result -> this.self.complete(result.future(), null, new DeadlockException("Type checker did not return a result.")), typeCheckerState -> {
                if (typeCheckerState.origin().equals(this.self)) {
                    logger.error("Unexpected remaining internal state: " + typeCheckerState);
                    throw new IllegalStateException("Unexpected remaining internal state: " + typeCheckerState);
                }
                this.self.complete(typeCheckerState.future(), null, new DeadlockException("Type checker deadlocked."));
            }));
        }
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> process() {
        return this.self;
    }

    @Override
    public java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> dependentSet() {
        return this.waitForsByActor.keySet();
    }

    @Override
    public void query(IActorRef<? extends IUnit<S, L, D, ?>> k, IActorRef<? extends IUnit<S, L, D, ?>> i, int m) {
        this.self.async(k)._deadlockQuery(i, m);
    }

    @Override
    public void reply(IActorRef<? extends IUnit<S, L, D, ?>> k, IActorRef<? extends IUnit<S, L, D, ?>> i, int m, java.util.Set<IActorRef<? extends IUnit<S, L, D, ?>>> R2) {
        this.self.async(k)._deadlockReply(i, m, R2);
    }

    @Override
    public void started() {
        logger.debug("{} started", this);
        this.wakeTimeNanos = System.nanoTime();
    }

    @Override
    public void resumed() {
        logger.debug("{} resumed", this);
        this.wakeTimeNanos = System.nanoTime();
    }

    @Override
    public void suspended() {
        logger.debug("{} suspended", this);
        long suspendTimeNanos = System.nanoTime();
        long activeTimeNanos = suspendTimeNanos - this.wakeTimeNanos;
        this.stats.runtimeNanos += activeTimeNanos;
        this.suspend();
        this.tryFinish();
    }

    @Override
    public void stopped(Throwable ex) {
        if (!this.unitResult.isDone()) {
            if (ex != null && ex instanceof InterruptedException) {
                this.unitResult.completeExceptionally(ex);
            } else {
                this.unitResult.completeExceptionally(new TypeCheckingFailedException(this + " stopped.", ex));
            }
        }
    }

    protected void assertOwnOrSharedScope(S scope) {
        if (!this.scopes.contains(scope)) {
            logger.error("Scope {} is not owned or shared by {}", scope, this);
            throw new IllegalArgumentException("Scope " + scope + " is not owned or shared by " + this);
        }
    }

    protected void assertLabelOpen(S scope, EdgeOrData<L> edge) {
        this.assertOwnOrSharedScope(scope);
        if (this.isEdgeClosed(scope, edge)) {
            logger.error("Label {}/{} is not open on {}.", scope, edge, this.self);
            throw new IllegalArgumentException("Label " + scope + "/" + edge + " is not open on " + this.self + ".");
        }
    }

    private class Delay {
        public final ICompletableFuture<Unit> future;
        public final IActorRef<? extends IUnit<S, L, D, ?>> sender;

        Delay(ICompletableFuture<Unit> future, IActorRef<? extends IUnit<S, L, D, ?>> sender) {
            this.future = future;
            this.sender = sender;
        }

        public String toString() {
            return "Delay{future=" + this.future + ",sender=" + this.sender + "}";
        }
    }

    protected static class Stats
    implements IUnitStats {
        protected int localQueries;
        protected int incomingQueries;
        protected int outgoingQueries;
        protected int forwardedQueries;
        protected long runtimeNanos;
        protected int dataWfChecks;
        protected int dataLeqChecks;
        private IActorStats actorStats;

        private Stats(IActorStats actorStats) {
            this.actorStats = actorStats;
        }

        @Override
        public Iterable<String> csvHeaders() {
            return Iterables.concat((Iterable)ImmutableList.of((Object)"runtimeMillis", (Object)"localQueries", (Object)"incomingQueries", (Object)"outgoingQueries", (Object)"forwardedQueries", (Object)"dataWfChecks", (Object)"dataLeqChecks"), this.actorStats.csvHeaders());
        }

        @Override
        public Iterable<String> csvRow() {
            return Iterables.concat((Iterable)ImmutableList.of((Object)Long.toString(TimeUnit.MILLISECONDS.convert(this.runtimeNanos, TimeUnit.NANOSECONDS)), (Object)Integer.toString(this.localQueries), (Object)Integer.toString(this.incomingQueries), (Object)Integer.toString(this.outgoingQueries), (Object)Integer.toString(this.forwardedQueries), (Object)Integer.toString(this.dataWfChecks), (Object)Integer.toString(this.dataLeqChecks)), this.actorStats.csvRow());
        }

        public String toString() {
            return "UnitStats{ownQueries=" + this.localQueries + ",foreignQueries=" + this.incomingQueries + ",forwardedQueries=" + this.outgoingQueries + "," + this.actorStats + "}";
        }
    }
}

