/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorMonitor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.IActorStats;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.impl.ActorException;
import mb.p_raffrayi.actors.impl.ActorState;
import mb.p_raffrayi.actors.impl.IActorContext;
import mb.p_raffrayi.actors.impl.IActorImpl;
import mb.p_raffrayi.actors.impl.IActorInternal;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

class Actor<T>
implements IActorImpl<T>,
Runnable {
    private static final ILogger logger = LoggerUtils.logger(Actor.class);
    private final IActorContext context;
    private final String id;
    private final TypeTag<T> type;
    private final IActorInternal<?> parent;
    private final Set<IActorInternal<?>> children;
    private final AtomicBoolean running;
    private final AtomicReference<Runnable> scheduledTask;
    private volatile ActorState state;
    private final AtomicInteger priority;
    private final Deque<Message> messages;
    private T impl;
    @Nullable
    private IActorMonitor monitor;
    @Nullable
    private Throwable stopCause;
    private volatile Thread thread = null;
    private static final ThreadLocal<IActorInternal<?>> current = ThreadLocal.withInitial(() -> {
        IllegalStateException ex = new IllegalStateException("Cannot get current actor.");
        logger.error("Cannot get current actor.", ex);
        throw ex;
    });
    private static final ThreadLocal<IActorRef<?>> sender = ThreadLocal.withInitial(() -> {
        logger.error("Cannot get sender. Not in message processing context?");
        throw new IllegalStateException("Cannot get sender. Not in message processing context?");
    });
    private Stats stats = new Stats();
    private volatile T dynamicAsync;

    Actor(IActorContext context, IActorInternal<?> parent, String id, TypeTag<T> type) {
        this.context = context;
        this.id = id;
        this.type = type;
        this.parent = parent;
        this.children = new HashSet();
        this.running = new AtomicBoolean();
        this.scheduledTask = new AtomicReference();
        this.state = ActorState.INITIAL;
        this.priority = new AtomicInteger(0);
        this.messages = new ConcurrentLinkedDeque<Message>();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.initThread();
            this.scheduledTask.set(null);
            int startPriority = this.priority.get();
            this.stats.maxPendingMessagesOnActivate = Math.max(this.stats.maxPendingMessagesOnActivate, startPriority);
            while (true) {
                this.stats.maxPendingMessages = Math.max(this.stats.maxPendingMessages, this.priority.get());
                Message message = this.messages.poll();
                if (message != null) {
                    Stats stats = this.stats;
                    stats.messages = stats.messages + 1;
                    this.priority.decrementAndGet();
                    try {
                        message.dispatch();
                    }
                    catch (Throwable ex) {
                        this.doStop(ex);
                    }
                    if (this.messages.isEmpty() || !this.context.scheduler().preempt(this.priority.get())) continue;
                    this.finalizeThread();
                    this.context.scheduler().schedule(this, this.priority.get(), this.scheduledTask);
                    return;
                }
                if (this.state.equals((Object)ActorState.RUNNING)) {
                    logger.debug("suspend");
                    Stats stats = this.stats;
                    stats.suspended = stats.suspended + 1;
                    this.state = ActorState.WAITING;
                    try {
                        if (this.monitor != null) {
                            this.monitor.suspended();
                        }
                    }
                    catch (Throwable ex) {
                        this.doStop(new ActorException("Suspend monitor failed.", ex));
                    }
                }
                this.finalizeThread();
                if (!this.running.compareAndSet(true, false)) {
                    throw new IllegalStateException("Unexpected state, should be running.");
                }
                if (this.messages.isEmpty() || !this.running.compareAndSet(false, true)) break;
                this.initThread();
            }
            return;
        }
        catch (Throwable ex) {
            logger.error("Internal error.", ex);
            return;
        }
    }

    private void initThread() {
        if (this.thread != null) {
            logger.error("Actor already running on another thread.");
            throw new IllegalStateException("Actor already running on another thread.");
        }
        this.thread = Thread.currentThread();
        current.set(this);
        LoggerUtils.setContextId(this.toString());
    }

    private void finalizeThread() {
        LoggerUtils.clearContextId();
        current.remove();
        this.thread = null;
    }

    private void scheduleIfNotRunning() {
        if (this.running.compareAndSet(false, true)) {
            logger.debug("resume {}", this);
            this.context.scheduler().schedule(this, this.priority.get(), this.scheduledTask);
        } else {
            Runnable oldTask = this.scheduledTask.getAndSet(null);
            if (oldTask != null) {
                this.context.scheduler().reschedule(oldTask, this.priority.get(), this.scheduledTask);
            }
        }
    }

    private void put(Message message) {
        this.priority.incrementAndGet();
        this.messages.add(message);
        this.scheduleIfNotRunning();
    }

    @Override
    public void _start(IActorInternal<?> sender, Function1<IActor<T>, ? extends T> supplier) {
        this.put(() -> this.doStart(sender, supplier));
    }

    @Override
    public T _invokeDynamic() {
        T result = this.dynamicAsync;
        if (result == null) {
            this.dynamicAsync = result = this.newAsync(current::get);
        }
        return result;
    }

    @Override
    public T _invokeStatic(IActorInternal<?> sender) {
        return this.newAsync(() -> sender);
    }

    private T newAsync(Function0<IActorInternal<?>> senderGetter) {
        return (T)Proxy.newProxyInstance(this.type.type().getClassLoader(), new Class[]{this.type.type()}, (proxy, method, args) -> {
            CompletableFuture returnValue;
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            if (method.getDeclaringClass().equals(IActorMonitor.class)) {
                logger.error("Illegal async actor monitor method called: {}", method);
                throw new IllegalStateException("Illegal async actor monitor method called: " + method);
            }
            IActorInternal sender = (IActorInternal)senderGetter.apply();
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE.isAssignableFrom(returnType)) {
                Method method1 = method;
                Object[] args1 = args;
                this.put(() -> this.doInvoke(sender, method1, args1, null));
                returnValue = null;
            } else if (IFuture.class.isAssignableFrom(returnType)) {
                CompletableFuture result = new CompletableFuture();
                Method method1 = method;
                Object[] args1 = args;
                Action2<Object, Throwable> _return = (r, ex) -> sender._return(sender, method, result, r, (Throwable)ex);
                this.put(() -> this.doInvoke(sender, method1, args1, _return));
                returnValue = result;
            } else {
                logger.error("Unsupported method called: {}", method);
                throw new IllegalStateException("Unsupported method called: " + method);
            }
            return returnValue;
        });
    }

    @Override
    public void _return(IActorInternal<?> sender, Method method, ICompletable result, Object value, Throwable ex) {
        this.put(() -> this.doReturn(sender, method, result, value, ex));
    }

    @Override
    public void _stop(IActorInternal<?> sender, Throwable ex) {
        logger.debug("{} recieved _stop from {}", this, sender);
        this.put(() -> this.doStop(ex));
    }

    @Override
    public void _childStopped(IActorInternal<?> sender, Throwable ex) {
        logger.debug("{} recieved _childStopped from {}", this, sender);
        this.put(() -> this.doChildStopped(sender, ex));
    }

    private void doStart(IActorInternal<?> sender, Function1<IActor<T>, ? extends T> supplier) throws ActorException {
        this.assertOnActorThread();
        if (!this.state.equals((Object)ActorState.INITIAL)) {
            throw new ActorException("Cannot start actor that was already started.");
        }
        if (!sender.equals(this.parent)) {
            throw new ActorException("Actor can only be started by parent.");
        }
        try {
            this.impl = supplier.apply(this);
        }
        catch (Throwable ex) {
            throw new ActorException("Creating actor implementation failed.", ex);
        }
        if (IActorMonitor.class.isAssignableFrom(this.impl.getClass())) {
            this.monitor = (IActorMonitor)this.impl;
        }
        this.state = ActorState.RUNNING;
        try {
            if (this.monitor != null) {
                this.monitor.started();
            }
        }
        catch (Throwable ex) {
            throw new ActorException("Start monitor failed.", ex);
        }
    }

    private void doInvoke(IActorInternal<?> sender, Method method, Object[] args, Action2<Object, Throwable> result) throws ActorException {
        this.assertOnActorThread();
        this.updateStateOnReceive(sender);
        logger.debug("{} invoke {} from {}", this, method.getName(), sender);
        try {
            Object returnValue;
            method.setAccessible(true);
            try {
                Actor.sender.set(sender);
                returnValue = method.invoke(this.impl, args);
            }
            finally {
                Actor.sender.remove();
            }
            if (result != null) {
                if (returnValue == null) {
                    result.apply(null, new NullPointerException());
                } else {
                    ((IFuture)returnValue).whenComplete((r, ex) -> result.apply(r, (Throwable)ex));
                }
            }
        }
        catch (Throwable ex2) {
            throw new ActorException("Dispatch failed.", ex2);
        }
    }

    private void doReturn(IActorInternal<?> sender, Method method, ICompletable completable, Object value, Throwable ex) throws ActorException {
        this.assertOnActorThread();
        this.updateStateOnReceive(sender);
        logger.debug("{} return {} from {}", this, method.getName(), sender);
        try {
            try {
                Actor.sender.set(sender);
                completable.complete(value, ex);
            }
            finally {
                Actor.sender.remove();
            }
        }
        catch (Throwable ex2) {
            throw new ActorException("Return failed.", ex2);
        }
    }

    private void updateStateOnReceive(IActorInternal<?> sender) throws ActorException {
        switch (this.state) {
            case INITIAL: {
                throw new ActorException("Cannot invoke method on actor that was not started.");
            }
            case RUNNING: {
                break;
            }
            case WAITING: {
                this.state = ActorState.RUNNING;
                try {
                    if (this.monitor == null) break;
                    this.monitor.resumed();
                    break;
                }
                catch (Throwable ex) {
                    throw new ActorException("Resume monitor failed.", ex);
                }
            }
            case STOPPING: 
            case STOPPED: {
                Throwable ex2 = this.stopCause;
                if (ex2 == null || !(ex2 instanceof InterruptedException)) {
                    ex2 = new ActorException("Receiving actor stopping.", ex2);
                }
                sender._stop(this, ex2);
                break;
            }
            default: {
                throw new ActorException("Unexpected state " + (Object)((Object)this.state));
            }
        }
    }

    private void doStop(Throwable ex) {
        this.assertOnActorThread();
        switch (this.state) {
            case INITIAL: 
            case RUNNING: 
            case WAITING: {
                Throwable ex2;
                if (ex != null) {
                    if (ex instanceof InterruptedException) {
                        logger.debug("{} interrupted", this);
                    } else {
                        logger.error("{} failed", ex, this);
                    }
                }
                if ((ex2 = ex) != null && !(ex2 instanceof InterruptedException)) {
                    ex2 = new ActorException("Actor " + this + " failed", ex);
                }
                this.state = ActorState.STOPPING;
                this.stopCause = ex2;
                for (IActorInternal<?> child : this.children) {
                    child._stop(this, ex2);
                }
                this.stopIfNoMoreChildren();
                break;
            }
            case STOPPING: 
            case STOPPED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
            }
        }
    }

    private void doChildStopped(IActorInternal<?> sender, Throwable ex) throws ActorException {
        this.assertOnActorThread();
        if (!this.children.remove(sender)) {
            throw new ActorException("Stopped actor " + sender + " is not a child of actor " + this);
        }
        Throwable ex2 = ex;
        if (ex2 != null && !(ex2 instanceof InterruptedException)) {
            ex2 = new ActorException("Child " + sender + " of " + this + " failed", ex);
        }
        switch (this.state) {
            case INITIAL: {
                logger.error("Child {} stopped before parent {} started.", sender, this);
                throw new IllegalStateException("Child " + sender + " stopped before parent " + this + " started.");
            }
            case RUNNING: 
            case WAITING: {
                this.doStop(ex2);
                this.stopIfNoMoreChildren();
                return;
            }
            case STOPPING: {
                this.stopIfNoMoreChildren();
                return;
            }
            case STOPPED: {
                logger.error("Child {} stopped after parent {} stopped.", sender, this);
                throw new IllegalStateException("Child " + sender + " stopped after parent " + this + " stopped.");
            }
        }
        throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
    }

    private void stopIfNoMoreChildren() {
        if (!this.state.equals((Object)ActorState.STOPPING)) {
            return;
        }
        if (!this.children.isEmpty()) {
            return;
        }
        this.state = ActorState.STOPPED;
        try {
            if (this.monitor != null) {
                this.monitor.stopped(this.stopCause);
            }
        }
        catch (Throwable ex2) {
            logger.error("Stop monitor failed.", ex2);
        }
        this.parent._childStopped(this, this.stopCause);
    }

    @Override
    public <U> IActorRef<U> add(String id, TypeTag<U> type, Function1<IActor<U>, U> supplier) {
        IActorImpl<U> actor = this.context.add(this, id, type);
        this.children.add(actor);
        actor._start(this, supplier);
        return actor;
    }

    @Override
    public <U> U async(IActorRef<U> receiver) {
        return this.context.async(receiver);
    }

    @Override
    public T local() {
        return this._invokeDynamic();
    }

    @Override
    public <U> IFuture<U> schedule(IFuture<U> future) {
        CompletableFuture scheduled = new CompletableFuture();
        future.whenComplete((r, ex) -> this.put(() -> scheduled.complete(r, (Throwable)ex)));
        return scheduled;
    }

    @Override
    public <U> void complete(ICompletable<U> completable, U result, Throwable ex) {
        this.put(() -> completable.complete(result, ex));
    }

    @Override
    public IActorRef<?> sender() {
        return sender.get();
    }

    @Override
    public <U> IActorRef<U> sender(TypeTag<U> type) {
        return sender.get();
    }

    public String toString() {
        return "actor:" + this.id;
    }

    @Override
    public void assertOnActorThread() {
        if (this.thread == null) {
            logger.error("Actor {} is not running.", this);
            throw new IllegalStateException("Actor " + this + " is not running.");
        }
        IActorInternal<?> current = Actor.current.get();
        if (this.thread != Thread.currentThread()) {
            logger.error("Actor {} is running on a different thread. (This thread is actor {}).", this, current);
            throw new IllegalStateException("Actor " + this + " is running on a different thread. (This thread is actor " + current + ").");
        }
        if (!current.equals(this)) {
            logger.error("Actor {} is running, but thread and current are inconsistent.", this);
            throw new IllegalStateException("Actor " + this + " is running, but thread and current are inconsistent.");
        }
    }

    @Override
    public IActorStats stats() {
        return this.stats;
    }

    @FunctionalInterface
    private static interface Message {
        public void dispatch() throws ActorException;
    }

    private static class Stats
    implements IActorStats {
        private int suspended = 0;
        private int preempted = 0;
        private int rescheduled = 0;
        private int messages = 0;
        private int maxPendingMessages = 0;
        private int maxPendingMessagesOnActivate = 0;

        private Stats() {
        }

        @Override
        public Iterable<String> csvHeaders() {
            return ImmutableList.of((Object)"suspended", (Object)"preempted", (Object)"rescheduled", (Object)"messages", (Object)"maxPendingMessages", (Object)"maxPendingMessagesOnActivate");
        }

        @Override
        public Iterable<String> csvRow() {
            return ImmutableList.of((Object)Integer.toString(this.suspended), (Object)Integer.toString(this.preempted), (Object)Integer.toString(this.rescheduled), (Object)Integer.toString(this.messages), (Object)Integer.toString(this.maxPendingMessages), (Object)Integer.toString(this.maxPendingMessagesOnActivate));
        }

        public String toString() {
            return "ActorStats{messages=" + this.messages + ",maxPendingMessages=" + this.maxPendingMessages + ",maxPendingMessagesOnActivate=" + this.maxPendingMessagesOnActivate + ",suspended=" + this.suspended + ",preempted=" + this.preempted + ",rescheduled=" + this.rescheduled + "}";
        }
    }
}

