/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.deadlock;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.util.Set;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ChandyMisraHaas<P> {
    private static final ILogger logger = LoggerUtils.logger(ChandyMisraHaas.class);
    private final Host<P> self;
    private final Action1<Set<P>> deadlockHandler;
    private State state;
    private final MultiSet.Transient<P> latest;
    private final Map.Transient<P, P> engager;
    private final MultiSet.Transient<P> num;
    private SetMultimap.Transient<P, P> wait;

    public ChandyMisraHaas(Host<P> self, Action1<Set<P>> deadlockHandler) {
        this.self = self;
        this.deadlockHandler = deadlockHandler;
        this.state = State.EXECUTING;
        this.latest = MultiSet.Transient.of();
        this.engager = Map.Transient.of();
        this.num = MultiSet.Transient.of();
        this.wait = SetMultimap.Transient.of();
    }

    public boolean idle() {
        if (this.state.equals((Object)State.IDLE)) {
            return false;
        }
        logger.debug("{} idle", this.self);
        P i = this.self.process();
        this.state = State.IDLE;
        this.latest.add(i);
        this.wait.__insert(i, i);
        Set<P> S2 = this.self.dependentSet();
        for (P j : S2) {
            this.self.query(j, i, this.latest.count(i));
        }
        this.num.set(i, S2.size());
        return true;
    }

    public boolean exec() {
        if (this.state.equals((Object)State.EXECUTING)) {
            return false;
        }
        logger.debug("{} exec", this.self);
        P k = this.self.process();
        this.state = State.EXECUTING;
        this.wait = SetMultimap.Transient.of();
        return true;
    }

    public void query(P i, int m, P j) {
        if (this.state.equals((Object)State.EXECUTING)) {
            return;
        }
        logger.debug("{} query {}.{} from {}", this.self, i, m, j);
        P k = this.self.process();
        if (m > this.latest.count(i)) {
            this.latest.set(i, m);
            this.engager.put(i, j);
            this.wait.__insert(i, k);
            Set<P> S2 = this.self.dependentSet();
            for (P r : S2) {
                this.self.query(r, i, m);
            }
            this.num.set(i, S2.size());
        } else if (this.wait.containsKey(i) && m == this.latest.count(i)) {
            this.self.reply(j, i, m, (Set<P>)this.wait.get(i));
        }
    }

    public void reply(P i, int m, Set<P> R2) {
        if (this.state.equals((Object)State.EXECUTING)) {
            return;
        }
        logger.debug("{} reply {}.{} from {}", this.self, i, m, R2);
        P k = this.self.process();
        if (m == this.latest.count(i) && this.wait.containsKey(i)) {
            for (P r : R2) {
                this.wait.__insert(i, r);
            }
            if (this.num.remove(i) == 1) {
                Set.Immutable Q2 = this.wait.get(i);
                if (i.equals(k)) {
                    logger.debug("{} deadlocked with {}", this.self, Q2);
                    this.deadlockHandler.apply((Set<P>)Q2);
                } else {
                    Object j = this.engager.get(i);
                    this.self.reply(j, i, m, (Set<Object>)Q2);
                }
            }
        }
    }

    public static interface Host<P> {
        public P process();

        public Set<P> dependentSet();

        public void query(P var1, P var2, int var3);

        public void reply(P var1, P var2, int var3, Set<P> var4);
    }

    static enum State {
        IDLE,
        EXECUTING;

    }
}

