/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.incscc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.util.graph.alg.counting.CountingAlg;
import mb.nabl2.util.graph.alg.dred.DRedTcRelation;
import mb.nabl2.util.graph.alg.incscc.CountingListener;
import mb.nabl2.util.graph.alg.misc.CollectionsFactory;
import mb.nabl2.util.graph.alg.misc.DFSPathFinder;
import mb.nabl2.util.graph.alg.misc.Direction;
import mb.nabl2.util.graph.alg.misc.GraphHelper;
import mb.nabl2.util.graph.alg.misc.IGraphPathFinder;
import mb.nabl2.util.graph.alg.misc.Tuple;
import mb.nabl2.util.graph.alg.misc.bfs.BFS;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;
import mb.nabl2.util.graph.alg.misc.unionfind.UnionFind;
import mb.nabl2.util.graph.alg.scc.SCC;
import mb.nabl2.util.graph.alg.scc.SCCResult;
import mb.nabl2.util.graph.graphimpl.Graph;
import mb.nabl2.util.graph.igraph.IBiDirectionalGraphDataSource;
import mb.nabl2.util.graph.igraph.IBiDirectionalWrapper;
import mb.nabl2.util.graph.igraph.IGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphObserver;
import mb.nabl2.util.graph.igraph.ITcDataSource;
import mb.nabl2.util.graph.igraph.ITcObserver;

public class IncSCCAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    public UnionFind<V> sccs;
    public IBiDirectionalGraphDataSource<V> gds;
    private CountingAlg<V> counting;
    private Graph<V> reducedGraph;
    private IBiDirectionalGraphDataSource<V> reducedGraphIndexer;
    private List<ITcObserver<V>> observers;
    private CountingListener<V> countingListener;

    public IncSCCAlg(IGraphDataSource<V> graphDataSource) {
        this.gds = graphDataSource instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)graphDataSource : new IBiDirectionalWrapper<V>(graphDataSource);
        this.observers = CollectionsFactory.createObserverList();
        this.sccs = new UnionFind();
        this.reducedGraph = new Graph();
        this.reducedGraphIndexer = new IBiDirectionalWrapper<V>(this.reducedGraph);
        this.countingListener = new CountingListener(this);
        this.initalizeInternalDataStructures();
        this.gds.attachObserver(this);
    }

    private void initalizeInternalDataStructures() {
        SCCResult<V> _sccres = SCC.computeSCC(this.gds);
        Set<Set<V>> _sccs = _sccres.getSccs();
        for (Set<V> _set : _sccs) {
            this.sccs.makeSet(_set);
        }
        for (Object n : this.sccs.getPartitionHeads()) {
            this.reducedGraph.insertNode(n);
        }
        for (Object source : this.gds.getAllNodes()) {
            IMemoryView<Object> targetNodes = this.gds.getTargetNodes(source);
            for (Map.Entry<Object, Integer> entry : targetNodes.entriesWithMultiplicities()) {
                int i = 0;
                while (i < entry.getValue()) {
                    Object targetRoot;
                    Object target = entry.getKey();
                    Object sourceRoot = this.sccs.find(source);
                    if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
                        this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                    }
                    ++i;
                }
            }
        }
        this.counting = new CountingAlg<V>(this.reducedGraph);
    }

    @Override
    public void edgeInserted(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.counting.isReachable(targetRoot, sourceRoot)) {
                Collection<Object> targetSCCs;
                Collection<Object> sourceSCCs;
                Set<V> predecessorRoots = this.counting.getAllReachableSources(sourceRoot);
                Set<V> successorRoots = this.counting.getAllReachableTargets(targetRoot);
                Set isectRoots = Sets.intersection(predecessorRoots, successorRoots).copyInto((Set)Sets.newHashSet());
                isectRoots.add(sourceRoot);
                isectRoots.add(targetRoot);
                if (this.observers.size() > 0) {
                    sourceSCCs = IncSCCAlg.createSetNullTolerant(predecessorRoots);
                    sourceSCCs.add(sourceRoot);
                    targetSCCs = IncSCCAlg.createSetNullTolerant(successorRoots);
                    targetSCCs.add(targetRoot);
                    for (Object e : sourceSCCs) {
                        for (Object e2 : targetSCCs) {
                            boolean needsNotification;
                            if (this.counting.isReachable(e, e2)) continue;
                            boolean bl = needsNotification = e.equals(e2) && this.sccs.getPartition(e).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(e).iterator().next(), this.gds) == 0 || !e.equals(e2);
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(e), (V)this.sccs.getPartition(e2), Direction.INSERT);
                        }
                    }
                }
                sourceSCCs = new ArrayList();
                targetSCCs = new ArrayList();
                for (Object e : isectRoots) {
                    List list2 = this.getSourceSCCsOfSCC(e);
                    List list3 = this.getTargetSCCsOfSCC(e);
                    for (Object sourceSCC : list2) {
                        if (sourceSCC.equals(e)) continue;
                        this.reducedGraph.deleteEdgeIfExists(sourceSCC, e);
                    }
                    for (Object targetSCC : list3) {
                        if (isectRoots.contains(targetSCC) || e.equals(targetSCC)) continue;
                        this.reducedGraph.deleteEdgeIfExists(e, targetSCC);
                    }
                    sourceSCCs.addAll(list2);
                    targetSCCs.addAll(list3);
                }
                for (Object e : isectRoots) {
                    this.reducedGraph.deleteNode(e);
                }
                Iterator iterator = isectRoots.iterator();
                Object newRoot = iterator.next();
                while (iterator.hasNext()) {
                    newRoot = this.sccs.union(newRoot, iterator.next());
                }
                this.reducedGraph.insertNode(newRoot);
                Set<V> set = this.sccs.getPartition(newRoot);
                for (Object e : sourceSCCs) {
                    if (set.contains(e) || e.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(e, newRoot);
                }
                for (Object e : targetSCCs) {
                    if (set.contains(e) || e.equals(newRoot)) continue;
                    this.reducedGraph.insertEdge(newRoot, e);
                }
            } else {
                if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
                    this.counting.attachObserver(this.countingListener);
                }
                this.reducedGraph.insertEdge(sourceRoot, targetRoot);
                this.counting.detachObserver(this.countingListener);
            }
        } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 1) {
            this.notifyTcObservers(source, source, Direction.INSERT);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (!sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            if (this.observers.size() > 0 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.counting.attachObserver(this.countingListener);
            }
            this.reducedGraph.deleteEdgeIfExists(sourceRoot, targetRoot);
            this.counting.detachObserver(this.countingListener);
        } else {
            IBiDirectionalGraphDataSource<V> g = GraphHelper.getSubGraph(this.sccs.getPartition(sourceRoot), this.gds);
            if (!BFS.isReachable(source, target, g)) {
                int i;
                SCCResult<V> _newSccs = SCC.computeSCC(g);
                for (Map.Entry<V, Integer> entry : this.reducedGraphIndexer.getSourceNodes(sourceRoot).entriesWithMultiplicities()) {
                    V v = entry.getKey();
                    i = 0;
                    while (i < entry.getValue()) {
                        this.reducedGraph.deleteEdgeIfExists(v, sourceRoot);
                        ++i;
                    }
                }
                for (Map.Entry<V, Integer> entry : this.reducedGraphIndexer.getTargetNodes(sourceRoot).entriesWithMultiplicities()) {
                    V v = entry.getKey();
                    i = 0;
                    while (i < entry.getValue()) {
                        this.reducedGraph.deleteEdgeIfExists(sourceRoot, v);
                        ++i;
                    }
                }
                this.sccs.deleteSet(sourceRoot);
                this.reducedGraph.deleteNode(sourceRoot);
                Set<Set<V>> newSCCs = _newSccs.getSccs();
                Set<Set<V>> newSCCRoots = CollectionsFactory.createSet();
                for (Set<V> set : newSCCs) {
                    Set<V> newRoot = this.sccs.makeSet(set);
                    this.reducedGraph.insertNode(newRoot);
                    newSCCRoots.add(newRoot);
                }
                for (Object object : newSCCRoots) {
                    List<Object> sourceSCCsOfSCC = this.getSourceSCCsOfSCC(object);
                    List<Object> targetSCCsOfSCC = this.getTargetSCCsOfSCC(object);
                    for (Object sourceSCC : sourceSCCsOfSCC) {
                        if (sourceSCC.equals(object)) continue;
                        this.reducedGraph.insertEdge(this.sccs.find(sourceSCC), object);
                    }
                    for (Object targetSCC : targetSCCsOfSCC) {
                        if (newSCCRoots.contains(targetSCC) || targetSCC.equals(object)) continue;
                        this.reducedGraph.insertEdge(object, targetSCC);
                    }
                }
                if (this.observers.size() > 0) {
                    V v = this.sccs.find(source);
                    V newTargetRoot = this.sccs.find(target);
                    Set<Object> sourceSCCs = IncSCCAlg.createSetNullTolerant(this.counting.getAllReachableSources(v));
                    sourceSCCs.add(v);
                    Set<V> targetSCCs = IncSCCAlg.createSetNullTolerant(this.counting.getAllReachableTargets(newTargetRoot));
                    targetSCCs.add(newTargetRoot);
                    for (Object sourceSCC : sourceSCCs) {
                        for (V targetSCC : targetSCCs) {
                            boolean needsNotification;
                            if (this.counting.isReachable(sourceSCC, targetSCC)) continue;
                            boolean bl = needsNotification = sourceSCC.equals(targetSCC) && this.sccs.getPartition(sourceSCC).size() == 1 && GraphHelper.getEdgeCount(this.sccs.getPartition(sourceSCC).iterator().next(), this.gds) == 0 || !sourceSCC.equals(targetSCC);
                            if (!needsNotification) continue;
                            this.notifyTcObservers((V)this.sccs.getPartition(sourceSCC), (V)this.sccs.getPartition(targetSCC), Direction.DELETE);
                        }
                    }
                }
            } else if (this.observers.size() > 0 && this.sccs.getPartition(sourceRoot).size() == 1 && GraphHelper.getEdgeCount(source, target, this.gds) == 0) {
                this.notifyTcObservers(source, source, Direction.DELETE);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
        this.sccs.makeSet(n);
        this.reducedGraph.insertNode(n);
    }

    @Override
    public void nodeDeleted(V n) {
        int i;
        IMemoryView<V> sources = this.gds.getSourceNodes(n);
        IMemoryView<V> targets = this.gds.getTargetNodes(n);
        for (Map.Entry<V, Integer> entry : sources.entriesWithMultiplicities()) {
            i = 0;
            while (i < entry.getValue()) {
                V source = entry.getKey();
                this.edgeDeleted(source, n);
                ++i;
            }
        }
        for (Map.Entry<V, Integer> entry : targets.entriesWithMultiplicities()) {
            i = 0;
            while (i < entry.getValue()) {
                V target = entry.getKey();
                this.edgeDeleted(n, target);
                ++i;
            }
        }
        this.sccs.deleteSet(n);
    }

    @Override
    public void attachObserver(ITcObserver<V> to2) {
        this.observers.add(to2);
    }

    @Override
    public void detachObserver(ITcObserver<V> to2) {
        this.observers.remove(to2);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        Set<V> rootSet;
        V sourceRoot = this.sccs.find(source);
        Set<V> containedNodes = this.sccs.getPartition(sourceRoot);
        Set<V> targets = CollectionsFactory.createSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(source, this.gds) == 1) {
            targets.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableTargets(sourceRoot)) != null) {
            for (V _root : rootSet) {
                targets.addAll(this.sccs.getPartition(_root));
            }
        }
        return targets;
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        Set<V> rootSet;
        V targetRoot = this.sccs.find(target);
        Set<V> containedNodes = this.sccs.getPartition(targetRoot);
        Set<V> sources = CollectionsFactory.createSet();
        if (containedNodes.size() > 1 || GraphHelper.getEdgeCount(target, this.gds) == 1) {
            sources.addAll(containedNodes);
        }
        if ((rootSet = this.counting.getAllReachableSources(targetRoot)) != null) {
            for (V _root : rootSet) {
                sources.addAll(this.sccs.getPartition(_root));
            }
        }
        return sources;
    }

    @Override
    public boolean isReachable(V source, V target) {
        V targetRoot;
        V sourceRoot = this.sccs.find(source);
        if (sourceRoot.equals(targetRoot = this.sccs.find(target))) {
            return true;
        }
        return this.counting.isReachable(sourceRoot, targetRoot);
    }

    public List<V> getReachabilityPath(V source, V target) {
        if (!this.isReachable(source, target)) {
            return null;
        }
        Set sccsInSubGraph = Sets.intersection(this.counting.getAllReachableTargets(source), this.counting.getAllReachableSources(target)).copyInto((Set)Sets.newHashSet());
        sccsInSubGraph.add(this.sccs.find(source));
        sccsInSubGraph.add(this.sccs.find(target));
        Set<V> nodesInSubGraph = CollectionsFactory.createSet();
        for (Object sccRoot : sccsInSubGraph) {
            nodesInSubGraph.addAll(this.sccs.getPartition(sccRoot));
        }
        return GraphHelper.constructPath(source, target, nodesInSubGraph, this.gds);
    }

    public boolean checkTcRelation(DRedTcRelation<V> tc) {
        for (V s : tc.getTupleStarts()) {
            for (V t : tc.getTupleEnds(s)) {
                if (this.isReachable(s, t)) continue;
                return false;
            }
        }
        for (V root : this.counting.getTcRelation().getTupleStarts()) {
            for (V end : this.counting.getTcRelation().getTupleEnds(root)) {
                for (V s : this.sccs.getPartition(root)) {
                    for (V t : this.sccs.getPartition(end)) {
                        if (tc.containsTuple(s, t)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private List<V> getSourceSCCsOfSCC(V root) {
        ArrayList<V> sourceSCCs = new ArrayList<V>();
        for (V containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (V source : sourceNodes.distinctValues()) {
                sourceSCCs.add(this.sccs.find(source));
            }
        }
        return sourceSCCs;
    }

    public boolean hasIncomingEdges(V root) {
        for (V containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> sourceNodes = this.gds.getSourceNodes(containedNode);
            for (V source : sourceNodes.distinctValues()) {
                V otherRoot = this.sccs.find(source);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    private List<V> getTargetSCCsOfSCC(V root) {
        ArrayList<V> targetSCCs = new ArrayList<V>();
        for (V containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> targetNodes = this.gds.getTargetNodes(containedNode);
            for (V target : targetNodes.distinctValues()) {
                targetSCCs.add(this.sccs.find(target));
            }
        }
        return targetSCCs;
    }

    public boolean hasOutgoingEdges(V root) {
        for (V containedNode : this.sccs.getPartition(root)) {
            IMemoryView<V> targetNodes = this.gds.getTargetNodes(containedNode);
            for (V target : targetNodes.distinctValues()) {
                V otherRoot = this.sccs.find(target);
                if (Objects.equals(root, otherRoot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.gds.detachObserver(this);
        this.counting.dispose();
    }

    protected void notifyTcObservers(Set<V> sources, Set<V> targets, Direction direction) {
        for (V s : sources) {
            for (V t : targets) {
                this.notifyTcObservers(s, t, direction);
            }
        }
    }

    private void notifyTcObservers(V source, V target, Direction direction) {
        for (ITcObserver<V> observer : this.observers) {
            if (direction == Direction.INSERT) {
                observer.tupleInserted(source, target);
            }
            if (direction != Direction.DELETE) continue;
            observer.tupleDeleted(source, target);
        }
    }

    public V getRepresentative(V node) {
        return this.sccs.find(node);
    }

    public Set<Tuple<V>> getTcRelation() {
        HashSet<Tuple<V>> resultSet = new HashSet<Tuple<V>>();
        for (V sourceRoot : this.sccs.getPartitionHeads()) {
            Set<V> reachableTargets;
            Set<V> sources = this.sccs.getPartition(sourceRoot);
            if (sources.size() > 1 || GraphHelper.getEdgeCount(sources.iterator().next(), this.gds) == 1) {
                for (V source : sources) {
                    for (V target : sources) {
                        resultSet.add(new Tuple<V>(source, target));
                    }
                }
            }
            if ((reachableTargets = this.counting.getAllReachableTargets(sourceRoot)) == null) continue;
            for (V targetRoot : reachableTargets) {
                for (V source : sources) {
                    for (V target : this.sccs.getPartition(targetRoot)) {
                        resultSet.add(new Tuple<V>(source, target));
                    }
                }
            }
        }
        return resultSet;
    }

    public boolean isIsolated(V node) {
        IMemoryView<V> targets = this.gds.getTargetNodes(node);
        IMemoryView<V> sources = this.gds.getSourceNodes(node);
        return targets.isEmpty() && sources.isEmpty();
    }

    @Override
    public IGraphPathFinder<V> getPathFinder() {
        return new DFSPathFinder<V>(this.gds, this);
    }

    public Graph<V> getReducedGraph() {
        return this.reducedGraph;
    }

    private static <V> Set<V> createSetNullTolerant(Set<V> initial) {
        if (initial != null) {
            return CollectionsFactory.createSet(initial);
        }
        return CollectionsFactory.createSet();
    }
}

