/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.ud;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.BaseUnifier;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.nabl2.terms.unification.ud.BaseUniDisunifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Predicate1;

public abstract class PersistentUniDisunifier
extends BaseUniDisunifier
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final Immutable FINITE_EMPTY = new Immutable(PersistentUnifier.Immutable.of(true), CapsuleUtil.immutableSet());
    private static final Immutable INFINITE_EMPTY = new Immutable(PersistentUnifier.Immutable.of(false), CapsuleUtil.immutableSet());

    protected static ITermVar findRep(ITermVar var, Map.Transient<ITermVar, ITermVar> reps) {
        ITermVar rep = (ITermVar)reps.get((Object)var);
        if (rep == null) {
            return var;
        }
        rep = PersistentUniDisunifier.findRep(rep, reps);
        reps.__put((Object)var, (Object)rep);
        return rep;
    }

    public static class Immutable
    extends PersistentUniDisunifier
    implements IUniDisunifier.Immutable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final PersistentUnifier.Immutable unifier;
        private final Set.Immutable<Diseq> disequalities;

        Immutable(boolean finite, Map.Immutable<ITermVar, ITermVar> reps, Map.Immutable<ITermVar, Integer> ranks, Map.Immutable<ITermVar, ITerm> terms, Set.Immutable<Diseq> disequalities) {
            this(PersistentUnifier.Immutable.of(finite, reps, ranks, terms), disequalities);
        }

        Immutable(PersistentUnifier.Immutable unifier, Set.Immutable<Diseq> disequalities) {
            this.unifier = unifier;
            this.disequalities = disequalities;
        }

        @Override
        public boolean isFinite() {
            return this.unifier.isFinite();
        }

        @Override
        protected IUnifier.Immutable unifier() {
            return this.unifier;
        }

        @Override
        public Set.Immutable<Diseq> disequalities() {
            return this.disequalities;
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            return this.unifier.findRep(var);
        }

        @Override
        public Set.Immutable<ITermVar> domainSet() {
            return this.unifier.domainSet();
        }

        @Override
        public Set.Immutable<ITermVar> rangeSet() {
            return this.unifier.rangeSet();
        }

        @Override
        public Set.Immutable<ITermVar> varSet() {
            return this.unifier.varSet();
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(ITerm left, ITerm right, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            BaseUnifier.ImmutableResult r = this.unifier.unify(left, right, isRigid).orElse(null);
            if (r == null) {
                return Optional.empty();
            }
            return Immutable.normalizeDiseqs(r.unifier(), this.disequalities).map(ud -> new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), (Immutable)ud));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            BaseUnifier.ImmutableResult r = this.unifier.unify(equalities, isRigid).orElse(null);
            if (r == null) {
                return Optional.empty();
            }
            return Immutable.normalizeDiseqs(r.unifier(), this.disequalities).map(ud -> new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), (Immutable)ud));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(IUnifier other, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            BaseUnifier.ImmutableResult r = this.unifier.unify(other, isRigid).orElse(null);
            if (r == null) {
                return Optional.empty();
            }
            return Immutable.normalizeDiseqs(r.unifier(), this.disequalities).map(ud -> new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), (Immutable)ud));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> uniDisunify(IUniDisunifier other, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            BaseUnifier.ImmutableResult r = this.unifier.unify(other, isRigid).orElse(null);
            if (r == null) {
                return Optional.empty();
            }
            PersistentUnifier.Transient unifier = new PersistentUnifier.Transient(r.unifier());
            for (Diseq diseq : other.disequalities()) {
                for (ITermVar var : diseq.freeVarSet()) {
                    unifier.addRangeVar(var, 1);
                }
            }
            return Immutable.normalizeDiseqs(unifier.freeze(), (Set.Immutable<Diseq>)this.disequalities.__insertAll(other.disequalities())).map(ud -> new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), (Immutable)ud));
        }

        @Override
        public Optional<IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(IUniDisunifier.Result::result);
            }
            catch (OccursException e) {
                return Optional.empty();
            }
        }

        @Override
        public boolean equal(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(r -> ((IUnifier.Immutable)r.result()).isEmpty()).orElse(false);
            }
            catch (OccursException e) {
                return false;
            }
        }

        @Override
        public Optional<IUniDisunifier.Result<Optional<Diseq>>> disunify(Iterable<ITermVar> universals, ITerm left, ITerm right, Predicate1<ITermVar> isRigid) throws RigidException {
            IUnifier.Transient diseqs = PersistentUnifier.Immutable.of(this.isFinite()).melt();
            try {
                if (!diseqs.unify(left, right).isPresent()) {
                    return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
                }
            }
            catch (OccursException e) {
                return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
            }
            return this.disunify(universals, diseqs.freeze(), isRigid);
        }

        @Override
        public Optional<IUniDisunifier.Result<Optional<Diseq>>> disunify(Iterable<ITermVar> universals, IUnifier.Immutable diseqs, Predicate1<ITermVar> isRigid) throws RigidException {
            PersistentUnifier.Transient updateableUnifier;
            Diseq diseq = Diseq.of(universals, diseqs);
            if (diseq.isEmpty()) {
                return Optional.empty();
            }
            Function0<FreshVars> fvProvider = Immutable.freshVarProvider(this);
            PersistentUnifier.Transient _unifier = new PersistentUnifier.Transient(this.unifier);
            for (ITermVar var : diseq.freeVarSet()) {
                _unifier.addRangeVar(var, 1);
            }
            PersistentUnifier.Immutable unifier = _unifier.freeze();
            Optional reducedDiseq = Immutable.normalizeDiseq(unifier, fvProvider, diseq, updateableUnifier = new PersistentUnifier.Transient(unifier)).orElse(null);
            if (reducedDiseq == null) {
                return Optional.empty();
            }
            if (reducedDiseq.isPresent()) {
                for (Diseq otherDiseq : this.disequalities) {
                    if (!otherDiseq.implies((Diseq)reducedDiseq.get())) continue;
                    return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
                }
            } else {
                return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
            }
            Set.Immutable rigidVars = (Set.Immutable)((Diseq)reducedDiseq.get()).domainSet().stream().filter(isRigid::test).collect(CapsuleCollectors.toSet());
            if (!rigidVars.isEmpty()) {
                throw new RigidException((Iterable<ITermVar>)rigidVars);
            }
            PersistentUnifier.Immutable newUnifier = updateableUnifier.freeze();
            Set.Immutable newDisequalities = this.disequalities.__insert((Object)((Diseq)reducedDiseq.get()));
            Immutable newUniDisunifier = new Immutable(newUnifier, (Set.Immutable<Diseq>)newDisequalities);
            return Optional.of(new BaseUniDisunifier.ImmutableResult<Optional>(reducedDiseq, newUniDisunifier));
        }

        private static Optional<Immutable> normalizeDiseqs(PersistentUnifier.Immutable unifier, Set.Immutable<Diseq> disequalities) throws RigidException {
            Set.Transient newDisequalities = CapsuleUtil.transientSet();
            Function0<FreshVars> fvProvider = Immutable.freshVarProvider(unifier);
            PersistentUnifier.Transient updateableUnifier = new PersistentUnifier.Transient(unifier);
            for (Diseq diseq : disequalities) {
                Optional normalizedDiseq = Immutable.normalizeDiseq(unifier, fvProvider, diseq, updateableUnifier).orElse(null);
                if (normalizedDiseq == null) {
                    return Optional.empty();
                }
                if (!normalizedDiseq.isPresent()) continue;
                newDisequalities.__insert((Object)((Diseq)normalizedDiseq.get()));
            }
            PersistentUnifier.Immutable newUnifier = updateableUnifier.freeze();
            Set.Immutable _newDisequalities = newDisequalities.freeze();
            Immutable newUniDisunifier = newUnifier.isEmpty() && _newDisequalities.isEmpty() ? Immutable.of(unifier.isFinite()) : new Immutable(newUnifier, (Set.Immutable<Diseq>)_newDisequalities);
            return Optional.of(newUniDisunifier);
        }

        private static Function0<FreshVars> freshVarProvider(IUnifier.Immutable unifier) {
            Ref fv = new Ref();
            Function0<FreshVars> fvProvider = () -> {
                FreshVars result = (FreshVars)fv.get();
                if (result == null) {
                    result = new FreshVars((Iterable<ITermVar>)unifier.varSet());
                    fv.set(result);
                }
                return result;
            };
            return fvProvider;
        }

        private static Optional<Optional<Diseq>> normalizeDiseq(IUnifier.Immutable unifier, Function0<FreshVars> fvProvider, Diseq diseq, PersistentUnifier.Transient updateableUnifier) throws RigidException {
            Optional<? extends IUnifier.Result<? extends IUnifier.Immutable>> unifyResult;
            if (!diseq.universals().isEmpty()) {
                FreshVars fv = fvProvider.apply();
                fv.add((io.usethesource.capsule.Set<ITermVar>)diseq.freeVarSet());
                diseq = diseq.rename(fv.fresh((Set<ITermVar>)diseq.universals()));
                fv.reset();
            }
            for (ITermVar var : diseq.freeVarSet()) {
                updateableUnifier.removeRangeVar(var, 1);
            }
            try {
                unifyResult = unifier.unify(diseq.disequalities());
            }
            catch (OccursException e) {
                return Optional.of(Optional.empty());
            }
            if (!unifyResult.isPresent()) {
                return Optional.of(Optional.empty());
            }
            IUnifier.Immutable diff = unifyResult.get().result();
            Set.Immutable universals = (Set.Immutable)diseq.universals().stream().flatMap(v -> unifier.getVars((ITerm)v).stream()).collect(CapsuleCollectors.toSet());
            Diseq newDiseq = Diseq.of((Iterable<ITermVar>)universals, diff);
            if (newDiseq.isEmpty()) {
                return Optional.empty();
            }
            for (ITermVar var : newDiseq.freeVarSet()) {
                updateableUnifier.addRangeVar(var, 1);
            }
            return Optional.of(Optional.of(newDiseq));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> retain(ITermVar var) {
            return this.retainAll((Iterable)CapsuleUtil.immutableSet(var));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> retainAll(Iterable<ITermVar> vars) {
            return this.removeAll((Iterable)Sets.difference(this.domainSet(), (Set)ImmutableSet.copyOf(vars)));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> remove(ITermVar var) {
            return this.removeAll((Iterable)CapsuleUtil.immutableSet(var));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> removeAll(Iterable<ITermVar> vars) {
            IUnifier.Result r = this.unifier.removeAll((Iterable)vars);
            PersistentUnifier.Transient newUnifier = new PersistentUnifier.Transient(((BaseUnifier.ImmutableResult)r).unifier());
            Set.Transient newDisequalities = CapsuleUtil.transientSet();
            for (Diseq diseq : this.disequalities) {
                for (ITermVar freeVar : diseq.freeVarSet()) {
                    newUnifier.removeRangeVar(freeVar, 1);
                }
                Diseq newDiseq = diseq.apply((ISubstitution.Immutable)((BaseUnifier.ImmutableResult)r).result()).orElse(null);
                if (newDiseq == null || (newDiseq = newDiseq.removeAll(vars)).isEmpty()) continue;
                newDisequalities.__insert((Object)newDiseq);
                for (ITermVar newFreeVar : newDiseq.freeVarSet()) {
                    newUnifier.addRangeVar(newFreeVar, 1);
                }
            }
            Immutable ud = new Immutable(newUnifier.freeze(), (Set.Immutable<Diseq>)newDisequalities.freeze());
            return new BaseUniDisunifier.ImmutableResult<ISubstitution.Immutable>((ISubstitution.Immutable)((BaseUnifier.ImmutableResult)r).result(), ud);
        }

        @Override
        public Immutable rename(IRenaming renaming) {
            if (renaming.isEmpty() || this.isEmpty()) {
                return this;
            }
            PersistentUnifier.Immutable unifier = this.unifier.rename(renaming);
            Set.Immutable disequalities = (Set.Immutable)this.disequalities.stream().map(diseq -> diseq.rename(renaming)).collect(CapsuleCollectors.toSet());
            return new Immutable(unifier, (Set.Immutable<Diseq>)disequalities);
        }

        @Override
        public IUniDisunifier.Transient melt() {
            return new BaseUniDisunifier.Transient(this);
        }

        public static Immutable of() {
            return FINITE_EMPTY;
        }

        public static Immutable of(boolean finite) {
            return finite ? FINITE_EMPTY : INFINITE_EMPTY;
        }
    }
}

