/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.u;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.BaseUnifier;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.tuple.Tuple2;

public abstract class PersistentUnifier
extends BaseUnifier
implements IUnifier,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final Immutable FINITE_EMPTY = new Immutable(true, (Map.Immutable<ITermVar, ITermVar>)Map.Immutable.of(), (Map.Immutable<ITermVar, Integer>)Map.Immutable.of(), (Map.Immutable<ITermVar, ITerm>)Map.Immutable.of(), MultiSet.Immutable.of(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet());
    private static final Immutable INFINITE_EMPTY = new Immutable(false, (Map.Immutable<ITermVar, ITermVar>)Map.Immutable.of(), (Map.Immutable<ITermVar, Integer>)Map.Immutable.of(), (Map.Immutable<ITermVar, ITerm>)Map.Immutable.of(), MultiSet.Immutable.of(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet());

    protected static ITermVar findRep(ITermVar var, Map.Transient<ITermVar, ITermVar> reps, MultiSet.Transient<ITermVar> repAndTermVarsCache) {
        ITermVar rep = (ITermVar)reps.get((Object)var);
        if (rep == null) {
            return var;
        }
        ITermVar rep2 = PersistentUnifier.findRep(rep, reps, repAndTermVarsCache);
        if (!rep2.equals(rep)) {
            reps.__put((Object)var, (Object)rep2);
            repAndTermVarsCache.remove(rep);
            repAndTermVarsCache.add(rep2);
        }
        return rep2;
    }

    public static class Immutable
    extends PersistentUnifier
    implements IUnifier.Immutable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final boolean finite;
        private final Ref<Map.Immutable<ITermVar, ITermVar>> reps;
        private final Map.Immutable<ITermVar, Integer> ranks;
        private final Map.Immutable<ITermVar, ITerm> terms;
        private final Ref<MultiSet.Immutable<ITermVar>> repAndTermVarsCache;
        private final Set.Immutable<ITermVar> domainSetCache;
        private final Set.Immutable<ITermVar> rangeSetCache;
        private final Set.Immutable<ITermVar> varSetCache;

        public Immutable(boolean finite, Map.Immutable<ITermVar, ITermVar> reps, Map.Immutable<ITermVar, Integer> ranks, Map.Immutable<ITermVar, ITerm> terms, MultiSet.Immutable<ITermVar> repAndTermVarsCache, Set.Immutable<ITermVar> domainSetCache, Set.Immutable<ITermVar> rangeSetCache, Set.Immutable<ITermVar> varSetCache) {
            this.finite = finite;
            this.reps = new Ref<Map.Immutable<ITermVar, ITermVar>>(reps);
            this.ranks = ranks;
            this.terms = terms;
            this.repAndTermVarsCache = new Ref<MultiSet.Immutable<ITermVar>>(repAndTermVarsCache);
            this.domainSetCache = domainSetCache;
            this.rangeSetCache = rangeSetCache;
            this.varSetCache = varSetCache;
        }

        @Override
        public boolean isFinite() {
            return this.finite;
        }

        @Override
        protected Map.Immutable<ITermVar, ITermVar> reps() {
            return this.reps.get();
        }

        @Override
        protected Map.Immutable<ITermVar, ITerm> terms() {
            return this.terms;
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            Map.Transient reps = this.reps.get().asTransient();
            MultiSet.Transient<ITermVar> repAndTermVarsCache = this.repAndTermVarsCache.get().melt();
            ITermVar rep = Immutable.findRep(var, (Map.Transient<ITermVar, ITermVar>)reps, repAndTermVarsCache);
            this.reps.set((Map.Immutable<ITermVar, ITermVar>)reps.freeze());
            this.repAndTermVarsCache.set(repAndTermVarsCache.freeze());
            return rep;
        }

        @Override
        public Set.Immutable<ITermVar> domainSet() {
            return this.domainSetCache;
        }

        @Override
        public Set.Immutable<ITermVar> rangeSet() {
            return this.rangeSetCache;
        }

        @Override
        public Set.Immutable<ITermVar> varSet() {
            return this.varSetCache;
        }

        public Optional<BaseUnifier.ImmutableResult<IUnifier.Immutable>> unify(ITerm left, ITerm right, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            return new Unify(this, left, right, isRigid).apply();
        }

        public Optional<BaseUnifier.ImmutableResult<IUnifier.Immutable>> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            return new Unify(this, equalities, isRigid).apply();
        }

        public Optional<BaseUnifier.ImmutableResult<IUnifier.Immutable>> unify(IUnifier other, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            return new Unify(this, other, isRigid).apply();
        }

        public Optional<IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(IUnifier.Result::result);
            }
            catch (OccursException e) {
                return Optional.empty();
            }
        }

        @Override
        public boolean equal(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(r -> ((IUnifier.Immutable)r.result()).isEmpty()).orElse(false);
            }
            catch (OccursException e) {
                return false;
            }
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> retain(ITermVar var) {
            return this.retainAll((Iterable<ITermVar>)CapsuleUtil.immutableSet(var));
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> retainAll(Iterable<ITermVar> vars) {
            return this.removeAll((Iterable)Set.Immutable.subtract(this.domainSet(), CapsuleUtil.toSet(vars)));
        }

        public BaseUnifier.ImmutableResult<ISubstitution.Immutable> remove(ITermVar var) {
            return this.removeAll((Iterable)CapsuleUtil.immutableSet(var));
        }

        public BaseUnifier.ImmutableResult<ISubstitution.Immutable> removeAll(Iterable<ITermVar> vars) {
            return new RemoveAll(this, vars).apply();
        }

        @Override
        public Immutable rename(IRenaming renaming) {
            if (renaming.isEmpty() || this.isEmpty()) {
                return this;
            }
            Map.Transient reps = Map.Transient.of();
            for (Map.Entry e : this.reps.get().entrySet()) {
                reps.__put((Object)renaming.rename((ITermVar)e.getKey()), (Object)renaming.rename((ITermVar)e.getValue()));
            }
            Map.Transient ranks = Map.Transient.of();
            for (Map.Entry e : this.ranks.entrySet()) {
                ranks.__put((Object)renaming.rename((ITermVar)e.getKey()), (Object)((Integer)e.getValue()));
            }
            Map.Transient terms = Map.Transient.of();
            for (Map.Entry e : this.terms.entrySet()) {
                terms.__put((Object)renaming.rename((ITermVar)e.getKey()), (Object)renaming.apply((ITerm)e.getValue()));
            }
            MultiSet.Transient<ITermVar> repAndTermVarsCache = MultiSet.Transient.of();
            for (Map.Entry e : this.repAndTermVarsCache.get().entrySet()) {
                repAndTermVarsCache.add(renaming.rename((ITermVar)e.getKey()), e.getValue());
            }
            Set.Transient domainSetCache = CapsuleUtil.transientSet();
            for (ITermVar var : this.domainSetCache) {
                domainSetCache.__insert((Object)renaming.rename(var));
            }
            Set.Transient rangeSetCache = CapsuleUtil.transientSet();
            for (ITermVar var : this.rangeSetCache) {
                rangeSetCache.__insert((Object)renaming.rename(var));
            }
            Set.Transient varSetCache = CapsuleUtil.transientSet();
            for (ITermVar var : this.varSetCache) {
                varSetCache.__insert((Object)renaming.rename(var));
            }
            return new Immutable(this.finite, (Map.Immutable<ITermVar, ITermVar>)reps.freeze(), (Map.Immutable<ITermVar, Integer>)ranks.freeze(), (Map.Immutable<ITermVar, ITerm>)terms.freeze(), repAndTermVarsCache.freeze(), (Set.Immutable<ITermVar>)domainSetCache.freeze(), (Set.Immutable<ITermVar>)rangeSetCache.freeze(), (Set.Immutable<ITermVar>)varSetCache.freeze());
        }

        @Override
        public IUnifier.Transient melt() {
            return new BaseUnifier.Transient(this);
        }

        public static Immutable of() {
            return FINITE_EMPTY;
        }

        public static Immutable of(boolean finite) {
            return finite ? FINITE_EMPTY : INFINITE_EMPTY;
        }

        public static Immutable of(boolean finite, Map.Immutable<ITermVar, ITermVar> reps, Map.Immutable<ITermVar, Integer> ranks, Map.Immutable<ITermVar, ITerm> terms) {
            if (reps.isEmpty() && ranks.isEmpty() && terms.isEmpty()) {
                return Immutable.of(finite);
            }
            MultiSet.Transient<ITermVar> repAndTermVarsCache = MultiSet.Transient.of();
            Set.Transient domainSetCache = CapsuleUtil.transientSet();
            Set.Transient varSetCache = CapsuleUtil.transientSet();
            for (Map.Entry e : reps.entrySet()) {
                domainSetCache.__insert((Object)((ITermVar)e.getKey()));
                varSetCache.__insert((Object)((ITermVar)e.getKey()));
                repAndTermVarsCache.add((ITermVar)e.getValue());
                varSetCache.__insert((Object)((ITermVar)e.getValue()));
            }
            for (Map.Entry e : terms.entrySet()) {
                domainSetCache.__insert((Object)((ITermVar)e.getKey()));
                varSetCache.__insert((Object)((ITermVar)e.getKey()));
                for (ITermVar tv : ((ITerm)e.getValue()).getVars()) {
                    repAndTermVarsCache.add(tv);
                    varSetCache.__insert((Object)tv);
                }
            }
            Set.Transient rangeSetCache = CapsuleUtil.transientSet();
            for (ITermVar var : repAndTermVarsCache.elementSet()) {
                if (domainSetCache.contains((Object)var)) continue;
                rangeSetCache.__insert((Object)var);
            }
            return new Immutable(finite, reps, ranks, terms, repAndTermVarsCache.freeze(), (Set.Immutable<ITermVar>)domainSetCache.freeze(), (Set.Immutable<ITermVar>)rangeSetCache.freeze(), (Set.Immutable<ITermVar>)varSetCache.freeze());
        }

        private static class RemoveAll
        extends Transient {
            private final Set.Immutable<ITermVar> vars;

            public RemoveAll(Immutable unifier, Iterable<ITermVar> vars) {
                super(unifier);
                this.vars = CapsuleUtil.toSet(vars);
            }

            public BaseUnifier.ImmutableResult<ISubstitution.Immutable> apply() {
                ISubstitution.Immutable subst = this.removeAll();
                Immutable newUnifier = this.freeze();
                return new BaseUnifier.ImmutableResult<ISubstitution.Immutable>(subst, newUnifier);
            }

            private ISubstitution.Immutable removeAll() {
                ITermVar rep;
                ISubstitution.Transient subst = PersistentSubstitution.Transient.of();
                if (this.vars.isEmpty()) {
                    return subst.freeze();
                }
                ListMultimap<ITermVar, ITermVar> invReps = this.getInvReps();
                for (ITermVar var : this.vars) {
                    ITerm term;
                    rep = this.removeRep(var);
                    if (rep != null) {
                        invReps.remove((Object)rep, (Object)var);
                        subst.compose(var, rep);
                        for (ITermVar notRep : invReps.get((Object)var)) {
                            this.putRep(notRep, rep);
                            invReps.put((Object)rep, (Object)notRep);
                        }
                        continue;
                    }
                    List newReps = invReps.removeAll((Object)var);
                    if (!newReps.isEmpty()) {
                        rep = (ITermVar)newReps.stream().max((r1, r2) -> Integer.compare(this.getRank((ITermVar)r1), this.getRank((ITermVar)r2))).get();
                        this.removeRep(rep);
                        invReps.remove((Object)rep, (Object)var);
                        subst.compose(var, rep);
                        for (ITermVar notRep : newReps) {
                            if (notRep.equals(rep)) continue;
                            this.putRep(notRep, rep);
                            invReps.put((Object)rep, (Object)notRep);
                        }
                        term = this.removeTerm(var);
                        if (term == null) continue;
                        this.putTerm(rep, term);
                        continue;
                    }
                    term = this.removeTerm(var);
                    if (term == null) continue;
                    subst.compose(var, term);
                }
                for (Map.Entry<ITermVar, ITerm> entry : this.termEntries()) {
                    rep = entry.getKey();
                    ITerm term = entry.getValue();
                    this.putTerm(rep, subst.apply(term));
                }
                return subst.freeze();
            }
        }

        private static class Unify
        extends Transient {
            private final Predicate1<ITermVar> isRigid;
            private final Deque<Map.Entry<ITerm, ITerm>> worklist = new ArrayDeque<Map.Entry<ITerm, ITerm>>();
            private final List<ITermVar> result = Lists.newArrayList();

            public Unify(Immutable unifier, ITerm left, ITerm right, Predicate1<ITermVar> isRigid) {
                super(unifier);
                this.isRigid = isRigid;
                this.worklist.push(Tuple2.of(left, right));
            }

            public Unify(Immutable unifier, Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities, Predicate1<ITermVar> isRigid) {
                super(unifier);
                this.isRigid = isRigid;
                for (Map.Entry<? extends ITerm, ? extends ITerm> entry : equalities) {
                    this.worklist.push(Tuple2.of(entry));
                }
            }

            public Unify(Immutable unifier, IUnifier other, Predicate1<ITermVar> isRigid) {
                super(unifier);
                this.isRigid = isRigid;
                for (ITermVar v : other.domainSet()) {
                    this.worklist.push(Tuple2.of(v, other.findTerm(v)));
                }
            }

            public Optional<BaseUnifier.ImmutableResult<IUnifier.Immutable>> apply() throws OccursException, RigidException {
                while (!this.worklist.isEmpty()) {
                    Map.Entry<ITerm, ITerm> work = this.worklist.pop();
                    if (this.unifyTerms(work.getKey(), work.getValue())) continue;
                    return Optional.empty();
                }
                Immutable unifier = this.freeze();
                if (this.finite) {
                    this.occursCheck(unifier);
                }
                IUnifier.Immutable diffUnifier = this.diffUnifier(this.result);
                return Optional.of(new BaseUnifier.ImmutableResult<IUnifier.Immutable>(diffUnifier, unifier));
            }

            private void occursCheck(Immutable unifier) throws OccursException {
                ImmutableSet.Builder _cyclicVars = ImmutableSet.builderWithExpectedSize((int)0);
                for (ITermVar var : this.result) {
                    if (!unifier.isCyclic(var)) continue;
                    _cyclicVars.add((Object)var);
                }
                ImmutableSet cyclicVars = _cyclicVars.build();
                if (!cyclicVars.isEmpty()) {
                    throw new OccursException((Iterable<ITermVar>)cyclicVars);
                }
            }

            private boolean unifyTerms(ITerm left, ITerm right) throws RigidException {
                return left.matchOrThrow(Terms.checkedCases(applLeft -> right.matchOrThrow(Terms.checkedCases().appl(applRight -> {
                    if (applLeft.getArity() == applRight.getArity() && applLeft.getOp().equals(applRight.getOp()) && this.unifys(applLeft.getArgs(), applRight.getArgs())) {
                        return true;
                    }
                    return false;
                }).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)applLeft)).otherwise(t -> false)), listLeft -> right.matchOrThrow(Terms.checkedCases().list(listRight -> this.unifyLists((IListTerm)listLeft, (IListTerm)listRight)).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)listLeft)).otherwise(t -> false)), stringLeft -> right.matchOrThrow(Terms.checkedCases().string(stringRight -> stringLeft.getValue().equals(stringRight.getValue())).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)stringLeft)).otherwise(t -> false)), integerLeft -> right.matchOrThrow(Terms.checkedCases().integer(integerRight -> {
                    if (integerLeft.getValue() == integerRight.getValue()) {
                        return true;
                    }
                    return false;
                }).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)integerLeft)).otherwise(t -> false)), blobLeft -> right.matchOrThrow(Terms.checkedCases().blob(blobRight -> blobLeft.getValue().equals(blobRight.getValue())).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)blobLeft)).otherwise(t -> false)), varLeft -> right.matchOrThrow(Terms.checkedCases().var(varRight -> this.unifyVars((ITermVar)varLeft, (ITermVar)varRight)).otherwise(termRight -> this.unifyVarTerm((ITermVar)varLeft, (ITerm)termRight)))));
            }

            private boolean unifyLists(IListTerm left, IListTerm right) throws RigidException {
                return left.matchOrThrow(ListTerms.checkedCases(consLeft -> right.matchOrThrow(ListTerms.checkedCases().cons(consRight -> {
                    this.worklist.push(Tuple2.of(consLeft.getHead(), consRight.getHead()));
                    this.worklist.push(Tuple2.of(consLeft.getTail(), consRight.getTail()));
                    return true;
                }).var(varRight -> this.unifyLists((IListTerm)varRight, (IListTerm)consLeft)).otherwise(l -> false)), nilLeft -> right.matchOrThrow(ListTerms.checkedCases().nil(nilRight -> true).var(varRight -> this.unifyVarTerm((ITermVar)varRight, (ITerm)nilLeft)).otherwise(l -> false)), varLeft -> right.matchOrThrow(ListTerms.checkedCases().var(varRight -> this.unifyVars((ITermVar)varLeft, (ITermVar)varRight)).otherwise(termRight -> this.unifyVarTerm((ITermVar)varLeft, (ITerm)termRight)))));
            }

            private boolean unifyVarTerm(ITermVar var, ITerm term) throws RigidException {
                ITermVar rep = this.findRep(var);
                if (term instanceof ITermVar) {
                    throw new IllegalStateException();
                }
                ITerm repTerm = this.getTerm(rep);
                if (repTerm != null) {
                    this.worklist.push(Tuple2.of(repTerm, term));
                } else {
                    if (this.isRigid.test(rep)) {
                        throw new RigidException(rep);
                    }
                    this.putTerm(rep, term);
                    this.result.add(rep);
                }
                return true;
            }

            private boolean unifyVars(ITermVar left, ITermVar right) throws RigidException {
                ITermVar rep;
                ITermVar var;
                ITermVar rightRep;
                ITermVar leftRep = this.findRep(left);
                if (leftRep.equals(rightRep = this.findRep(right))) {
                    return true;
                }
                boolean leftRigid = this.isRigid.test(leftRep);
                boolean rightRigid = this.isRigid.test(rightRep);
                ITerm leftTerm = this.getTerm(leftRep);
                ITerm rightTerm = this.getTerm(rightRep);
                int leftRank = Optional.ofNullable((Integer)this.ranks.__remove((Object)leftRep)).orElse(1);
                int rightRank = Optional.ofNullable((Integer)this.ranks.__remove((Object)rightRep)).orElse(1);
                if (leftRigid && rightRigid && leftTerm == null && rightTerm == null) {
                    throw new RigidException(leftRep, rightRep);
                }
                if (leftRigid && rightRigid && leftTerm == null) {
                    throw new RigidException(leftRep);
                }
                if (leftRigid && rightRigid && rightTerm == null) {
                    throw new RigidException(rightRep);
                }
                if (leftRigid && leftTerm == null) {
                    var = rightRep;
                    rep = leftRep;
                } else if (rightRigid && rightTerm == null) {
                    var = leftRep;
                    rep = rightRep;
                } else {
                    boolean swap = leftRank > rightRank;
                    var = swap ? rightRep : leftRep;
                    rep = swap ? leftRep : rightRep;
                }
                this.ranks.__put((Object)rep, (Object)(leftRank + rightRank));
                ITerm varTerm = this.removeTerm(var);
                this.putRep(var, rep);
                if (varTerm != null) {
                    ITerm repTerm = this.getTerm(rep);
                    if (repTerm != null) {
                        this.worklist.push(Tuple2.of(varTerm, repTerm));
                    } else {
                        this.putTerm(rep, varTerm);
                        this.result.add(rep);
                    }
                } else {
                    this.result.add(var);
                }
                return true;
            }

            private boolean unifys(Iterable<ITerm> lefts, Iterable<ITerm> rights) {
                Iterator<ITerm> itLeft = lefts.iterator();
                Iterator<ITerm> itRight = rights.iterator();
                while (itLeft.hasNext()) {
                    if (!itRight.hasNext()) {
                        return false;
                    }
                    this.worklist.push(Tuple2.of(itLeft.next(), itRight.next()));
                }
                return !itRight.hasNext();
            }

            private IUnifier.Immutable diffUnifier(Collection<ITermVar> vars) {
                Transient diff = new Transient(this.finite);
                for (ITermVar var : vars) {
                    ITermVar rep = this.getRep(var);
                    if (rep != null) {
                        diff.putRep(var, rep);
                        continue;
                    }
                    ITerm term = this.getTerm(var);
                    if (term == null) continue;
                    diff.putTerm(var, term);
                }
                return diff.freeze();
            }
        }
    }

    public static class Transient {
        protected final boolean finite;
        private final Map.Transient<ITermVar, ITermVar> reps;
        protected final Map.Transient<ITermVar, Integer> ranks;
        private final Map.Transient<ITermVar, ITerm> terms;
        private final MultiSet.Transient<ITermVar> repAndTermVarsCache;
        private final Set.Transient<ITermVar> domainSetCache;
        private final Set.Transient<ITermVar> rangeSetCache;
        private final Set.Transient<ITermVar> varSetCache;

        Transient(boolean finite) {
            this(finite, (Map.Transient<ITermVar, ITermVar>)Map.Transient.of(), (Map.Transient<ITermVar, Integer>)Map.Transient.of(), (Map.Transient<ITermVar, ITerm>)Map.Transient.of(), MultiSet.Transient.of(), CapsuleUtil.transientSet(), CapsuleUtil.transientSet(), CapsuleUtil.transientSet());
        }

        public Transient(Immutable unifier) {
            this(unifier.finite, (Map.Transient<ITermVar, ITermVar>)((Map.Immutable)unifier.reps.get()).asTransient(), (Map.Transient<ITermVar, Integer>)unifier.ranks.asTransient(), (Map.Transient<ITermVar, ITerm>)unifier.terms.asTransient(), ((MultiSet.Immutable)unifier.repAndTermVarsCache.get()).melt(), (Set.Transient<ITermVar>)unifier.domainSetCache.asTransient(), (Set.Transient<ITermVar>)unifier.rangeSetCache.asTransient(), (Set.Transient<ITermVar>)unifier.varSetCache.asTransient());
        }

        Transient(boolean finite, Map.Transient<ITermVar, ITermVar> reps, Map.Transient<ITermVar, Integer> ranks, Map.Transient<ITermVar, ITerm> terms, MultiSet.Transient<ITermVar> repAndTermVarsCache, Set.Transient<ITermVar> domainSetCache, Set.Transient<ITermVar> rangeSetCache, Set.Transient<ITermVar> varSetCache) {
            this.finite = finite;
            this.reps = reps;
            this.ranks = ranks;
            this.terms = terms;
            this.repAndTermVarsCache = repAndTermVarsCache;
            this.domainSetCache = domainSetCache;
            this.rangeSetCache = rangeSetCache;
            this.varSetCache = varSetCache;
        }

        protected Iterable<Map.Entry<ITermVar, ITermVar>> repEntries() {
            return this.reps.entrySet();
        }

        protected Iterable<Map.Entry<ITermVar, ITerm>> termEntries() {
            return this.terms.entrySet();
        }

        protected ITermVar findRep(ITermVar var) {
            return PersistentUnifier.findRep(var, this.reps, this.repAndTermVarsCache);
        }

        protected ITermVar getRep(ITermVar var) {
            return (ITermVar)this.reps.get((Object)var);
        }

        protected ListMultimap<ITermVar, ITermVar> getInvReps() {
            LinkedListMultimap invReps = LinkedListMultimap.create();
            for (Map.Entry e : this.reps.entrySet()) {
                invReps.put((Object)((ITermVar)e.getValue()), (Object)((ITermVar)e.getKey()));
            }
            return invReps;
        }

        protected void putRep(ITermVar var, ITermVar rep) {
            if (this.terms.containsKey((Object)var)) {
                throw new IllegalStateException();
            }
            ITermVar oldRep = (ITermVar)this.reps.__put((Object)var, (Object)rep);
            if (oldRep == null) {
                this.addDomainVar(var);
            } else {
                this.removeRangeVar(oldRep, 1);
            }
            this.addRangeVar(rep, 1);
        }

        protected ITermVar removeRep(ITermVar var) {
            ITermVar rep = (ITermVar)this.reps.__remove((Object)var);
            if (rep != null) {
                this.removeDomainVar(var);
                this.removeRangeVar(rep, 1);
            }
            return rep;
        }

        protected ITerm getTerm(ITermVar rep) {
            return (ITerm)this.terms.get((Object)rep);
        }

        protected void putTerm(ITermVar rep, ITerm term) {
            if (this.reps.containsKey((Object)rep)) {
                throw new IllegalStateException();
            }
            ITerm oldTerm = (ITerm)this.terms.__put((Object)rep, (Object)term);
            if (oldTerm == null) {
                this.addDomainVar(rep);
            } else {
                for (ITermVar var : oldTerm.getVars()) {
                    this.removeRangeVar(var, 1);
                }
            }
            for (ITermVar var : term.getVars()) {
                this.addRangeVar(var, 1);
            }
        }

        protected ITerm removeTerm(ITermVar rep) {
            ITerm term = (ITerm)this.terms.__remove((Object)rep);
            if (term != null) {
                this.removeDomainVar(rep);
                for (ITermVar var : term.getVars()) {
                    this.removeRangeVar(var, 1);
                }
            }
            return term;
        }

        private void addDomainVar(ITermVar var) {
            if (this.domainSetCache.contains((Object)var)) {
                throw new IllegalStateException();
            }
            this.domainSetCache.__insert((Object)var);
            if (this.repAndTermVarsCache.count(var) > 0) {
                this.rangeSetCache.__remove((Object)var);
            } else {
                this.varSetCache.__insert((Object)var);
            }
        }

        private void removeDomainVar(ITermVar var) {
            if (!this.domainSetCache.contains((Object)var)) {
                throw new IllegalStateException();
            }
            this.domainSetCache.__remove((Object)var);
            if (this.repAndTermVarsCache.count(var) > 0) {
                this.rangeSetCache.__insert((Object)var);
            } else {
                this.varSetCache.__remove((Object)var);
            }
        }

        public void addRangeVar(ITermVar var, int k) {
            if (k <= 0) {
                throw new IllegalStateException();
            }
            int n = this.repAndTermVarsCache.add(var, k);
            if (n == 0 && !this.domainSetCache.contains((Object)var)) {
                this.rangeSetCache.__insert((Object)var);
                this.varSetCache.__insert((Object)var);
            }
        }

        public void removeRangeVar(ITermVar var, int k) {
            if (k <= 0) {
                throw new IllegalStateException();
            }
            int n = this.repAndTermVarsCache.remove(var, k);
            if (n < k) {
                throw new IllegalStateException();
            }
            if (n == k && !this.domainSetCache.contains((Object)var)) {
                this.rangeSetCache.__remove((Object)var);
                this.varSetCache.__remove((Object)var);
            }
        }

        protected int getRank(ITermVar var) {
            return (Integer)this.ranks.getOrDefault((Object)var, (Object)1);
        }

        public Immutable freeze() {
            if (this.reps.isEmpty() && this.ranks.isEmpty() && this.terms.isEmpty() && this.repAndTermVarsCache.isEmpty() && this.domainSetCache.isEmpty() && this.rangeSetCache.isEmpty() && this.varSetCache.isEmpty()) {
                return Immutable.of(this.finite);
            }
            Immutable unifier = new Immutable(this.finite, (Map.Immutable<ITermVar, ITermVar>)this.reps.freeze(), (Map.Immutable<ITermVar, Integer>)this.ranks.freeze(), (Map.Immutable<ITermVar, ITerm>)this.terms.freeze(), this.repAndTermVarsCache.freeze(), (Set.Immutable<ITermVar>)this.domainSetCache.freeze(), (Set.Immutable<ITermVar>)this.rangeSetCache.freeze(), (Set.Immutable<ITermVar>)this.varSetCache.freeze());
            return unifier;
        }
    }
}

