/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.u;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.SpecializedTermFormatter;
import mb.nabl2.terms.unification.TermSize;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.PartialFunction1;
import org.metaborg.util.functions.Predicate1;

public abstract class BaseUnifier
implements IUnifier,
Serializable {
    private static final long serialVersionUID = 42L;

    protected abstract Map.Immutable<ITermVar, ITermVar> reps();

    protected abstract Map.Immutable<ITermVar, ITerm> terms();

    @Override
    public boolean isEmpty() {
        return this.reps().isEmpty() && this.terms().isEmpty();
    }

    @Override
    public boolean contains(ITermVar var) {
        return this.reps().containsKey((Object)var) || this.terms().containsKey((Object)var);
    }

    @Override
    public boolean isCyclic() {
        return this.isCyclic((Set<ITermVar>)this.domainSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (ITermVar var : this.terms().keySet()) {
            sb.append(first ? " " : ", ");
            first = false;
            sb.append(var);
            sb.append(" == ");
            sb.append(this.terms().get((Object)var));
        }
        for (ITermVar var : this.reps().keySet()) {
            sb.append(first ? " " : ", ");
            first = false;
            sb.append(var);
            sb.append(" == ");
            sb.append(this.reps().get((Object)var));
        }
        sb.append(first ? "}" : " }");
        return sb.toString();
    }

    @Override
    public boolean hasTerm(ITermVar var) {
        return this.terms().containsKey((Object)this.findRep(var));
    }

    @Override
    public ITerm findTerm(ITerm term) {
        return term.match(Terms.cases().var(var -> {
            ITermVar rep = this.findRep((ITermVar)var);
            return (ITerm)this.terms().getOrDefault((Object)rep, (Object)rep);
        }).otherwise(t -> t));
    }

    @Override
    public ITerm findRecursive(ITerm term) {
        return this.findTermRecursive(term, Sets.newHashSet(), Maps.newHashMap());
    }

    private ITerm findTermRecursive(ITerm term, Set<ITermVar> stack, Map<ITermVar, ITerm> visited) {
        return term.match(Terms.cases(appl -> TermBuild.B.newAppl(appl.getOp(), this.findRecursiveTerms(appl.getArgs(), stack, visited), appl.getAttachments()), list2 -> this.findListTermRecursive((IListTerm)list2, stack, visited), string -> string, integer -> integer, blob -> blob, var -> this.findVarRecursive((ITermVar)var, stack, visited)));
    }

    private IListTerm findListTermRecursive(IListTerm list2, Set<ITermVar> stack, Map<ITermVar, ITerm> visited) {
        ArrayDeque elements = new ArrayDeque();
        while (list2 != null) {
            list2 = list2.match(ListTerms.cases(cons -> {
                elements.push(cons);
                return cons.getTail();
            }, nil -> {
                elements.push(nil);
                return null;
            }, var -> {
                elements.push(var);
                return null;
            }));
        }
        Ref<IListTerm> instance = new Ref<IListTerm>();
        while (!elements.isEmpty()) {
            instance.set(((IListTerm)elements.pop()).match(ListTerms.cases(cons -> TermBuild.B.newCons(this.findTermRecursive(cons.getHead(), stack, visited), (IListTerm)instance.get(), cons.getAttachments()), nil -> nil, var -> (IListTerm)this.findVarRecursive((ITermVar)var, stack, visited))));
        }
        return (IListTerm)instance.get();
    }

    private ITerm findVarRecursive(ITermVar var, Set<ITermVar> stack, Map<ITermVar, ITerm> visited) {
        ITermVar rep = this.findRep(var);
        if (!visited.containsKey(rep)) {
            stack.add(rep);
            visited.put(rep, null);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            ITermVar instance = term != null ? this.findTermRecursive(term, stack, visited) : rep;
            visited.put(rep, instance);
            stack.remove(rep);
            return instance;
        }
        if (stack.contains(rep)) {
            throw new IllegalArgumentException("Recursive terms cannot be fully instantiated.");
        }
        ITerm instance = visited.get(rep);
        return instance;
    }

    private Iterable<ITerm> findRecursiveTerms(Iterable<ITerm> terms, Set<ITermVar> stack, Map<ITermVar, ITerm> visited) {
        ArrayList instances = Lists.newArrayList();
        for (ITerm term : terms) {
            instances.add(this.findTermRecursive(term, stack, visited));
        }
        return instances;
    }

    @Override
    public boolean isCyclic(ITerm term) {
        return this.isCyclic((Set<ITermVar>)term.getVars(), (Set<ITermVar>)Sets.newHashSet(), (Map<ITermVar, Boolean>)Maps.newHashMap());
    }

    protected boolean isCyclic(Set<ITermVar> vars) {
        return this.isCyclic(vars, (Set<ITermVar>)Sets.newHashSet(), (Map<ITermVar, Boolean>)Maps.newHashMap());
    }

    private boolean isCyclic(Set<ITermVar> vars, Set<ITermVar> stack, Map<ITermVar, Boolean> visited) {
        for (ITermVar var : vars) {
            if (!this.isCyclic(var, stack, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean isCyclic(ITermVar var, Set<ITermVar> stack, Map<ITermVar, Boolean> visited) {
        boolean cyclic;
        ITermVar rep = this.findRep(var);
        if (!visited.containsKey(rep)) {
            stack.add(rep);
            visited.put(rep, null);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            cyclic = term != null ? this.isCyclic((Set<ITermVar>)term.getVars(), stack, visited) : false;
            visited.put(rep, cyclic);
            stack.remove(rep);
        } else {
            cyclic = stack.contains(rep) ? true : visited.get(rep);
        }
        return cyclic;
    }

    @Override
    public boolean isGround(ITerm term) {
        return this.isGround((Set<ITermVar>)term.getVars(), (Set<ITermVar>)Sets.newHashSet(), (Map<ITermVar, Boolean>)Maps.newHashMap());
    }

    private boolean isGround(Set<ITermVar> vars, Set<ITermVar> stack, Map<ITermVar, Boolean> visited) {
        return vars.stream().allMatch(var -> this.isGround((ITermVar)var, stack, visited));
    }

    private boolean isGround(ITermVar var, Set<ITermVar> stack, Map<ITermVar, Boolean> visited) {
        boolean ground;
        ITermVar rep = this.findRep(var);
        if (!visited.containsKey(rep)) {
            stack.add(rep);
            visited.put(rep, null);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            ground = term != null ? this.isGround((Set<ITermVar>)term.getVars(), stack, visited) : false;
            visited.put(rep, ground);
            stack.remove(rep);
        } else {
            ground = stack.contains(rep) ? true : visited.get(rep);
        }
        return ground;
    }

    @Override
    public Set.Immutable<ITermVar> getVars(ITerm term) {
        Set.Transient vars = CapsuleUtil.transientSet();
        this.getVars((Set<ITermVar>)term.getVars(), (LinkedList<ITermVar>)Lists.newLinkedList(), (Set<ITermVar>)Sets.newHashSet(), (Set.Transient<ITermVar>)vars);
        return vars.freeze();
    }

    private void getVars(Set<ITermVar> tryVars, LinkedList<ITermVar> stack, Set<ITermVar> visited, Set.Transient<ITermVar> vars) {
        for (ITermVar var : tryVars) {
            this.getVars(var, stack, visited, vars);
        }
    }

    private void getVars(ITermVar var, LinkedList<ITermVar> stack, Set<ITermVar> visited, Set.Transient<ITermVar> vars) {
        ITermVar rep = this.findRep(var);
        if (!visited.contains(rep)) {
            visited.add(rep);
            stack.push(rep);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            if (term != null) {
                this.getVars((Set<ITermVar>)term.getVars(), stack, visited, vars);
            } else {
                vars.__insert((Object)rep);
            }
            stack.pop();
        } else {
            int index = stack.indexOf(rep);
            if (index >= 0) {
                for (ITermVar v : stack.subList(0, index + 1)) {
                    vars.__insert((Object)v);
                }
            }
        }
    }

    @Override
    public TermSize size(ITerm term) {
        return this.size(term, (Set<ITermVar>)Sets.newHashSet(), (Map<ITermVar, TermSize>)Maps.newHashMap());
    }

    private TermSize size(ITerm term, Set<ITermVar> stack, Map<ITermVar, TermSize> visited) {
        return term.match(Terms.cases(appl -> TermSize.ONE.add(this.sizes(appl.getArgs(), stack, visited)), list2 -> this.size((IListTerm)list2, stack, visited), string -> TermSize.ONE, integer -> TermSize.ONE, blob -> TermSize.ONE, var -> this.size((ITermVar)var, stack, visited)));
    }

    private TermSize size(IListTerm list2, Set<ITermVar> stack, Map<ITermVar, TermSize> visited) {
        Ref<TermSize> size = new Ref<TermSize>(TermSize.ZERO);
        while (list2 != null) {
            list2 = list2.match(ListTerms.cases(cons -> {
                size.set(((TermSize)size.get()).add(TermSize.ONE).add(this.size(cons.getHead(), stack, visited)));
                return cons.getTail();
            }, nil -> {
                size.set(((TermSize)size.get()).add(TermSize.ONE));
                return null;
            }, var -> {
                size.set(((TermSize)size.get()).add(this.size((ITermVar)var, stack, visited)));
                return null;
            }));
        }
        return size.get();
    }

    private TermSize size(ITermVar var, Set<ITermVar> stack, Map<ITermVar, TermSize> visited) {
        ITermVar rep = this.findRep(var);
        if (!visited.containsKey(rep)) {
            stack.add(rep);
            visited.put(rep, null);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            TermSize size = term != null ? this.size(term, stack, visited) : TermSize.ZERO;
            visited.put(rep, size);
            stack.remove(rep);
            return size;
        }
        TermSize size = stack.contains(rep) ? TermSize.INF : visited.get(rep);
        return size;
    }

    private TermSize sizes(Iterable<ITerm> terms, Set<ITermVar> stack, Map<ITermVar, TermSize> visited) {
        TermSize size = TermSize.ZERO;
        for (ITerm term : terms) {
            size = size.add(this.size(term, stack, visited));
        }
        return size;
    }

    @Override
    public String toString(ITerm term, SpecializedTermFormatter specializedTermFormatter) {
        return this.toString(term, (Map<ITermVar, String>)Maps.newHashMap(), (Map<ITermVar, String>)Maps.newHashMap(), -1, specializedTermFormatter);
    }

    @Override
    public String toString(ITerm term, int depth, SpecializedTermFormatter specializedTermFormatter) {
        return this.toString(term, (Map<ITermVar, String>)Maps.newHashMap(), (Map<ITermVar, String>)Maps.newHashMap(), depth, specializedTermFormatter);
    }

    private String toString(ITerm term, Map<ITermVar, String> stack, Map<ITermVar, String> visited, int maxDepth, SpecializedTermFormatter specializedTermFormatter) {
        if (maxDepth == 0) {
            return "\u2026";
        }
        PartialFunction1 tf = t -> specializedTermFormatter.formatSpecialized(term, this, st2 -> this.toString(st2, stack, visited, maxDepth - 1, specializedTermFormatter));
        return term.match(Terms.cases(appl -> ((Optional)tf.apply(appl)).orElseGet(() -> String.valueOf(appl.getOp()) + "(" + this.toStrings(appl.getArgs(), stack, visited, maxDepth - 1, specializedTermFormatter) + ")"), list2 -> ((Optional)tf.apply(list2)).orElseGet(() -> this.toString((IListTerm)list2, stack, visited, maxDepth, specializedTermFormatter)), string -> ((Optional)tf.apply(string)).orElseGet(() -> string.toString()), integer -> ((Optional)tf.apply(integer)).orElseGet(() -> integer.toString()), blob -> ((Optional)tf.apply(blob)).orElseGet(() -> blob.toString()), var -> this.toString((ITermVar)var, stack, visited, maxDepth, specializedTermFormatter)));
    }

    private String toString(IListTerm list2, Map<ITermVar, String> stack, Map<ITermVar, String> visited, int maxDepth, SpecializedTermFormatter specializedTermFormatter) {
        if (maxDepth == 0) {
            return "\u2026";
        }
        StringBuilder sb = new StringBuilder();
        AtomicBoolean tail = new AtomicBoolean();
        int remaining = maxDepth;
        sb.append("[");
        while (list2 != null) {
            if (remaining == 0) {
                if (!list2.match(ListTerms.cases().nil(nil -> false).otherwise(l -> true)).booleanValue()) break;
                sb.append("|\u2026");
                break;
            }
            list2 = list2.match(ListTerms.cases(cons -> {
                if (tail.getAndSet(true)) {
                    sb.append(",");
                }
                sb.append(this.toString(cons.getHead(), stack, visited, maxDepth - 1, specializedTermFormatter));
                return cons.getTail();
            }, nil -> null, var -> {
                sb.append("|");
                sb.append(this.toString((ITermVar)var, stack, visited, maxDepth - 1, specializedTermFormatter));
                return null;
            }));
            --remaining;
        }
        sb.append("]");
        return sb.toString();
    }

    private String toString(ITermVar var, Map<ITermVar, String> stack, Map<ITermVar, String> visited, int maxDepth, SpecializedTermFormatter specializedTermFormatter) {
        String toString;
        if (maxDepth == 0) {
            return "\u2026";
        }
        ITermVar rep = this.findRep(var);
        if (!visited.containsKey(rep)) {
            String toString2;
            stack.put(rep, null);
            visited.put(rep, null);
            ITerm term = (ITerm)this.terms().get((Object)rep);
            if (term != null) {
                String termString = this.toString(term, stack, visited, maxDepth, specializedTermFormatter);
                toString2 = String.valueOf(stack.get(rep) != null ? "\u03bc" + stack.get(rep) + "." : "") + termString;
            } else {
                toString2 = rep.toString();
            }
            visited.put(rep, toString2);
            stack.remove(rep);
            return toString2;
        }
        if (stack.containsKey(rep)) {
            String muVar;
            if (stack.get(rep) == null) {
                muVar = "X" + stack.values().stream().filter(v -> v != null).count();
                stack.put(rep, muVar);
            } else {
                muVar = stack.get(rep);
            }
            toString = muVar;
        } else {
            toString = visited.get(rep);
        }
        return toString;
    }

    private String toStrings(Iterable<ITerm> terms, Map<ITermVar, String> stack, Map<ITermVar, String> visited, int maxDepth, SpecializedTermFormatter specializedTermFormatter) {
        StringBuilder sb = new StringBuilder();
        AtomicBoolean tail = new AtomicBoolean();
        for (ITerm term : terms) {
            if (tail.getAndSet(true)) {
                sb.append(",");
            }
            sb.append(this.toString(term, stack, visited, maxDepth, specializedTermFormatter));
        }
        return sb.toString();
    }

    public static class ImmutableResult<T>
    implements IUnifier.Result<T> {
        private final T result;
        private final PersistentUnifier.Immutable unifier;

        public ImmutableResult(T result, PersistentUnifier.Immutable unifier) {
            this.result = result;
            this.unifier = unifier;
        }

        @Override
        public T result() {
            return this.result;
        }

        @Override
        public PersistentUnifier.Immutable unifier() {
            return this.unifier;
        }
    }

    protected static class Transient
    implements IUnifier.Transient {
        private IUnifier.Immutable unifier;

        public Transient(IUnifier.Immutable unifier) {
            this.unifier = unifier;
        }

        @Override
        public boolean isFinite() {
            return this.unifier.isFinite();
        }

        @Override
        public boolean isEmpty() {
            return this.unifier.isEmpty();
        }

        @Override
        public boolean contains(ITermVar var) {
            return this.unifier.contains(var);
        }

        @Override
        public Set.Immutable<ITermVar> domainSet() {
            return this.unifier.domainSet();
        }

        @Override
        public Set.Immutable<ITermVar> rangeSet() {
            return this.unifier.rangeSet();
        }

        @Override
        public Set.Immutable<ITermVar> varSet() {
            return this.unifier.varSet();
        }

        @Override
        public boolean isCyclic() {
            return this.unifier.isCyclic();
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            return this.unifier.findRep(var);
        }

        @Override
        public boolean hasTerm(ITermVar var) {
            return this.unifier.hasTerm(var);
        }

        @Override
        public ITerm findTerm(ITerm term) {
            return this.unifier.findTerm(term);
        }

        @Override
        public ITerm findRecursive(ITerm term) {
            return this.unifier.findRecursive(term);
        }

        @Override
        public boolean isGround(ITerm term) {
            return this.unifier.isGround(term);
        }

        @Override
        public boolean isCyclic(ITerm term) {
            return this.unifier.isCyclic(term);
        }

        @Override
        public Set.Immutable<ITermVar> getVars(ITerm term) {
            return this.unifier.getVars(term);
        }

        @Override
        public TermSize size(ITerm term) {
            return this.unifier.size(term);
        }

        @Override
        public String toString(ITerm term, SpecializedTermFormatter specializedTermFormatter) {
            return this.unifier.toString(term, specializedTermFormatter);
        }

        @Override
        public String toString(ITerm term, int depth, SpecializedTermFormatter specializedTermFormatter) {
            return this.unifier.toString(term, depth, specializedTermFormatter);
        }

        @Override
        public Optional<? extends IUnifier.Immutable> unify(ITerm term1, ITerm term2, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            Optional<? extends IUnifier.Result<? extends IUnifier.Immutable>> result = this.unifier.unify(term1, term2, isRigid);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<? extends IUnifier.Immutable> unify(IUnifier other, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            Optional<? extends IUnifier.Result<? extends IUnifier.Immutable>> result = this.unifier.unify(other, isRigid);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<? extends IUnifier.Immutable> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities, Predicate1<ITermVar> isRigid) throws OccursException, RigidException {
            Optional<? extends IUnifier.Result<? extends IUnifier.Immutable>> result = this.unifier.unify(equalities, isRigid);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<? extends IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            return this.unifier.diff(term1, term2);
        }

        @Override
        public boolean equal(ITerm term1, ITerm term2) {
            return this.unifier.equal(term1, term2);
        }

        @Override
        public ISubstitution.Immutable retain(ITermVar var) {
            IUnifier.Result<ISubstitution.Immutable> result = this.unifier.retain(var);
            this.unifier = result.unifier();
            return result.result();
        }

        @Override
        public ISubstitution.Immutable retainAll(Iterable<ITermVar> vars) {
            IUnifier.Result<ISubstitution.Immutable> result = this.unifier.retainAll(vars);
            this.unifier = result.unifier();
            return result.result();
        }

        @Override
        public ISubstitution.Immutable remove(ITermVar var) {
            IUnifier.Result<ISubstitution.Immutable> result = this.unifier.remove(var);
            this.unifier = result.unifier();
            return result.result();
        }

        @Override
        public ISubstitution.Immutable removeAll(Iterable<ITermVar> vars) {
            IUnifier.Result<ISubstitution.Immutable> result = this.unifier.removeAll(vars);
            this.unifier = result.unifier();
            return result.result();
        }

        @Override
        public IUnifier.Immutable freeze() {
            return this.unifier;
        }

        public String toString() {
            return this.unifier.toString();
        }
    }
}

