/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;

public class Renaming
implements IRenaming {
    private final BiMap<ITermVar, ITermVar> renaming;

    private Renaming(BiMap<ITermVar, ITermVar> renaming) {
        this.renaming = renaming;
    }

    @Override
    public boolean isEmpty() {
        return this.renaming.isEmpty();
    }

    @Override
    public Set<ITermVar> keySet() {
        return this.renaming.keySet();
    }

    @Override
    public Set<ITermVar> valueSet() {
        return this.renaming.values();
    }

    @Override
    public Set<? extends Map.Entry<ITermVar, ITermVar>> entrySet() {
        return this.renaming.entrySet();
    }

    @Override
    public ITermVar rename(ITermVar var) {
        return (ITermVar)this.renaming.getOrDefault((Object)var, (Object)var);
    }

    @Override
    public ITerm apply(ITerm term) {
        return term.match(Terms.cases(appl -> {
            ImmutableList<ITerm> newArgs = Terms.applyLazy(appl.getArgs(), this::apply);
            if (newArgs == null) {
                return appl;
            }
            return TermBuild.B.newAppl(appl.getOp(), (Iterable<? extends ITerm>)newArgs, appl.getAttachments());
        }, list2 -> this.apply((IListTerm)list2), string -> string, integer -> integer, blob -> blob, var -> this.rename((ITermVar)var)));
    }

    private IListTerm apply(IListTerm list2) {
        return list2.match(ListTerms.cases(cons -> TermBuild.B.newCons(this.apply(cons.getHead()), this.apply(cons.getTail()), cons.getAttachments()), nil -> nil, var -> this.rename((ITermVar)var)));
    }

    @Override
    public Map<ITermVar, ITermVar> asMap() {
        return Collections.unmodifiableMap(this.renaming);
    }

    @Override
    public ISubstitution.Immutable asSubstitution() {
        return PersistentSubstitution.Immutable.of(this.renaming);
    }

    public String toString() {
        return this.renaming.entrySet().stream().map(e -> e.getKey() + " |-> " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Renaming(BiMap biMap, Renaming renaming) {
        this((BiMap<ITermVar, ITermVar>)biMap);
    }

    public static class Builder {
        private final BiMap<ITermVar, ITermVar> renaming = HashBiMap.create();

        private Builder() {
        }

        public boolean containsKey(ITermVar var) {
            return this.renaming.containsKey((Object)var);
        }

        public boolean containsValue(ITermVar var) {
            return this.renaming.containsValue((Object)var);
        }

        public Builder put(ITermVar v1, ITermVar v2) {
            if (!v1.equals(v2)) {
                this.renaming.put((Object)v1, (Object)v2);
            }
            return this;
        }

        public Renaming build() {
            return new Renaming(this.renaming, null);
        }
    }
}

