/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;

public abstract class PersistentSubstitution
implements ISubstitution {
    protected abstract io.usethesource.capsule.Map<ITermVar, ITerm> subst();

    protected abstract MultiSet<ITermVar> range();

    @Override
    public boolean isEmpty() {
        return this.subst().isEmpty();
    }

    @Override
    public boolean contains(ITermVar var) {
        return this.subst().containsKey((Object)var);
    }

    @Override
    public Set<ITermVar> domainSet() {
        return this.subst().keySet();
    }

    @Override
    public Set<ITermVar> rangeSet() {
        return this.range().elementSet();
    }

    @Override
    public Set<Map.Entry<ITermVar, ITerm>> entrySet() {
        return this.subst().entrySet();
    }

    @Override
    public ITerm apply(ITerm term) {
        if (term.isGround()) {
            return term;
        }
        return term.match(Terms.cases(appl -> {
            ImmutableList<ITerm> newArgs = Terms.applyLazy(appl.getArgs(), this::apply);
            if (newArgs == null) {
                return appl;
            }
            return TermBuild.B.newAppl(appl.getOp(), (Iterable<? extends ITerm>)newArgs, appl.getAttachments());
        }, list2 -> this.apply((IListTerm)list2), string -> string, integer -> integer, blob -> blob, var -> this.apply((ITermVar)var)));
    }

    private IListTerm apply(IListTerm list2) {
        if (list2.isGround()) {
            return list2;
        }
        return list2.match(ListTerms.cases(cons -> {
            ITerm newHead = this.apply(cons.getHead());
            IListTerm newTail = this.apply(cons.getTail());
            if (newHead == cons.getHead() && newTail == cons.getTail()) {
                return cons;
            }
            return TermBuild.B.newCons(newHead, newTail, cons.getAttachments());
        }, nil -> nil, var -> (IListTerm)this.apply((ITermVar)var)));
    }

    private ITerm apply(ITermVar var) {
        return (ITerm)this.subst().getOrDefault((Object)var, (Object)var);
    }

    public String toString() {
        return this.subst().toString();
    }

    public static class Immutable
    extends PersistentSubstitution
    implements ISubstitution.Immutable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map.Immutable<ITermVar, ITerm> subst;
        private MultiSet.Immutable<ITermVar> range;

        public Immutable(Map.Immutable<ITermVar, ITerm> subst, MultiSet.Immutable<ITermVar> range) {
            this.subst = subst;
            this.range = range;
        }

        @Override
        protected io.usethesource.capsule.Map<ITermVar, ITerm> subst() {
            return this.subst;
        }

        @Override
        protected MultiSet<ITermVar> range() {
            return this.range;
        }

        @Override
        public ISubstitution.Immutable put(ITermVar var, ITerm term) {
            ISubstitution.Transient result = this.melt();
            result.put(var, term);
            return result.freeze();
        }

        @Override
        public ISubstitution.Immutable remove(ITermVar var) {
            ISubstitution.Transient result = this.melt();
            result.remove(var);
            return result.freeze();
        }

        @Override
        public ISubstitution.Immutable removeAll(Iterable<ITermVar> vars) {
            ISubstitution.Transient result = this.melt();
            result.removeAll(vars);
            return result.freeze();
        }

        @Override
        public ISubstitution.Immutable retainAll(Iterable<ITermVar> vars) {
            ISubstitution.Transient result = this.melt();
            result.retainAll(vars);
            return result.freeze();
        }

        @Override
        public ISubstitution.Immutable compose(ISubstitution.Immutable other) {
            ISubstitution.Transient result = this.melt();
            result.compose(other);
            return result.freeze();
        }

        @Override
        public ISubstitution.Immutable compose(ITermVar var, ITerm term) {
            ISubstitution.Transient result = this.melt();
            result.compose(var, term);
            return result.freeze();
        }

        @Override
        public ISubstitution.Transient melt() {
            return new Transient((Map.Transient<ITermVar, ITerm>)this.subst.asTransient(), this.range.melt());
        }

        public static ISubstitution.Immutable of() {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)Map.Immutable.of(), MultiSet.Immutable.of());
        }

        public static ISubstitution.Immutable of(ITermVar var, ITerm term) {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)Map.Immutable.of((Object)var, (Object)term), MultiSet.Immutable.of(term.getVars()));
        }

        public static ISubstitution.Immutable of(Map<ITermVar, ? extends ITerm> substEntries) {
            Map.Transient subst = Map.Transient.of();
            MultiSet.Transient range = MultiSet.Transient.of();
            substEntries.forEach((v, t) -> {
                subst.__put(v, t);
                range.addAll(t.getVars());
            });
            return new Immutable((Map.Immutable<ITermVar, ITerm>)subst.freeze(), range.freeze());
        }
    }

    public static class Transient
    extends PersistentSubstitution
    implements ISubstitution.Transient {
        private Map.Transient<ITermVar, ITerm> subst;
        private MultiSet.Transient<ITermVar> range;

        public Transient(Map.Transient<ITermVar, ITerm> subst, MultiSet.Transient<ITermVar> range) {
            this.subst = subst;
            this.range = range;
        }

        @Override
        protected io.usethesource.capsule.Map<ITermVar, ITerm> subst() {
            return this.subst;
        }

        @Override
        protected MultiSet<ITermVar> range() {
            return this.range;
        }

        @Override
        public void put(ITermVar var, ITerm term) {
            this.subst.__put((Object)var, (Object)term);
            this.range.addAll((Iterable<ITermVar>)term.getVars());
        }

        @Override
        public void remove(ITermVar var) {
            ITerm t = (ITerm)this.subst.__remove((Object)var);
            if (t != null) {
                this.range.removeAll((Iterable<ITermVar>)t.getVars());
            }
        }

        @Override
        public void removeAll(Iterable<ITermVar> vars) {
            for (ITermVar v : vars) {
                this.remove(v);
            }
        }

        @Override
        public void retainAll(Iterable<ITermVar> vars) {
            Set.Immutable<ITermVar> varSet = CapsuleUtil.toSet(vars);
            for (ITermVar v : this.subst.keySet()) {
                if (varSet.contains((Object)v)) continue;
                this.remove(v);
            }
        }

        @Override
        public void compose(ISubstitution.Immutable other) {
            this.subst.forEach((v, t) -> {
                this.range.removeAll((Iterable<ITermVar>)t.getVars());
                t = other.apply((ITerm)t);
                this.subst.__put(v, t);
                this.range.addAll((Iterable<ITermVar>)t.getVars());
            });
            for (Map.Entry<ITermVar, ITerm> e : other.removeAll(this.subst.keySet()).entrySet()) {
                ITerm t2 = e.getValue();
                this.subst.__put((Object)e.getKey(), (Object)t2);
                this.range.addAll((Iterable<ITermVar>)t2.getVars());
            }
        }

        @Override
        public void compose(ITermVar var, ITerm term) {
            this.compose(Immutable.of(var, term));
        }

        @Override
        public ISubstitution.Immutable freeze() {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)this.subst.freeze(), this.range.freeze());
        }

        public static ISubstitution.Transient of() {
            return new Transient((Map.Transient<ITermVar, ITerm>)Map.Transient.of(), MultiSet.Transient.of());
        }
    }
}

