/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.ATermIndex;

public final class TermIndex
extends ATermIndex
implements Serializable {
    private final IAttachments attachments;
    private final String resource;
    private final int id;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ARGS_LAZY_INIT_BIT = 1L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private TermIndex(String resource, int id) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.id = id;
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private TermIndex(IAttachments attachments, String resource, int id) {
        this.attachments = attachments;
        this.resource = resource;
        this.id = id;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final TermIndex withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new TermIndex(newValue, this.resource, this.id);
    }

    public final TermIndex withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new TermIndex(this.attachments, newValue, this.id);
    }

    public final TermIndex withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new TermIndex(this.attachments, this.resource, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.args;
    }

    public static TermIndex of(String resource, int id) {
        return new TermIndex(resource, id);
    }

    public static TermIndex copyOf(ATermIndex instance) {
        if (instance instanceof TermIndex) {
            return (TermIndex)instance;
        }
        return TermIndex.of(instance.getResource(), instance.getId()).withAttachments(instance.getAttachments());
    }
}

