/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.VarProvider;
import mb.nabl2.terms.stratego.StrategoAnnotations;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.nabl2.terms.stratego.StrategoTermIndices;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.metaborg.util.functions.Function1;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoPlaceholder;

public class StrategoTerms {
    private final ITermFactory termFactory;

    public StrategoTerms(ITermFactory termFactory) {
        this.termFactory = termFactory;
    }

    public IStrategoTerm toStratego(ITerm term) {
        return this.toStratego(term, false);
    }

    public IStrategoTerm toStratego(ITerm term, boolean varsToPlhdrs) {
        IStrategoTerm strategoTerm = term.match(Terms.cases(appl -> {
            IStrategoTerm[] argArray = (IStrategoTerm[])appl.getArgs().stream().map(arg -> this.toStratego((ITerm)arg, varsToPlhdrs)).toArray(IStrategoTerm[]::new);
            return appl.getOp().equals("") ? this.termFactory.makeTuple(argArray) : this.termFactory.makeAppl(this.termFactory.makeConstructor(appl.getOp(), appl.getArity()), argArray);
        }, list2 -> this.toStrategoList((IListTerm)list2, varsToPlhdrs), string -> this.termFactory.makeString(string.getValue()), integer -> this.termFactory.makeInt(integer.getValue()), blob -> new StrategoBlob(blob.getValue()), var -> {
            if (varsToPlhdrs) {
                return this.termFactory.makePlaceholder(this.termFactory.makeTuple(this.termFactory.makeString(var.getResource()), this.termFactory.makeString(var.getName())));
            }
            return this.termFactory.makeAppl("nabl2.Var", this.termFactory.makeString(var.getResource()), this.termFactory.makeString(var.getName()));
        }));
        switch (strategoTerm.getType()) {
            case LIST: 
            case BLOB: {
                break;
            }
            default: {
                strategoTerm = this.putAttachments(strategoTerm, term.getAttachments());
            }
        }
        return strategoTerm;
    }

    private IStrategoTerm toStrategoList(IListTerm list2, boolean varsToPlhdrs) {
        LinkedList terms = Lists.newLinkedList();
        LinkedList attachments = Lists.newLinkedList();
        while (list2 != null) {
            attachments.push(list2.getAttachments());
            list2 = list2.match(ListTerms.cases(cons -> {
                terms.push(this.toStratego(cons.getHead(), varsToPlhdrs));
                return cons.getTail();
            }, nil -> null, var -> {
                throw new IllegalArgumentException("Cannot convert specialized terms to Stratego.");
            }));
        }
        IStrategoList strategoList = this.termFactory.makeList();
        this.putAttachments(strategoList, (IAttachments)attachments.pop());
        while (!terms.isEmpty()) {
            strategoList = this.termFactory.makeListCons((IStrategoTerm)terms.pop(), strategoList);
            this.putAttachments(strategoList, (IAttachments)attachments.pop());
        }
        return strategoList;
    }

    private <T extends IStrategoTerm> T putAttachments(T term, IAttachments attachments) {
        StrategoAnnotations annotations;
        Optional<TermIndex> index;
        if (attachments.isEmpty()) {
            return term;
        }
        Optional<TermOrigin> origin = TermOrigin.get(attachments);
        if (origin.isPresent()) {
            origin.get().put((IStrategoTerm)term);
        }
        if ((index = TermIndex.get(attachments)).isPresent()) {
            term = StrategoTermIndices.put(index.get(), term, this.termFactory);
        }
        if ((annotations = attachments.get(StrategoAnnotations.class)) != null && !annotations.isEmpty()) {
            IStrategoTerm result = this.termFactory.copyAttachments((IStrategoTerm)term, this.termFactory.annotateTerm((IStrategoTerm)term, this.termFactory.makeList((Collection<? extends IStrategoTerm>)annotations.getAnnotationList())));
            term = result;
        }
        return term;
    }

    public ITerm fromStratego(IStrategoTerm sterm) {
        return this.fromStratego(sterm, null);
    }

    public ITerm fromStratego(IStrategoTerm sterm, @Nullable VarProvider varProvider) {
        IAttachments attachments = StrategoTerms.getAttachments(sterm);
        ITerm term = StrategoTerms.match(sterm, StrategoTerms.cases(appl -> {
            IStrategoTerm[] subTerms = appl.getAllSubterms();
            ImmutableList.Builder args = ImmutableList.builderWithExpectedSize((int)subTerms.length);
            IStrategoTerm[] iStrategoTermArray = subTerms;
            int n = subTerms.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm subTerm = iStrategoTermArray[n2];
                args.add((Object)this.fromStratego(subTerm, varProvider));
                ++n2;
            }
            return TermBuild.B.newAppl(appl.getConstructor().getName(), (Iterable<? extends ITerm>)args.build(), attachments);
        }, tuple2 -> {
            IStrategoTerm[] subTerms = tuple2.getAllSubterms();
            ImmutableList.Builder args = ImmutableList.builderWithExpectedSize((int)subTerms.length);
            IStrategoTerm[] iStrategoTermArray = subTerms;
            int n = subTerms.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm subTerm = iStrategoTermArray[n2];
                args.add((Object)this.fromStratego(subTerm, varProvider));
                ++n2;
            }
            return TermBuild.B.newTuple((Iterable<? extends ITerm>)args.build(), attachments);
        }, list2 -> this.fromStrategoList((IStrategoList)list2, varProvider), integer -> TermBuild.B.newInt(integer.intValue(), attachments), real -> {
            throw new IllegalArgumentException("Real values are not supported.");
        }, string -> TermBuild.B.newString(string.stringValue(), attachments), blob -> TermBuild.B.newBlob(blob.value()), plhdr -> {
            if (varProvider != null) {
                return varProvider.freshWld();
            }
            throw new IllegalArgumentException("Placeholders are not supported.");
        }));
        return term;
    }

    private IListTerm fromStrategoList(IStrategoList list2, @Nullable VarProvider varProvider) {
        LinkedList terms = Lists.newLinkedList();
        LinkedList attachments = Lists.newLinkedList();
        while (!list2.isEmpty()) {
            terms.add(this.fromStratego(list2.head(), varProvider));
            attachments.push(StrategoTerms.getAttachments(list2));
            list2 = list2.tail();
        }
        attachments.add(StrategoTerms.getAttachments(list2));
        return TermBuild.B.newList(terms, attachments);
    }

    public static IAttachments getAttachments(IStrategoTerm term) {
        Attachments.Builder b = Attachments.Builder.of();
        TermOrigin.get(term).ifPresent(origin -> b.put(TermOrigin.class, origin));
        StrategoTermIndices.get(term).ifPresent(termIndex -> b.put(TermIndex.class, termIndex));
        IStrategoList annos = term.getAnnotations();
        if (!annos.isEmpty()) {
            b.put(StrategoAnnotations.class, StrategoAnnotations.of(annos));
        }
        return b.build();
    }

    public static <T> T match(IStrategoTerm term, ICases<T> cases) {
        switch (term.getType()) {
            case APPL: {
                return cases.caseAppl((IStrategoAppl)term);
            }
            case LIST: {
                return cases.caseList((IStrategoList)term);
            }
            case TUPLE: {
                return cases.caseTuple((IStrategoTuple)term);
            }
            case INT: {
                return cases.caseInt((IStrategoInt)term);
            }
            case REAL: {
                return cases.caseReal((IStrategoReal)term);
            }
            case STRING: {
                return cases.caseString((IStrategoString)term);
            }
            case BLOB: {
                if (term instanceof StrategoBlob) {
                    StrategoBlob blob = (StrategoBlob)term;
                    return cases.caseBlob(blob);
                }
                throw new IllegalArgumentException("Unsupported Stratego blob type " + term.getClass());
            }
            case PLACEHOLDER: {
                return cases.casePlhdr((StrategoPlaceholder)term);
            }
        }
        throw new IllegalArgumentException("Unsupported Stratego term type " + (Object)((Object)term.getType()));
    }

    public static <T> ICases<T> cases(final Function1<IStrategoAppl, T> onAppl, final Function1<IStrategoTuple, T> onTuple, final Function1<IStrategoList, T> onList, final Function1<IStrategoInt, T> onInt, final Function1<IStrategoReal, T> onReal, final Function1<IStrategoString, T> onString, final Function1<StrategoBlob, T> onBlob, final Function1<IStrategoPlaceholder, T> onPlhdr) {
        return new ICases<T>(){

            @Override
            public T caseAppl(IStrategoAppl term) {
                return onAppl.apply(term);
            }

            @Override
            public T caseTuple(IStrategoTuple term) {
                return onTuple.apply(term);
            }

            @Override
            public T caseList(IStrategoList term) {
                return onList.apply(term);
            }

            @Override
            public T caseInt(IStrategoInt term) {
                return onInt.apply(term);
            }

            @Override
            public T caseReal(IStrategoReal term) {
                return onReal.apply(term);
            }

            @Override
            public T caseString(IStrategoString term) {
                return onString.apply(term);
            }

            @Override
            public T caseBlob(StrategoBlob term) {
                return onBlob.apply(term);
            }

            @Override
            public T casePlhdr(IStrategoPlaceholder term) {
                return onPlhdr.apply(term);
            }
        };
    }

    @FunctionalInterface
    public static interface Attacher {
        public <T> void put(Class<T> var1, T var2);
    }

    public static interface ICases<T> {
        public T caseAppl(IStrategoAppl var1);

        public T caseList(IStrategoList var1);

        public T caseTuple(IStrategoTuple var1);

        public T caseInt(IStrategoInt var1);

        public T caseReal(IStrategoReal var1);

        public T caseString(IStrategoString var1);

        public T caseBlob(StrategoBlob var1);

        public T casePlhdr(IStrategoPlaceholder var1);
    }
}

