/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.PlaceholderVarMap;
import mb.nabl2.terms.stratego.StrategoAnnotations;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public final class StrategoPlaceholders {
    private static final String PLACEHOLDER_SUFFIX = "-Plhdr";

    private StrategoPlaceholders() {
    }

    public static boolean isPlaceholder(IStrategoAppl term) {
        IStrategoConstructor constructor = term.getConstructor();
        return constructor.getName().endsWith(PLACEHOLDER_SUFFIX) && constructor.getArity() == 0;
    }

    public static boolean isPlaceholder(IApplTerm term) {
        return term.getOp().endsWith(PLACEHOLDER_SUFFIX) && term.getArity() == 0;
    }

    public static ITerm replacePlaceholdersByVariables(ITerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(Terms.casesFix((m, appl) -> {
            if (StrategoPlaceholders.isPlaceholder(appl)) {
                return placeholderVarMap.addPlaceholderMapping((IApplTerm)appl);
            }
            return TermBuild.B.newAppl(appl.getOp(), appl.getArgs().stream().map(a -> (ITerm)a.match(m)).collect(Collectors.toList()), appl.getAttachments());
        }, (m, list2) -> list2.match(ListTerms.casesFix((lm, cons) -> TermBuild.B.newCons((ITerm)cons.getHead().match(m), (IListTerm)cons.getTail().match(lm), cons.getAttachments()), (lm, nil) -> nil, (lm, var) -> var)), (m, string) -> string, (m, integer) -> integer, (m, blob) -> blob, (m, var) -> var));
    }

    public static ITerm replaceVariablesByPlaceholders(ITerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(Terms.cases(appl -> {
            if (StrategoPlaceholders.isInjectionConstructor(appl) && StrategoPlaceholders.onlyInjectionConstructorsAndVariables(appl)) {
                return StrategoPlaceholders.getPlaceholderForTerm(appl);
            }
            return TermBuild.B.newAppl(appl.getOp(), appl.getArgs().stream().map(a -> StrategoPlaceholders.replaceVariablesByPlaceholders(a, placeholderVarMap)).collect(Collectors.toList()), appl.getAttachments());
        }, list2 -> StrategoPlaceholders.replaceVariablesByPlaceholdersInList(list2, placeholderVarMap), string -> string, integer -> integer, blob -> blob, var -> StrategoPlaceholders.getPlaceholderForVar(var, placeholderVarMap)));
    }

    public static IListTerm replaceVariablesByPlaceholdersInList(IListTerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(ListTerms.cases(cons -> TermBuild.B.newCons(StrategoPlaceholders.replaceVariablesByPlaceholders(cons.getHead(), placeholderVarMap), StrategoPlaceholders.replaceVariablesByPlaceholdersInList(cons.getTail(), placeholderVarMap), cons.getAttachments()), nil -> nil, var -> var));
    }

    private static boolean isInjectionConstructor(IApplTerm appl) {
        return appl.getOp().contains("2");
    }

    public static boolean onlyInjectionConstructorsAndVariables(ITerm term) {
        return term.match(Terms.cases(appl -> {
            if (!StrategoPlaceholders.isInjectionConstructor(appl)) {
                return false;
            }
            return appl.getArgs().stream().allMatch(StrategoPlaceholders::onlyInjectionConstructorsAndVariables);
        }, list2 -> false, string -> false, integer -> false, blob -> false, var -> true));
    }

    private static ITerm getPlaceholderForVar(ITermVar var, PlaceholderVarMap placeholderVarMap) {
        IApplTerm placeholder = placeholderVarMap.getPlaceholder(var);
        if (placeholder != null) {
            return placeholder;
        }
        return StrategoPlaceholders.getPlaceholderForTerm(var);
    }

    private static ITerm getPlaceholderForTerm(ITerm term) {
        ITerm newPlaceholder = StrategoPlaceholders.getPlaceholderFromAttachments(term.getAttachments());
        return newPlaceholder != null ? newPlaceholder : TermBuild.B.newAppl("??-Plhdr", new ITerm[0]);
    }

    @Nullable
    private static ITerm getPlaceholderFromAttachments(IAttachments attachments) {
        StrategoAnnotations annotations = attachments.get(StrategoAnnotations.class);
        if (annotations == null) {
            return null;
        }
        return StrategoPlaceholders.getPlaceholderFromAnnotations(annotations.getAnnotationList());
    }

    @Nullable
    private static ITerm getPlaceholderFromAnnotations(List<IStrategoTerm> annotations) {
        for (IStrategoTerm term : annotations) {
            if (!TermUtils.isAppl(term, "OfSort", 1)) continue;
            return StrategoPlaceholders.getPlaceholderFromSortTerm(term.getSubterm(0));
        }
        return null;
    }

    @Nullable
    private static ITerm getPlaceholderFromSortTerm(IStrategoTerm term) {
        if (TermUtils.isAppl(term, "SORT", 1)) {
            return TermBuild.B.newAppl(String.valueOf(TermUtils.toJavaStringAt(term, 0)) + PLACEHOLDER_SUFFIX, new ITerm[0]);
        }
        if (TermUtils.isAppl(term, "LIST", 1)) {
            return TermBuild.B.newList(StrategoPlaceholders.getPlaceholderFromSortTerm(term.getSubterm(0)));
        }
        if (TermUtils.isAppl(term, null, 0)) {
            String name2 = TermUtils.toAppl(term).getConstructor().getName();
            return TermBuild.B.newAppl("_" + Character.toUpperCase(name2.charAt(0)) + name2.substring(1).toLowerCase(), new ITerm[0]);
        }
        throw new UnsupportedOperationException("Unknown sort: " + term);
    }
}

