/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.Optional;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermPlaceholder;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ATermPlaceholder {
    @Value.Parameter
    public abstract String getName();

    public <T extends ITerm> T put(T term) {
        IAttachments.Builder attachments = term.getAttachments().toBuilder();
        attachments.put(TermPlaceholder.class, (TermPlaceholder)this);
        return (T)term.withAttachments(attachments.build());
    }

    public String toString() {
        return this.getName();
    }

    public static Optional<TermPlaceholder> get(ITerm term) {
        return ATermPlaceholder.get(term.getAttachments());
    }

    public static Optional<TermPlaceholder> get(IAttachments attachments) {
        return Optional.ofNullable(attachments.get(TermPlaceholder.class));
    }

    public static boolean has(ITerm term) {
        return ATermPlaceholder.get(term).isPresent();
    }

    public static <T extends ITerm> T copy(ITerm src, T dst) {
        return (T)ATermPlaceholder.get(src).map(o -> o.put(dst)).orElse(dst);
    }

    public static TermPlaceholder of(String name2) {
        return TermPlaceholder.of(name2);
    }
}

