/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.ApplPattern;
import mb.nabl2.terms.matching.ConsPattern;
import mb.nabl2.terms.matching.IntPattern;
import mb.nabl2.terms.matching.MatchResult;
import mb.nabl2.terms.matching.MaybeNotInstantiated;
import mb.nabl2.terms.matching.NilPattern;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.PatternAs;
import mb.nabl2.terms.matching.PatternVar;
import mb.nabl2.terms.matching.StringPattern;
import mb.nabl2.terms.matching.VarProvider;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Predicate1;

public class TermPattern {
    public static P P = new P();

    public static class P {
        public Pattern newAppl(String op, Pattern ... args) {
            return this.newAppl(op, Arrays.asList(args), Attachments.empty());
        }

        public Pattern newAppl(String op, Iterable<? extends Pattern> args, IAttachments attachments) {
            if (op.equals("")) {
                throw new IllegalArgumentException();
            }
            return new ApplPattern(op, args, attachments);
        }

        public Pattern newTuple(Pattern ... args) {
            return this.newTuple(Arrays.asList(args), Attachments.empty());
        }

        public Pattern newTuple(Iterable<? extends Pattern> args) {
            return this.newTuple(args, Attachments.empty());
        }

        public Pattern newTuple(Iterable<? extends Pattern> args, IAttachments attachments) {
            ImmutableList argList = ImmutableList.copyOf(args);
            if (argList.size() == 1) {
                return (Pattern)argList.get(0);
            }
            return new ApplPattern("", (Iterable<? extends Pattern>)argList, attachments);
        }

        public Pattern newList(Iterable<? extends Pattern> args) {
            return this.newListTail(args, this.newNil(), Attachments.empty());
        }

        public Pattern newList(Iterable<? extends Pattern> args, IAttachments attachments) {
            return this.newListTail(args, this.newNil(attachments), attachments);
        }

        public Pattern newListTail(Iterable<? extends Pattern> args, Pattern tail) {
            return this.newListTail(args, tail, Attachments.empty());
        }

        public Pattern newListTail(Iterable<? extends Pattern> args, Pattern tail, IAttachments attachments) {
            Pattern list2 = tail;
            for (Pattern elem : ImmutableList.copyOf(args).reverse()) {
                list2 = this.newCons(elem, list2, attachments);
            }
            return list2;
        }

        public Pattern newCons(Pattern head, Pattern tail, IAttachments attachments) {
            return new ConsPattern(head, tail, attachments);
        }

        public Pattern newNil() {
            return new NilPattern(Attachments.empty());
        }

        public Pattern newNil(IAttachments attachments) {
            return new NilPattern(attachments);
        }

        public Pattern newString(String value) {
            return new StringPattern(value, Attachments.empty());
        }

        public Pattern newString(String value, IAttachments attachments) {
            return new StringPattern(value, attachments);
        }

        public Pattern newInt(int value) {
            return new IntPattern(value, Attachments.empty());
        }

        public Pattern newInt(int value, IAttachments attachments) {
            return new IntPattern(value, attachments);
        }

        public Pattern newWld() {
            return new PatternVar();
        }

        public Pattern newVar(String name2) {
            return new PatternVar(name2);
        }

        public Pattern newVar(ITermVar var) {
            return new PatternVar(var);
        }

        public Pattern newAs(String name2, Pattern pattern) {
            return new PatternAs(name2, pattern);
        }

        public Pattern newAs(ITermVar var, Pattern pattern) {
            return new PatternAs(var, pattern);
        }

        public Pattern newAs(Pattern pattern) {
            return new PatternAs(pattern);
        }

        public Pattern fromTerm(ITerm term) {
            return this.fromTerm(term, v -> false);
        }

        public Pattern fromTerm(ITerm term, Predicate1<ITermVar> isWildcard) {
            return term.match(Terms.cases(appl -> {
                List<ITerm> args = appl.getArgs();
                ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)args.size());
                for (ITerm arg : args) {
                    newArgs.add((Object)this.fromTerm(arg, isWildcard));
                }
                return new ApplPattern(appl.getOp(), (Iterable<? extends Pattern>)newArgs.build(), appl.getAttachments());
            }, list2 -> list2.match(ListTerms.cases(cons -> new ConsPattern(this.fromTerm(cons.getHead(), isWildcard), this.fromTerm(cons.getTail(), isWildcard), cons.getAttachments()), nil -> new NilPattern(nil.getAttachments()), var -> isWildcard.test((ITermVar)var) ? new PatternVar() : new PatternVar((ITermVar)var))), string -> new StringPattern(string.getValue(), string.getAttachments()), integer -> new IntPattern(integer.getValue(), integer.getAttachments()), blob -> {
                throw new IllegalArgumentException("Cannot create blob patterns.");
            }, var -> isWildcard.test((ITermVar)var) ? new PatternVar() : new PatternVar((ITermVar)var)));
        }

        public Optional<ISubstitution.Immutable> match(Iterable<Pattern> patterns, Iterable<ITerm> terms) {
            return P.newTuple(patterns).match(TermBuild.B.newTuple(terms));
        }

        public MaybeNotInstantiated<Optional<ISubstitution.Immutable>> match(Iterable<Pattern> patterns, Iterable<? extends ITerm> terms, IUnifier.Immutable unifier) {
            return P.newTuple(patterns).match(TermBuild.B.newTuple(terms), unifier);
        }

        public Optional<MatchResult> matchWithEqs(Iterable<Pattern> patterns, Iterable<? extends ITerm> terms, IUnifier.Immutable unifier, VarProvider fresh) {
            return P.newTuple(patterns).matchWithEqs(TermBuild.B.newTuple(terms), unifier, fresh);
        }
    }
}

