/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import io.usethesource.capsule.Set;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.PatternVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.iterators.Iterables2;

class PatternAs
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final PatternVar var;
    private final Pattern pattern;

    public PatternAs(String name2, Pattern pattern) {
        this(TermBuild.B.newVar("", name2), pattern);
    }

    public PatternAs(ITermVar var, Pattern pattern) {
        super(Attachments.empty());
        this.var = new PatternVar(var);
        this.pattern = pattern;
    }

    PatternAs(PatternVar var, Pattern pattern) {
        super(Attachments.empty());
        this.var = var;
        this.pattern = pattern;
    }

    PatternAs(Pattern pattern) {
        super(Attachments.empty());
        this.var = new PatternVar();
        this.pattern = pattern;
    }

    @Nullable
    ITermVar getVar() {
        return this.var.getVar();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<ITermVar> getVars() {
        Set.Transient vars = CapsuleUtil.transientSet();
        vars.__insertAll(this.var.getVars());
        vars.__insertAll(this.pattern.getVars());
        return vars.freeze();
    }

    @Override
    public boolean isConstructed() {
        return this.pattern.isConstructed();
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return PatternAs.matchTerms(Iterables2.from(this.var, this.pattern), Iterables2.from(term, term), subst, unifier, eqs);
    }

    @Override
    public PatternAs apply(IRenaming subst) {
        return new PatternAs(this.var.apply(subst), this.pattern.apply(subst));
    }

    @Override
    public PatternAs eliminateWld(Function0<ITermVar> fresh) {
        return new PatternAs((PatternVar)this.var.eliminateWld((Function0)fresh), this.pattern.eliminateWld(fresh));
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        ITerm term = this.pattern.asTerm(equalities, fresh);
        if (this.var.isWildcard()) {
            return term;
        }
        equalities.apply(this.var.getVar(), term);
        return this.var.getVar();
    }

    public String toString() {
        return String.valueOf(this.var.toString()) + "@" + this.pattern.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternAs patternAs = (PatternAs)o;
        return Objects.equals(this.var, patternAs.var) && Objects.equals(this.pattern, patternAs.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.var, this.pattern);
    }
}

