/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.ApplPattern;
import mb.nabl2.terms.matching.ConsPattern;
import mb.nabl2.terms.matching.IntPattern;
import mb.nabl2.terms.matching.MatchResult;
import mb.nabl2.terms.matching.MaybeNotInstantiated;
import mb.nabl2.terms.matching.NilPattern;
import mb.nabl2.terms.matching.PatternAs;
import mb.nabl2.terms.matching.PatternVar;
import mb.nabl2.terms.matching.StringPattern;
import mb.nabl2.terms.matching.VarProvider;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.tuple.Tuple2;

public abstract class Pattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IAttachments attachments;
    public static final LeftRightOrder leftRightOrdering = new LeftRightOrder();

    protected Pattern(IAttachments attachments) {
        this.attachments = attachments;
    }

    public IAttachments getAttachments() {
        return this.attachments;
    }

    public abstract Set<ITermVar> getVars();

    public abstract boolean isConstructed();

    public Optional<ISubstitution.Immutable> match(ITerm term) {
        return this.match(term, Unifiers.Immutable.of()).match((T t) -> t, (List<ITermVar> v) -> Optional.empty());
    }

    public MaybeNotInstantiated<Optional<ISubstitution.Immutable>> match(ITerm term, IUnifier.Immutable unifier) {
        ArrayList stuckVars;
        Eqs eqs;
        ISubstitution.Transient subst = PersistentSubstitution.Transient.of();
        if (!this.matchTerm(term, subst, unifier, eqs = new Eqs(stuckVars = Lists.newArrayList()){
            private final /* synthetic */ List val$stuckVars;
            {
                this.val$stuckVars = list2;
            }

            @Override
            public void add(ITermVar var, ITerm pattern) {
                this.val$stuckVars.add(var);
            }

            @Override
            public void add(ITermVar var, Pattern pattern) {
                this.val$stuckVars.add(var);
            }
        })) {
            return MaybeNotInstantiated.ofResult(Optional.empty());
        }
        if (!stuckVars.isEmpty()) {
            return MaybeNotInstantiated.ofNotInstantiated(stuckVars);
        }
        return MaybeNotInstantiated.ofResult(Optional.of(subst.freeze()));
    }

    public Optional<MatchResult> matchWithEqs(ITerm term, IUnifier.Immutable unifier, VarProvider fresh) {
        ITerm rightTerm;
        ITermVar leftVar;
        ArrayList patternEqs;
        ArrayList termEqs;
        Eqs eqs;
        ISubstitution.Transient _subst = PersistentSubstitution.Transient.of();
        if (!this.matchTerm(term, _subst, unifier, eqs = new Eqs(termEqs = Lists.newArrayList(), patternEqs = Lists.newArrayList()){
            private final /* synthetic */ List val$termEqs;
            private final /* synthetic */ List val$patternEqs;
            {
                this.val$termEqs = list2;
                this.val$patternEqs = list3;
            }

            @Override
            public void add(ITermVar var, ITerm term) {
                this.val$termEqs.add(Tuple2.of(var, term));
            }

            @Override
            public void add(ITermVar var, Pattern pattern) {
                this.val$patternEqs.add(Tuple2.of(var, pattern));
            }
        })) {
            return Optional.empty();
        }
        ImmutableSet freeVars = Sets.difference(this.getVars(), _subst.domainSet()).immutableCopy();
        for (ITermVar v2 : freeVars) {
            _subst.put(v2, fresh.freshVar(v2));
        }
        ISubstitution.Immutable subst = _subst.freeze();
        ImmutableSet.Builder stuckVars = ImmutableSet.builder();
        ImmutableList.Builder allEqs = ImmutableList.builder();
        for (Tuple2 termEq : termEqs) {
            leftVar = (ITermVar)termEq._1();
            rightTerm = (ITerm)termEq._2();
            stuckVars.add((Object)leftVar);
            allEqs.add(Tuple2.of(leftVar, rightTerm));
        }
        for (Tuple2 patternEq : patternEqs) {
            leftVar = (ITermVar)patternEq._1();
            rightTerm = ((Pattern)patternEq._2()).asTerm((v, t) -> allEqs.add(Tuple2.of(subst.apply((ITerm)v), subst.apply((ITerm)t))), v -> v.orElseGet(() -> fresh.freshWld()));
            stuckVars.add((Object)leftVar);
            allEqs.add(Tuple2.of(leftVar, subst.apply(rightTerm)));
        }
        return Optional.of(new MatchResult(subst, (Set<ITermVar>)stuckVars.build(), (List<Tuple2<ITerm, ITerm>>)allEqs.build()));
    }

    protected abstract boolean matchTerm(ITerm var1, ISubstitution.Transient var2, IUnifier.Immutable var3, Eqs var4);

    protected static boolean matchTerms(Iterable<Pattern> patterns, Iterable<ITerm> terms, ISubstitution.Transient subst, IUnifier.Immutable unifier, Eqs eqs) {
        Iterator<Pattern> itPattern = patterns.iterator();
        Iterator<ITerm> itTerm = terms.iterator();
        while (itPattern.hasNext()) {
            if (!itTerm.hasNext()) {
                return false;
            }
            if (itPattern.next().matchTerm(itTerm.next(), subst, unifier, eqs)) continue;
            return false;
        }
        return !itTerm.hasNext();
    }

    public abstract Pattern apply(IRenaming var1);

    public abstract Pattern eliminateWld(Function0<ITermVar> var1);

    public Tuple2<ITerm, List<Tuple2<ITermVar, ITerm>>> asTerm(Function1<Optional<ITermVar>, ITermVar> fresh) {
        ImmutableList.Builder eqs = ImmutableList.builder();
        ITerm term = this.asTerm((v, t) -> eqs.add(Tuple2.of(v, t)), fresh);
        return Tuple2.of(term, eqs.build());
    }

    protected abstract ITerm asTerm(Action2<ITermVar, ITerm> var1, Function1<Optional<ITermVar>, ITermVar> var2);

    protected static interface Eqs {
        public void add(ITermVar var1, Pattern var2);

        public void add(ITermVar var1, ITerm var2);
    }

    public static class LeftRightOrder {
        public Optional<Integer> compare(Pattern p1, Pattern p2) {
            return Optional.ofNullable(this.compare(p1, p2, new AtomicInteger(), new HashMap<ITermVar, Integer>(), new HashMap<ITermVar, Integer>()));
        }

        @Nullable
        private Integer compare(Pattern p1, Pattern p2, AtomicInteger pos, Map<ITermVar, Integer> vars1, Map<ITermVar, Integer> vars2) {
            if (p1 instanceof ApplPattern) {
                ApplPattern appl1 = (ApplPattern)p1;
                if (p2 instanceof ApplPattern) {
                    ApplPattern appl2 = (ApplPattern)p2;
                    if (!appl1.getOp().equals(appl2.getOp())) {
                        return null;
                    }
                    if (appl1.getArgs().size() != appl2.getArgs().size()) {
                        return null;
                    }
                    Iterator<Pattern> it1 = appl1.getArgs().iterator();
                    Iterator<Pattern> it2 = appl2.getArgs().iterator();
                    Integer c = 0;
                    while (c != null && c == 0 && it1.hasNext()) {
                        c = this.compare(it1.next(), it2.next(), pos, vars1, vars2);
                    }
                    return c;
                }
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    if (this.boundAt(var2, vars2) >= 0) {
                        return 1;
                    }
                    this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                    return -1;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return null;
            }
            if (p1 instanceof ConsPattern) {
                ConsPattern cons1 = (ConsPattern)p1;
                if (p2 instanceof ConsPattern) {
                    ConsPattern cons2 = (ConsPattern)p2;
                    Integer c = 0;
                    c = this.compare(cons1.getHead(), cons2.getHead(), pos, vars1, vars2);
                    if (c != null && c == 0) {
                        c = this.compare(cons1.getTail(), cons2.getTail(), pos, vars1, vars2);
                    }
                    return c;
                }
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    if (this.boundAt(var2, vars2) >= 0) {
                        return 1;
                    }
                    this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                    return -1;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return null;
            }
            if (p1 instanceof NilPattern) {
                if (p2 instanceof NilPattern) {
                    return 0;
                }
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    if (this.boundAt(var2, vars2) >= 0) {
                        return 1;
                    }
                    this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                    return -1;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return null;
            }
            if (p1 instanceof StringPattern) {
                StringPattern string1 = (StringPattern)p1;
                if (p2 instanceof StringPattern) {
                    StringPattern string2 = (StringPattern)p2;
                    return string1.getValue().equals(string2.getValue()) ? Integer.valueOf(0) : null;
                }
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    if (this.boundAt(var2, vars2) >= 0) {
                        return 1;
                    }
                    this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                    return -1;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return null;
            }
            if (p1 instanceof IntPattern) {
                IntPattern integer1 = (IntPattern)p1;
                if (p2 instanceof IntPattern) {
                    IntPattern integer2 = (IntPattern)p2;
                    return integer1.getValue() == integer2.getValue() ? Integer.valueOf(0) : null;
                }
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    if (this.boundAt(var2, vars2) >= 0) {
                        return 1;
                    }
                    this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                    return -1;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return null;
            }
            if (p1 instanceof PatternVar) {
                PatternVar var1 = (PatternVar)p1;
                int i1 = this.boundAt(var1, vars1);
                if (p2 instanceof PatternVar) {
                    PatternVar var2 = (PatternVar)p2;
                    int i2 = this.boundAt(var2, vars2);
                    if (i1 < 0 && i2 < 0) {
                        this.bind(var1.getVar(), vars1, var2.getVar(), vars2, pos.getAndIncrement());
                        return 0;
                    }
                    if (i1 < 0 && i2 >= 0) {
                        this.bind(var2.getVar(), vars1, pos.getAndIncrement());
                        return 1;
                    }
                    if (i1 >= 0 && i2 < 0) {
                        this.bind(var2.getVar(), vars2, pos.getAndIncrement());
                        return -1;
                    }
                    return i1 - i2;
                }
                if (p2 instanceof PatternAs) {
                    PatternAs as2 = (PatternAs)p2;
                    this.bind(as2.getVar(), vars2, pos.get());
                    return this.compare(p1, as2.getPattern(), pos, vars1, vars2);
                }
                return 1;
            }
            if (p1 instanceof PatternAs) {
                PatternAs as1 = (PatternAs)p1;
                this.bind(as1.getVar(), vars1, pos.get());
                return this.compare(as1.getPattern(), p2, pos, vars1, vars2);
            }
            return null;
        }

        private int boundAt(PatternVar vp, Map<ITermVar, Integer> vars) {
            ITermVar v = vp.getVar();
            if (v == null) {
                return -1;
            }
            return vars.getOrDefault(v, -1);
        }

        private void bind(@Nullable ITermVar v1, Map<ITermVar, Integer> vars1, @Nullable ITermVar v2, Map<ITermVar, Integer> vars2, int pos) {
            this.bind(v1, vars1, pos);
            this.bind(v2, vars2, pos);
        }

        private void bind(@Nullable ITermVar v, Map<ITermVar, Integer> vars, int pos) {
            if (v != null && !vars.containsKey(v)) {
                vars.put(v, pos);
            }
        }

        public Comparator<Pattern> asComparator() {
            return new Comparator<Pattern>(){

                @Override
                public int compare(Pattern p1, Pattern p2) {
                    return this.compare(p1, p2).orElse(0);
                }
            };
        }
    }
}

