/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

class ApplPattern
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final String op;
    private final List<Pattern> args;

    public ApplPattern(String op, Iterable<? extends Pattern> args, IAttachments attachments) {
        super(attachments);
        this.op = op;
        this.args = ImmutableList.copyOf(args);
    }

    public String getOp() {
        return this.op;
    }

    public List<Pattern> getArgs() {
        return this.args;
    }

    public Set<ITermVar> getVars() {
        Set.Transient vars = CapsuleUtil.transientSet();
        for (Pattern arg : this.args) {
            vars.__insertAll(arg.getVars());
        }
        return vars.freeze();
    }

    @Override
    public boolean isConstructed() {
        return true;
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return unifier.findTerm(term).match(Terms.cases().appl(applTerm -> {
            if (applTerm.getArity() == this.args.size() && applTerm.getOp().equals(this.op)) {
                return ApplPattern.matchTerms(this.args, applTerm.getArgs(), subst, unifier, eqs);
            }
            return false;
        }).var(v -> {
            eqs.add((ITermVar)v, this);
            return true;
        }).otherwise(t -> false));
    }

    @Override
    public Pattern apply(IRenaming subst) {
        ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)this.args.size());
        for (Pattern arg : this.args) {
            newArgs.add((Object)arg.apply(subst));
        }
        return new ApplPattern(this.op, (Iterable<? extends Pattern>)newArgs.build(), this.getAttachments());
    }

    @Override
    public ApplPattern eliminateWld(Function0<ITermVar> fresh) {
        ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)this.args.size());
        for (Pattern arg : this.args) {
            newArgs.add((Object)arg.eliminateWld(fresh));
        }
        return new ApplPattern(this.op, (Iterable<? extends Pattern>)newArgs.build(), this.getAttachments());
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)this.args.size());
        for (Pattern arg : this.args) {
            newArgs.add((Object)arg.asTerm(equalities, fresh));
        }
        return TermBuild.B.newAppl(this.op, (Iterable<? extends ITerm>)newArgs.build(), this.getAttachments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.op);
        sb.append("(").append(this.args.stream().map(Object::toString).collect(Collectors.joining(",", "", ""))).append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplPattern that = (ApplPattern)o;
        return Objects.equals(this.op, that.op) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.op, this.args);
    }
}

