/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.ATermVar;
import mb.nabl2.terms.build.AbstractTerm;

public final class TermVar
extends ATermVar
implements Serializable {
    private final IAttachments attachments;
    private final int minSize;
    private final String resource;
    private final String name;
    private int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private TermVar(String resource, String name2) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.name = Objects.requireNonNull(name2, "name");
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    private TermVar(Builder builder) {
        this.resource = builder.resource;
        this.name = builder.name;
        if (builder.attachments != null) {
            this.initShim.attachments(builder.attachments);
        }
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    private TermVar(IAttachments attachments, String resource, String name2) {
        this.initShim.attachments(attachments);
        this.resource = resource;
        this.name = name2;
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    @Override
    public IAttachments getAttachments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttachments() : this.attachments;
    }

    @Override
    public int getMinSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinSize() : this.minSize;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final TermVar withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return TermVar.validate(new TermVar(newValue, this.resource, this.name));
    }

    public final TermVar withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return TermVar.validate(new TermVar(this.attachments, newValue, this.name));
    }

    public final TermVar withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return TermVar.validate(new TermVar(this.attachments, this.resource, newValue));
    }

    public static TermVar of(String resource, String name2) {
        return TermVar.validate(new TermVar(resource, name2));
    }

    private static TermVar validate(TermVar instance) {
        instance.check();
        return instance;
    }

    public static TermVar copyOf(ATermVar instance) {
        if (instance instanceof TermVar) {
            return (TermVar)instance;
        }
        return TermVar.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return TermVar.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ TermVar(Builder builder, TermVar termVar) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private IAttachments attachments;
        private String resource;
        private String name;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ITermVar instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ATermVar instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof ITermVar) {
                instance = (ITermVar)object;
                if ((bits & 4L) == 0L) {
                    this.name(instance.getName());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(instance.getResource());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof ATermVar) {
                instance = (ATermVar)object;
                if ((bits & 4L) == 0L) {
                    this.name(((ATermVar)instance).getName());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(((ATermVar)instance).getResource());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name2) {
            this.name = Objects.requireNonNull(name2, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public TermVar build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return TermVar.validate(new TermVar(this, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TermVar, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte attachmentsBuildStage = 0;
        private IAttachments attachments;
        private byte minSizeBuildStage = 0;
        private int minSize;

        private InitShim() {
        }

        IAttachments getAttachments() {
            if (this.attachmentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentsBuildStage == 0) {
                this.attachmentsBuildStage = (byte)-1;
                this.attachments = Objects.requireNonNull(TermVar.super.getAttachments(), "attachments");
                this.attachmentsBuildStage = 1;
            }
            return this.attachments;
        }

        void attachments(IAttachments attachments) {
            this.attachments = attachments;
            this.attachmentsBuildStage = 1;
        }

        int getMinSize() {
            if (this.minSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSizeBuildStage == 0) {
                this.minSizeBuildStage = (byte)-1;
                this.minSize = TermVar.super.getMinSize();
                this.minSizeBuildStage = 1;
            }
            return this.minSize;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.attachmentsBuildStage == -1) {
                attributes.add("attachments");
            }
            if (this.minSizeBuildStage == -1) {
                attributes.add("minSize");
            }
            return "Cannot build TermVar, attribute initializers form cycle " + attributes;
        }
    }
}

