/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;

public interface ITermBuild {
    default public IApplTerm newAppl(String op, ITerm ... args) {
        return this.newAppl(op, Arrays.asList(args));
    }

    default public IApplTerm newAppl(String op, Iterable<? extends ITerm> args) {
        return this.newAppl(op, args, null);
    }

    public IApplTerm newAppl(String var1, Iterable<? extends ITerm> var2, @Nullable IAttachments var3);

    default public ITerm newTuple(ITerm ... args) {
        return this.newTuple(Arrays.asList(args));
    }

    default public ITerm newTuple(Iterable<? extends ITerm> args) {
        return this.newTuple(args, null);
    }

    default public ITerm newTuple(Iterable<? extends ITerm> args, @Nullable IAttachments attachments) {
        return Iterables.size(args) == 1 ? (ITerm)Iterables.getOnlyElement(args) : this.newAppl("", args, attachments);
    }

    default public IListTerm newList(ITerm ... elems) {
        return this.newList(Arrays.asList(elems));
    }

    default public IListTerm newList(Iterable<? extends ITerm> elems) {
        return this.newList(elems, null);
    }

    default public IListTerm newList(Iterable<? extends ITerm> elems, @Nullable Iterable<IAttachments> attachments) {
        LinkedList attachmentsQueue;
        LinkedList elemsQueue = Lists.newLinkedList(elems);
        LinkedList linkedList = attachmentsQueue = attachments != null ? Lists.newLinkedList(attachments) : null;
        if (attachmentsQueue != null && attachmentsQueue.size() != elemsQueue.size() + 1) {
            throw new IllegalArgumentException("Number of attachments does not correspond to number of elements in the list.");
        }
        IListTerm list2 = this.newNil();
        if (attachmentsQueue != null) {
            list2 = list2.withAttachments((IAttachments)attachmentsQueue.removeLast());
        }
        return this.newListTail(elemsQueue, list2, attachmentsQueue);
    }

    default public IListTerm newListTail(Iterable<? extends ITerm> elems, IListTerm list2) {
        return this.newListTail(elems, list2, null);
    }

    default public IListTerm newListTail(Iterable<? extends ITerm> elems, IListTerm list2, @Nullable Iterable<IAttachments> attachments) {
        LinkedList attachmentsQueue;
        LinkedList elemsQueue = Lists.newLinkedList(elems);
        LinkedList linkedList = attachmentsQueue = attachments != null ? Lists.newLinkedList(attachments) : null;
        if (attachmentsQueue != null && attachmentsQueue.size() != elemsQueue.size()) {
            throw new IllegalArgumentException("Number of attachments does not correspond to number of elements in the list.");
        }
        return this.newListTail(elemsQueue, list2, attachmentsQueue);
    }

    default public IListTerm newListTail(LinkedList<? extends ITerm> elems, IListTerm list2, @Nullable LinkedList<IAttachments> attachments) {
        while (!elems.isEmpty()) {
            list2 = this.newCons(elems.removeLast(), list2);
            if (attachments == null) continue;
            list2 = list2.withAttachments(attachments.removeLast());
        }
        return list2;
    }

    default public INilTerm newNil() {
        return this.newNil(null);
    }

    public INilTerm newNil(@Nullable IAttachments var1);

    default public IConsTerm newCons(ITerm head, IListTerm tail) {
        return this.newCons(head, tail, null);
    }

    public IConsTerm newCons(ITerm var1, IListTerm var2, @Nullable IAttachments var3);

    default public IStringTerm newString(String value) {
        return this.newString(value, null);
    }

    public IStringTerm newString(String var1, @Nullable IAttachments var2);

    default public IIntTerm newInt(int value) {
        return this.newInt(value, null);
    }

    public IIntTerm newInt(int var1, @Nullable IAttachments var2);

    default public IBlobTerm newBlob(Object value) {
        return this.newBlob(value, null);
    }

    public IBlobTerm newBlob(Object var1, @Nullable IAttachments var2);

    default public ITermVar newVar(String resource, String name2) {
        return this.newVar(resource, name2, null);
    }

    public ITermVar newVar(String var1, String var2, @Nullable IAttachments var3);
}

